/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL.MCLContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL.RunMCL;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class MCLCluster
extends AbstractNetworkClusterer {
    RunMCL runMCL;
    public static String SHORTNAME = "mcl";
    public static String NAME = "MCL Cluster";
    public static final String GROUP_ATTRIBUTE = "__MCLGroups.SUID";
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public MCLContext context = null;

    public MCLCluster(MCLContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public void run(TaskMonitor monitor) {
        DistanceMatrix matrix;
        monitor.setTitle("Performing MCL cluster");
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if ((matrix = this.context.edgeAttributeHandler.getMatrix()) == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.clusterAttributeName = this.context.getClusterAttribute();
        this.createGroups = this.context.advancedAttributes.createGroups;
        if (this.canceled) {
            return;
        }
        this.runMCL = new RunMCL(matrix, this.context.inflation_parameter, this.context.iterations, this.context.clusteringThresh, this.context.maxResidual, this.context.maxThreads, monitor);
        this.runMCL.setDebug(this.debug);
        if (this.canceled) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Clustering...");
        List<NodeCluster> clusters = this.runMCL.run(this.network, monitor);
        if (clusters == null) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "MCL results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    public void cancel() {
        this.canceled = true;
        this.runMCL.cancel();
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }
}

