/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class MCLContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @Tunable(description="Granularity parameter (inflation value)", groups={"Basic MCL Tuning"}, gravity=1.0)
    public double inflation_parameter = 2.5;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @Tunable(description="Weak edge weight pruning threshold", groups={"MCL Advanced Settings"}, params="displayState=collapsed", gravity=20.0)
    public double clusteringThresh = 1.0E-15;
    @Tunable(description="Number of iterations", groups={"MCL Advanced Settings"}, gravity=21.0)
    public int iterations = 16;
    @Tunable(description="Maximum residual value", groups={"MCL Advanced Settings"}, gravity=22.0)
    public double maxResidual = 0.001;
    @Tunable(description="Maximum number of threads", groups={"MCL Advanced Settings"}, gravity=23.0)
    public int maxThreads = 0;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public MCLContext() {
        this.advancedAttributes = new AdvancedProperties("__mclCluster", false);
    }

    public MCLContext(MCLContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__mclCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.inflation_parameter = origin.inflation_parameter;
        this.clusteringThresh = origin.clusteringThresh;
        this.iterations = origin.iterations;
        this.maxResidual = origin.maxResidual;
        this.maxThreads = origin.maxThreads;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }
}

