/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMCL {
    private double inflationParameter;
    private int number_iterations;
    private double clusteringThresh;
    private double maxResidual;
    private List<CyNode> nodes;
    private List<CyEdge> edges;
    private boolean canceled = false;
    protected int clusterCount = 0;
    private boolean createMetaNodes = false;
    private DistanceMatrix distanceMatrix = null;
    private DoubleMatrix2D matrix = null;
    private boolean debug = false;
    private int nThreads = Runtime.getRuntime().availableProcessors() - 1;

    public RunMCL(DistanceMatrix dMat, double inflationParameter, int num_iterations, double clusteringThresh, double maxResidual, int maxThreads, TaskMonitor monitor) {
        this.distanceMatrix = dMat;
        this.inflationParameter = inflationParameter;
        this.number_iterations = num_iterations;
        this.clusteringThresh = clusteringThresh;
        this.maxResidual = maxResidual;
        this.nodes = this.distanceMatrix.getNodes();
        this.edges = this.distanceMatrix.getEdges();
        this.matrix = this.distanceMatrix.getDistanceMatrix();
        this.nThreads = maxThreads > 0 ? maxThreads : Runtime.getRuntime().availableProcessors() - 1;
        monitor.showMessage(TaskMonitor.Level.INFO, "InflationParameter = " + inflationParameter);
        monitor.showMessage(TaskMonitor.Level.INFO, "Iterations = " + num_iterations);
        monitor.showMessage(TaskMonitor.Level.INFO, "Clustering Threshold = " + clusteringThresh);
        monitor.showMessage(TaskMonitor.Level.INFO, "Threads = " + this.nThreads);
        monitor.showMessage(TaskMonitor.Level.INFO, "Matrix info: = " + this.distanceMatrix.printMatrixInfo(this.matrix));
    }

    public void cancel() {
        this.canceled = true;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<NodeCluster> run(CyNetwork network, TaskMonitor monitor) {
        Long networkID = network.getSUID();
        long startTime = System.currentTimeMillis();
        this.debugln("Initial matrix:");
        this.printMatrix(this.matrix);
        this.normalize(this.matrix, this.clusteringThresh, false);
        this.debugln("Normalized matrix:");
        this.printMatrix(this.matrix);
        double residual = 1.0;
        MatrixPow myPow = new MatrixPow(this.inflationParameter);
        for (int i = 0; i < this.number_iterations && residual > this.maxResidual; ++i) {
            long t = System.currentTimeMillis();
            monitor.setStatusMessage("Iteration: " + (i + 1) + " expanding ");
            if (this.nThreads > 1) {
                this.matrix = this.multiplyMatrix(this.matrix, this.matrix);
            } else {
                DoubleMatrix2D newMatrix = DoubleFactory2D.sparse.make(this.matrix.rows(), this.matrix.columns());
                this.matrix = this.matrix.zMult(this.matrix, newMatrix);
            }
            this.normalize(this.matrix, this.clusteringThresh, false);
            monitor.showMessage(TaskMonitor.Level.INFO, "Expansion " + (i + 1) + " took " + (System.currentTimeMillis() - t) + "ms");
            t = System.currentTimeMillis();
            monitor.setStatusMessage("Iteration: " + (i + 1) + " inflating");
            this.matrix.forEachNonZero((IntIntDoubleFunction)myPow);
            this.normalize(this.matrix, this.clusteringThresh, true);
            this.matrix.trimToSize();
            residual = this.calculateResiduals(this.matrix);
            if (!this.canceled) continue;
            monitor.setStatusMessage("canceled");
            return null;
        }
        monitor.setStatusMessage("Assigning nodes to clusters");
        this.clusterCount = 0;
        HashMap<Integer, NodeCluster> clusterMap = new HashMap<Integer, NodeCluster>();
        this.matrix.forEachNonZero((IntIntDoubleFunction)new ClusterMatrix(clusterMap));
        monitor.setStatusMessage("Created " + this.clusterCount + " clusters");
        monitor.setStatusMessage("Cluster map has " + clusterMap.keySet().size() + " clusters");
        if (this.clusterCount == 0) {
            monitor.setStatusMessage("Created 0 clusters!!!!");
            monitor.setStatusMessage("Cluster map has " + clusterMap.keySet().size() + " clusters");
            return null;
        }
        int clusterNumber = 1;
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        for (NodeCluster cluster2 : NodeCluster.sortMap(clusterMap)) {
            if (cMap.containsKey(cluster2)) continue;
            cMap.put(cluster2, cluster2);
            cluster2.setClusterNumber(clusterNumber);
            ++clusterNumber;
        }
        monitor.setStatusMessage("Total runtime = " + (System.currentTimeMillis() - startTime) + "ms");
        Set clusters = cMap.keySet();
        return new ArrayList<NodeCluster>(clusters);
    }

    private void normalize(DoubleMatrix2D matrix, double clusteringThresh, boolean prune) {
        double[] sums = new double[matrix.columns()];
        matrix.forEachNonZero((IntIntDoubleFunction)new MatrixZeroAndSum(prune, clusteringThresh, sums));
        matrix.forEachNonZero((IntIntDoubleFunction)new MatrixNormalize(sums));
        for (int col = 0; col < sums.length; ++col) {
            if (sums[col] != 0.0) continue;
            matrix.set(col, col, 1.0);
        }
    }

    private void normalizeWeights(DoubleMatrix2D matrix, double min, double max) {
        matrix.forEachNonZero((IntIntDoubleFunction)new MatrixNormalizeWeights(min, max));
    }

    private double calculateResiduals(DoubleMatrix2D matrix) {
        double[] sums = new double[matrix.columns()];
        double[] sumSquares = new double[matrix.columns()];
        matrix.forEachNonZero((IntIntDoubleFunction)new MatrixSumAndSumSq(sums, sumSquares));
        double residual = 0.0;
        for (int i = 0; i < sums.length; ++i) {
            residual = Math.max(residual, sums[i] - sumSquares[i]);
        }
        return residual;
    }

    private void printMatrixInfo(DoubleMatrix2D matrix) {
        this.debugln("Matrix(" + matrix.rows() + ", " + matrix.columns() + ")");
        if (matrix.getClass().getName().indexOf("Sparse") >= 0) {
            this.debugln(" matrix is sparse");
        } else {
            this.debugln(" matrix is dense");
        }
        this.debugln(" cardinality is " + matrix.cardinality());
    }

    private void printMatrix(DoubleMatrix2D matrix) {
        for (int row = 0; row < matrix.rows(); ++row) {
            this.debug(this.nodes.get(row).getSUID() + ":\t");
            for (int col = 0; col < matrix.columns(); ++col) {
                this.debug("" + matrix.get(row, col) + "\t");
            }
            this.debugln();
        }
        this.debugln("Matrix(" + matrix.rows() + ", " + matrix.columns() + ")");
        if (matrix.getClass().getName().indexOf("Sparse") >= 0) {
            this.debugln(" matrix is sparse");
        } else {
            this.debugln(" matrix is dense");
        }
        this.debugln(" cardinality is " + matrix.cardinality());
    }

    private void debugln(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private void debugln() {
        if (this.debug) {
            System.out.println();
        }
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.print(message);
        }
    }

    private DoubleMatrix2D multiplyMatrix(DoubleMatrix2D A, DoubleMatrix2D B) {
        int pool;
        int m = A.rows();
        int n = A.columns();
        int p = B.columns();
        final DoubleMatrix1D[] Brows = new DoubleMatrix1D[n];
        int i = n;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final DoubleMatrix1D[] Crows = new DoubleMatrix1D[n];
        int i2 = m;
        while (--i2 >= 0) {
            Crows[i2] = B.like1D(m);
        }
        final ExecutorService[] threadPools = new ExecutorService[this.nThreads];
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool] = Executors.newFixedThreadPool(1);
        }
        A.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int row, int column, double value) {
                ThreadedDotProduct r = new ThreadedDotProduct(value, Brows[column], Crows[row]);
                threadPools[row % RunMCL.this.nThreads].submit(r);
                return value;
            }
        });
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool].shutdown();
            try {
                boolean result = threadPools[pool].awaitTermination(7L, TimeUnit.DAYS);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.create2DMatrix(Crows);
    }

    private DoubleMatrix2D create2DMatrix(DoubleMatrix1D[] rows) {
        int columns = (int)rows[0].size();
        DoubleMatrix2D C = DoubleFactory2D.sparse.make(rows.length, columns);
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < columns; ++col) {
                double value = rows[row].getQuick(col);
                if (value == 0.0) continue;
                C.setQuick(row, col, value);
            }
        }
        return C;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterMatrix
    implements IntIntDoubleFunction {
        Map<Integer, NodeCluster> clusterMap;

        public ClusterMatrix(Map<Integer, NodeCluster> clusterMap) {
            this.clusterMap = clusterMap;
        }

        public double apply(int row, int column, double value) {
            if (RunMCL.this.canceled) {
                return 0.0;
            }
            if (row == column) {
                return value;
            }
            if (this.clusterMap.containsKey(column)) {
                NodeCluster columnCluster = this.clusterMap.get(column);
                if (this.clusterMap.containsKey(row)) {
                    NodeCluster rowCluster = this.clusterMap.get(row);
                    if (rowCluster == columnCluster) {
                        return value;
                    }
                    --RunMCL.this.clusterCount;
                    columnCluster.addAll(rowCluster);
                } else {
                    columnCluster.add(RunMCL.this.nodes, row);
                }
                this.updateClusters(columnCluster);
            } else {
                NodeCluster rowCluster;
                if (this.clusterMap.containsKey(row)) {
                    rowCluster = this.clusterMap.get(row);
                    rowCluster.add(RunMCL.this.nodes, column);
                } else {
                    ++RunMCL.this.clusterCount;
                    rowCluster = new NodeCluster();
                    rowCluster.add(RunMCL.this.nodes, column);
                    rowCluster.add(RunMCL.this.nodes, row);
                }
                this.updateClusters(rowCluster);
            }
            return value;
        }

        private void updateClusters(NodeCluster cl) {
            for (CyNode node : cl) {
                this.clusterMap.put(RunMCL.this.nodes.indexOf(node), cl);
            }
        }
    }

    private class MatrixNormalizeWeights
    implements IntIntDoubleFunction {
        double min;
        double max;

        public MatrixNormalizeWeights(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double apply(int row, int column, double value) {
            return (value - this.min) / (this.max - this.min);
        }
    }

    private class MatrixNormalize
    implements IntIntDoubleFunction {
        double[] colSums;

        public MatrixNormalize(double[] colSums) {
            this.colSums = colSums;
        }

        public double apply(int row, int column, double value) {
            if (RunMCL.this.canceled) {
                return 0.0;
            }
            return value / this.colSums[column];
        }
    }

    private class MatrixSumAndSumSq
    implements IntIntDoubleFunction {
        double[] sumSquares;
        double[] colSums;

        public MatrixSumAndSumSq(double[] colSums, double[] sumSquares) {
            this.sumSquares = sumSquares;
            this.colSums = colSums;
        }

        public double apply(int row, int column, double value) {
            int n = column;
            this.colSums[n] = this.colSums[n] + value;
            int n2 = column;
            this.sumSquares[n2] = this.sumSquares[n2] + value * value;
            return value;
        }
    }

    private class MatrixZeroAndSum
    implements IntIntDoubleFunction {
        double threshold;
        double[] colSums;
        boolean prune;

        public MatrixZeroAndSum(boolean prune, double threshold, double[] colSums) {
            this.threshold = threshold;
            this.colSums = colSums;
            this.prune = prune;
        }

        public double apply(int row, int column, double value) {
            if (this.prune && value < this.threshold) {
                return 0.0;
            }
            int n = column;
            this.colSums[n] = this.colSums[n] + value;
            return value;
        }
    }

    private class MatrixPow
    implements IntIntDoubleFunction {
        double pow;

        public MatrixPow(double power) {
            this.pow = power;
        }

        public double apply(int row, int column, double value) {
            if (RunMCL.this.canceled) {
                return 0.0;
            }
            return Math.pow(value, this.pow);
        }
    }

    private class ThreadedDotProduct
    implements Runnable {
        double value;
        DoubleMatrix1D Bcol;
        DoubleMatrix1D Crow;

        ThreadedDotProduct(double value, DoubleMatrix1D Bcol, DoubleMatrix1D Crow) {
            this.value = value;
            this.Bcol = Bcol;
            this.Crow = Crow;
        }

        public void run() {
            int k = 0;
            while ((long)k < this.Bcol.size()) {
                if (this.Bcol.getQuick(k) != 0.0) {
                    this.Crow.setQuick(k, this.Crow.getQuick(k) + this.Bcol.getQuick(k) * this.value);
                }
                ++k;
            }
        }
    }
}

