/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODEClusterObj;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODECurrentParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODEParameterSet;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCODEAlgorithm {
    private boolean cancelled = false;
    private TaskMonitor taskMonitor = null;
    private Map<CyNode, NodeInfo> currentNodeInfoHashMap = null;
    private TreeMap<Double, List<CyNode>> currentNodeScoreSortedMap = null;
    private Map<String, TreeMap<Double, List<CyNode>>> nodeScoreResultsMap = new HashMap<String, TreeMap<Double, List<CyNode>>>();
    private Map<String, Map<CyNode, NodeInfo>> nodeInfoResultsMap = new HashMap<String, Map<CyNode, NodeInfo>>();
    private MCODEParameterSet params;
    private long lastScoreTime;
    private long lastFindTime;

    public MCODEAlgorithm(String networkID, TaskMonitor monitor) {
        this.params = MCODECurrentParameters.getInstance().getParamsCopy(networkID);
        this.taskMonitor = monitor;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor, String networkID) {
        this.params = MCODECurrentParameters.getInstance().getParamsCopy(networkID);
        this.taskMonitor = taskMonitor;
    }

    public long getLastScoreTime() {
        return this.lastScoreTime;
    }

    public long getLastFindTime() {
        return this.lastFindTime;
    }

    public MCODEParameterSet getParams() {
        return this.params;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Double getNodeScore(CyNode node, String resultTitle) {
        TreeMap<Double, List<CyNode>> nodeScoreSortedMap = this.nodeScoreResultsMap.get(resultTitle);
        for (Double nodeScore : nodeScoreSortedMap.keySet()) {
            List<CyNode> nodes = nodeScoreSortedMap.get(nodeScore);
            if (!nodes.contains(node)) continue;
            return nodeScore;
        }
        return new Double(0.0);
    }

    public double getMaxScore(String resultTitle) {
        TreeMap<Double, List<CyNode>> nodeScoreSortedMap = this.nodeScoreResultsMap.get(resultTitle);
        Double nodeScore = nodeScoreSortedMap.firstKey();
        return nodeScore;
    }

    public void scoreGraph(CyNetwork inputNetwork, String resultTitle) {
        this.params = this.getParams();
        String callerID = "MCODEAlgorithm.MCODEAlgorithm";
        if (inputNetwork == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": inputNetwork was null.");
            return;
        }
        long msTimeBefore = System.currentTimeMillis();
        HashMap<CyNode, NodeInfo> nodeInfoHashMap = new HashMap<CyNode, NodeInfo>(inputNetwork.getNodeCount());
        TreeMap nodeScoreSortedMap = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                double d2;
                double d1 = (Double)o1;
                if (d1 == (d2 = ((Double)o2).doubleValue())) {
                    return 0;
                }
                if (d1 < d2) {
                    return 1;
                }
                return -1;
            }
        });
        NodeInfo nodeInfo = null;
        int i = 0;
        for (CyNode n : inputNetwork.getNodeList()) {
            List<CyNode> al;
            if (this.cancelled) break;
            nodeInfo = this.calcNodeInfo(inputNetwork, n);
            nodeInfoHashMap.put(n, nodeInfo);
            double nodeScore = this.scoreNode(nodeInfo);
            if (nodeScoreSortedMap.containsKey(new Double(nodeScore))) {
                al = (List)nodeScoreSortedMap.get(new Double(nodeScore));
                al.add(n);
            } else {
                al = new ArrayList<CyNode>();
                al.add(n);
                nodeScoreSortedMap.put(new Double(nodeScore), al);
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setProgress((double)(++i) / (double)inputNetwork.getNodeCount());
        }
        this.nodeScoreResultsMap.put(resultTitle, nodeScoreSortedMap);
        this.nodeInfoResultsMap.put(resultTitle, nodeInfoHashMap);
        this.currentNodeScoreSortedMap = nodeScoreSortedMap;
        this.currentNodeInfoHashMap = nodeInfoHashMap;
        long msTimeAfter = System.currentTimeMillis();
        this.lastScoreTime = msTimeAfter - msTimeBefore;
    }

    public List<NodeCluster> findClusters(CyNetwork inputNetwork, String resultTitle) {
        HashMap nodeInfoHashMap;
        TreeMap<Double, List<CyNode>> nodeScoreSortedMap;
        if (!this.nodeScoreResultsMap.containsKey(resultTitle)) {
            nodeScoreSortedMap = this.currentNodeScoreSortedMap;
            nodeInfoHashMap = this.currentNodeInfoHashMap;
            this.nodeScoreResultsMap.put(resultTitle, nodeScoreSortedMap);
            this.nodeInfoResultsMap.put(resultTitle, nodeInfoHashMap);
        } else {
            nodeScoreSortedMap = this.nodeScoreResultsMap.get(resultTitle);
            nodeInfoHashMap = (HashMap)this.nodeInfoResultsMap.get(resultTitle);
        }
        this.params = this.getParams();
        String callerID = "MCODEAlgorithm.findClusters";
        if (inputNetwork == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": inputNetwork was null.");
            return null;
        }
        if (nodeInfoHashMap == null || nodeScoreSortedMap == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": nodeInfoHashMap or nodeScoreSortedMap was null.");
            return null;
        }
        long msTimeBefore = System.currentTimeMillis();
        HashMap<CyNode, Boolean> nodeSeenHashMap = new HashMap<CyNode, Boolean>();
        int findingProgress = 0;
        int findingTotal = 0;
        Collection<List<CyNode>> values = nodeScoreSortedMap.values();
        for (List<CyNode> nodeList : values) {
            findingTotal += nodeList.size();
        }
        ArrayList<MCODEClusterObj> alClusters = new ArrayList<MCODEClusterObj>();
        block1: for (List<CyNode> nodeList : values) {
            for (CyNode currentNode : nodeList) {
                double oldProgress;
                double newProgress;
                if (!nodeSeenHashMap.containsKey(currentNode)) {
                    MCODEClusterObj currentCluster = new MCODEClusterObj();
                    currentCluster.setSeedNode(currentNode);
                    HashMap<CyNode, Boolean> nodeSeenHashMapSnapShot = new HashMap<CyNode, Boolean>((HashMap)nodeSeenHashMap.clone());
                    List<CyNode> alCluster = this.getClusterCore(currentNode, nodeSeenHashMap, this.params.getNodeScoreCutoff(), this.params.getMaxDepthFromStart(), nodeInfoHashMap);
                    if (alCluster.size() > 0) {
                        CyNetwork gpCluster;
                        if (!alCluster.contains(currentNode)) {
                            alCluster.add(currentNode);
                        }
                        if (!this.filterCluster(gpCluster = this.createCyNetwork(alCluster, inputNetwork))) {
                            if (this.params.isHaircut()) {
                                this.haircutCluster(gpCluster, alCluster, inputNetwork);
                            }
                            if (this.params.isFluff()) {
                                this.fluffClusterBoundary(alCluster, nodeSeenHashMap, nodeInfoHashMap);
                            }
                            currentCluster.setALCluster(alCluster);
                            gpCluster = this.createCyNetwork(alCluster, inputNetwork);
                            currentCluster.setGPCluster(gpCluster);
                            currentCluster.setClusterScore(this.scoreCluster(currentCluster));
                            currentCluster.setNodeSeenHashMap(nodeSeenHashMapSnapShot);
                            currentCluster.setResultTitle(resultTitle);
                            alClusters.add(currentCluster);
                        }
                    }
                }
                if (this.taskMonitor != null && (newProgress = (double)(++findingProgress) / (double)findingTotal) != (oldProgress = (double)(findingProgress - 1) / (double)findingTotal)) {
                    this.taskMonitor.setProgress(newProgress);
                }
                if (!this.cancelled) continue;
                continue block1;
            }
        }
        ArrayList<MCODEClusterObj> selectedALClusters = new ArrayList<MCODEClusterObj>();
        if (!this.params.getScope().equals(MCODEParameterSet.NETWORK)) {
            for (MCODEClusterObj cluster2 : alClusters) {
                List<CyNode> alCluster = cluster2.getALCluster();
                ArrayList<CyNode> alSelectedNodes = new ArrayList<CyNode>(this.params.getSelectedNodes());
                boolean hit = false;
                for (CyNode node : alSelectedNodes) {
                    if (!alCluster.contains(node)) continue;
                    hit = true;
                }
                if (!hit) continue;
                selectedALClusters.add(cluster2);
            }
            alClusters = selectedALClusters;
        }
        ArrayList<NodeCluster> clusters = new ArrayList<NodeCluster>();
        for (MCODEClusterObj c : alClusters) {
            clusters.add(c.getNodeCluster());
        }
        long msTimeAfter = System.currentTimeMillis();
        this.lastFindTime = msTimeAfter - msTimeBefore;
        return clusters;
    }

    private List<CyNode> getCyNodeList(List<Long> suidList, CyNetwork inputNetwork) {
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>(suidList.size());
        for (Long suid : suidList) {
            nodeList.add(inputNetwork.getNode(suid.longValue()));
        }
        return nodeList;
    }

    private CyNetwork createCyNetwork(List<CyNode> nodeList, CyNetwork inputNetwork) {
        List<CyEdge> edgeList = ModelUtils.getConnectingEdges(inputNetwork, nodeList);
        CySubNetwork gpCluster = ((CySubNetwork)inputNetwork).getRootNetwork().addSubNetwork(nodeList, edgeList);
        return gpCluster;
    }

    private double scoreNode(NodeInfo nodeInfo) {
        nodeInfo.score = nodeInfo.numNodeNeighbors > this.params.getDegreeCutoff() ? nodeInfo.coreDensity * (double)nodeInfo.coreLevel : 0.0;
        return nodeInfo.score;
    }

    public double scoreCluster(MCODEClusterObj cluster2) {
        int numNodes = 0;
        double density = 0.0;
        double score = 0.0;
        numNodes = cluster2.getGPCluster().getNodeCount();
        density = this.calcDensity(cluster2.getGPCluster(), true);
        score = density * (double)numNodes;
        return score;
    }

    private NodeInfo calcNodeInfo(CyNetwork inputNetwork, CyNode node) {
        CyNetwork gpNodeNeighborhood;
        String callerID = "MCODEAlgorithm.calcNodeInfo";
        if (inputNetwork == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": gpInputGraph was null.");
            return null;
        }
        List neighborList = inputNetwork.getNeighborList(node, CyEdge.Type.ANY);
        if (neighborList.size() < 2) {
            NodeInfo nodeInfo = new NodeInfo();
            if (neighborList.size() == 1) {
                nodeInfo.coreLevel = 1;
                nodeInfo.coreDensity = 1.0;
                nodeInfo.density = 1.0;
            }
            return nodeInfo;
        }
        if (!neighborList.contains(node)) {
            neighborList.add(node);
        }
        if ((gpNodeNeighborhood = this.createCyNetwork(neighborList, inputNetwork)) == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": gpNodeNeighborhood was null.");
            return null;
        }
        NodeInfo nodeInfo = new NodeInfo();
        if (gpNodeNeighborhood != null) {
            nodeInfo.density = this.calcDensity(gpNodeNeighborhood, this.params.isIncludeLoops());
        }
        nodeInfo.numNodeNeighbors = neighborList.size();
        Object[] returnArray = this.getHighestKCore(gpNodeNeighborhood);
        Integer k = (Integer)returnArray[0];
        CyNetwork gpCore = (CyNetwork)returnArray[1];
        nodeInfo.coreLevel = k;
        if (gpCore != null) {
            nodeInfo.coreDensity = this.calcDensity(gpCore, this.params.isIncludeLoops());
        }
        nodeInfo.nodeNeighbors = neighborList;
        return nodeInfo;
    }

    private List<CyNode> getClusterCore(CyNode startNode, Map<CyNode, Boolean> nodeSeenHashMap, double nodeScoreCutoff, int maxDepthFromStart, Map<CyNode, NodeInfo> nodeInfoHashMap) {
        ArrayList<CyNode> cluster2 = new ArrayList<CyNode>();
        this.getClusterCoreInternal(startNode, nodeSeenHashMap, nodeInfoHashMap.get((Object)startNode).score, 1, cluster2, nodeScoreCutoff, maxDepthFromStart, nodeInfoHashMap);
        return cluster2;
    }

    private boolean getClusterCoreInternal(CyNode startNode, Map<CyNode, Boolean> nodeSeenHashMap, double startNodeScore, int currentDepth, List<CyNode> cluster2, double nodeScoreCutoff, int maxDepthFromStart, Map<CyNode, NodeInfo> nodeInfoHashMap) {
        if (nodeSeenHashMap.containsKey(startNode)) {
            return true;
        }
        nodeSeenHashMap.put(startNode, new Boolean(true));
        if (currentDepth > maxDepthFromStart) {
            return true;
        }
        for (CyNode currentNeighbor : nodeInfoHashMap.get((Object)startNode).nodeNeighbors) {
            if (nodeSeenHashMap.containsKey(currentNeighbor) || !(nodeInfoHashMap.get((Object)currentNeighbor).score >= startNodeScore - startNodeScore * nodeScoreCutoff)) continue;
            if (!cluster2.contains(currentNeighbor)) {
                cluster2.add(currentNeighbor);
            }
            this.getClusterCoreInternal(currentNeighbor, nodeSeenHashMap, startNodeScore, currentDepth + 1, cluster2, nodeScoreCutoff, maxDepthFromStart, nodeInfoHashMap);
        }
        return true;
    }

    private boolean fluffClusterBoundary(List<CyNode> cluster2, Map<CyNode, Boolean> nodeSeenHashMap, Map<CyNode, NodeInfo> nodeInfoHashMap) {
        ArrayList<CyNode> nodesToAdd = new ArrayList<CyNode>();
        HashMap<CyNode, Boolean> nodeSeenHashMapInternal = new HashMap<CyNode, Boolean>();
        for (CyNode currentNode : cluster2) {
            for (CyNode nodeNeighbor : nodeInfoHashMap.get((Object)currentNode).nodeNeighbors) {
                if (nodeSeenHashMap.containsKey(nodeNeighbor) || nodeSeenHashMapInternal.containsKey(nodeNeighbor) || !(nodeInfoHashMap.get((Object)nodeNeighbor).density > this.params.getFluffNodeDensityCutoff())) continue;
                nodesToAdd.add(nodeNeighbor);
                nodeSeenHashMapInternal.put(nodeNeighbor, new Boolean(true));
            }
        }
        if (nodesToAdd.size() > 0) {
            cluster2.addAll(nodesToAdd.subList(0, nodesToAdd.size()));
        }
        return true;
    }

    private boolean filterCluster(CyNetwork gpClusterGraph) {
        if (gpClusterGraph == null) {
            return true;
        }
        CyNetwork gpCore = this.getKCore(gpClusterGraph, this.params.getKCore());
        return gpCore == null;
    }

    private boolean haircutCluster(CyNetwork gpClusterGraph, List<CyNode> cluster2, CyNetwork gpInputGraph) {
        CyNetwork gpCore = this.getKCore(gpClusterGraph, 2);
        if (gpCore != null) {
            cluster2.clear();
            for (CyNode node : gpCore.getNodeList()) {
                cluster2.add(node);
            }
        }
        return true;
    }

    public double calcDensity(CyNetwork gpInputGraph, boolean includeLoops) {
        int possibleEdgeNum = 0;
        int actualEdgeNum = 0;
        int loopCount = 0;
        double density = 0.0;
        int nodeCount = gpInputGraph.getNodeCount();
        int edgeCount = gpInputGraph.getEdgeCount();
        String callerID = "MCODEAlgorithm.calcDensity";
        if (gpInputGraph == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": gpInputGraph was null.");
            return -1.0;
        }
        if (!includeLoops) {
            for (CyNode node : gpInputGraph.getNodeList()) {
                List loopEdges = gpInputGraph.getConnectingEdgeList(node, node, CyEdge.Type.ANY);
                if (loopEdges == null || loopEdges.size() <= 0) continue;
                ++loopCount;
            }
            possibleEdgeNum = nodeCount * (nodeCount - 1) / 2;
            actualEdgeNum = edgeCount - loopCount;
        } else {
            possibleEdgeNum = nodeCount * (nodeCount + 1) / 2;
            actualEdgeNum = edgeCount;
        }
        density = (double)actualEdgeNum / (double)possibleEdgeNum;
        return density;
    }

    public CyNetwork getKCore(CyNetwork gpInputGraph, int k) {
        String callerID = "MCODEAlgorithm.getKCore";
        if (gpInputGraph == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": gpInputGraph was null.");
            return null;
        }
        boolean firstLoop = true;
        CyNetwork gpOutputGraph = null;
        while (true) {
            int numDeleted = 0;
            ArrayList<CyNode> alCoreNodeIndices = new ArrayList<CyNode>(gpInputGraph.getNodeCount());
            for (CyNode n : gpInputGraph.getNodeList()) {
                if (gpInputGraph.getNeighborList(n, CyEdge.Type.ANY).size() >= k) {
                    alCoreNodeIndices.add(n);
                    continue;
                }
                ++numDeleted;
            }
            if (numDeleted <= 0 && !firstLoop) break;
            gpOutputGraph = this.createCyNetwork(alCoreNodeIndices, gpInputGraph);
            if (gpOutputGraph.getNodeCount() == 0) {
                return null;
            }
            gpInputGraph = gpOutputGraph;
            if (!firstLoop) continue;
            firstLoop = false;
        }
        return gpOutputGraph;
    }

    public Object[] getHighestKCore(CyNetwork gpInputGraph) {
        String callerID = "MCODEAlgorithm.getHighestKCore";
        if (gpInputGraph == null) {
            this.taskMonitor.showMessage(TaskMonitor.Level.ERROR, "In " + callerID + ": gpInputGraph was null.");
            return null;
        }
        int i = 1;
        CyNetwork gpCurCore = null;
        CyNetwork gpPrevCore = null;
        while ((gpCurCore = this.getKCore(gpInputGraph, i)) != null) {
            gpInputGraph = gpCurCore;
            gpPrevCore = gpCurCore;
            ++i;
        }
        Integer k = new Integer(i - 1);
        Object[] returnArray = new Object[]{k, gpPrevCore};
        return returnArray;
    }

    private class NodeInfo {
        double density = 0.0;
        int numNodeNeighbors = 0;
        List<CyNode> nodeNeighbors = new ArrayList<CyNode>();
        int coreLevel = 0;
        double coreDensity = 0.0;
        double score;
    }
}

