/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODEContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODECurrentParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODEParameterSet;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.RunMCODE;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCODECluster
extends AbstractNetworkClusterer {
    public static String SHORTNAME = "mcode";
    public static String NAME = "MCODE Cluster";
    public static final String GROUP_ATTRIBUTE = SHORTNAME;
    static final int FIRST_TIME = 0;
    static final int RESCORE = 1;
    static final int REFIND = 2;
    static final int INTERRUPTION = 3;
    int analyze = 0;
    MCODEParameterSet currentParamsCopy;
    RunMCODE runMCODE;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public MCODEContext context = null;

    public MCODECluster(MCODEContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        this.currentParamsCopy = MCODECurrentParameters.getInstance().getParamsCopy(null);
        this.currentParamsCopy.setDefaultParams();
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void updateSettings() {
        if (this.currentParamsCopy == null) {
            this.currentParamsCopy = new MCODEParameterSet();
        }
        if (this.context.selectedOnly) {
            this.currentParamsCopy.setScope(MCODEParameterSet.SELECTION);
        } else {
            this.currentParamsCopy.setScope(MCODEParameterSet.NETWORK);
        }
        this.currentParamsCopy.setIncludeLoops(this.context.includeLoops);
        this.currentParamsCopy.setDegreeCutoff(this.context.degreeCutoff);
        this.currentParamsCopy.setHaircut(this.context.haircut);
        this.currentParamsCopy.setFluff(this.context.fluff);
        this.currentParamsCopy.setNodeScoreCutoff(this.context.scoreCutoff);
        this.currentParamsCopy.setKCore(this.context.kCore);
        this.currentParamsCopy.setMaxDepthFromStart(this.context.maxDepth);
    }

    public void run(TaskMonitor monitor) {
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        this.updateSettings();
        NodeCluster.init();
        if (this.currentParamsCopy.getScope().equals(MCODEParameterSet.SELECTION)) {
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
            this.currentParamsCopy.setSelectedNodes(selectedNodes);
        }
        MCODECurrentParameters.getInstance().setParams(this.currentParamsCopy, "MCODE Result", ModelUtils.getNetworkName(this.network));
        this.runMCODE = new RunMCODE(1, "MCODE", this.network, monitor);
        List<NodeCluster> clusters = this.runMCODE.run(monitor);
        if (this.canceled) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Canceled by user");
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Found " + clusters.size() + " clusters");
        if (clusters == null || clusters.size() == 0) {
            monitor.showMessage(TaskMonitor.Level.WARN, "Didn't find any clusters!");
            return;
        }
        clusters = NodeCluster.rankListByScore(clusters);
        this.clusterAttributeName = this.context.getClusterAttribute();
        this.createGroups = this.context.advancedAttributes.createGroups;
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.setStatusMessage("Creating groups");
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.setStatusMessage("Done.  MCODE results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.runMCODE.cancel();
    }

    public void setParams(List<String> params) {
        params.add("scope=" + this.currentParamsCopy.getScope());
        params.add("includeLoops=" + this.currentParamsCopy.isIncludeLoops());
        params.add("degreeCutoff=" + this.currentParamsCopy.getDegreeCutoff());
        params.add("kCore=" + this.currentParamsCopy.getKCore());
        params.add("maxDepth=" + this.currentParamsCopy.getMaxDepthFromStart());
        params.add("nodeScoreCutoff=" + this.currentParamsCopy.getNodeScoreCutoff());
        params.add("fluff=" + this.currentParamsCopy.isFluff());
        params.add("haircut=" + this.currentParamsCopy.isHaircut());
    }
}

