/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCODEParameterSet {
    public static String NETWORK = "network";
    public static String SELECTION = "selection";
    private String scope;
    private List<CyNode> selectedNodes;
    private boolean includeLoops;
    private int degreeCutoff;
    private int kCore;
    private boolean optimize;
    private int maxDepthFromStart;
    private double nodeScoreCutoff;
    private boolean fluff;
    private boolean haircut;
    private double fluffNodeDensityCutoff;
    private int defaultRowHeight;

    public MCODEParameterSet() {
        this.setDefaultParams();
        this.defaultRowHeight = 80;
    }

    public MCODEParameterSet(String scope, List<CyNode> selectedNodes, boolean includeLoops, int degreeCutoff, int kCore, boolean optimize, int maxDepthFromStart, double nodeScoreCutoff, boolean fluff, boolean haircut, double fluffNodeDensityCutoff) {
        this.setAllAlgorithmParams(scope, selectedNodes, includeLoops, degreeCutoff, kCore, optimize, maxDepthFromStart, nodeScoreCutoff, fluff, haircut, fluffNodeDensityCutoff);
        this.defaultRowHeight = 80;
    }

    public void setDefaultParams() {
        this.setAllAlgorithmParams(NETWORK, new ArrayList<CyNode>(), false, 2, 2, false, 100, 0.2, false, true, 0.1);
    }

    public void setAllAlgorithmParams(String scope, List<CyNode> selectedNodes, boolean includeLoops, int degreeCutoff, int kCore, boolean optimize, int maxDepthFromStart, double nodeScoreCutoff, boolean fluff, boolean haircut, double fluffNodeDensityCutoff) {
        this.scope = scope;
        this.selectedNodes = selectedNodes;
        this.includeLoops = includeLoops;
        this.degreeCutoff = degreeCutoff;
        this.kCore = kCore;
        this.optimize = optimize;
        this.maxDepthFromStart = maxDepthFromStart;
        this.nodeScoreCutoff = nodeScoreCutoff;
        this.fluff = fluff;
        this.haircut = haircut;
        this.fluffNodeDensityCutoff = fluffNodeDensityCutoff;
    }

    public MCODEParameterSet copy() {
        MCODEParameterSet newParam = new MCODEParameterSet();
        newParam.setScope(this.scope);
        newParam.setSelectedNodes(this.selectedNodes);
        newParam.setIncludeLoops(this.includeLoops);
        newParam.setDegreeCutoff(this.degreeCutoff);
        newParam.setKCore(this.kCore);
        newParam.setOptimize(this.optimize);
        newParam.setMaxDepthFromStart(this.maxDepthFromStart);
        newParam.setNodeScoreCutoff(this.nodeScoreCutoff);
        newParam.setFluff(this.fluff);
        newParam.setHaircut(this.haircut);
        newParam.setFluffNodeDensityCutoff(this.fluffNodeDensityCutoff);
        newParam.setDefaultRowHeight(this.defaultRowHeight);
        return newParam;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<CyNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(List<CyNode> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public boolean isIncludeLoops() {
        return this.includeLoops;
    }

    public void setIncludeLoops(boolean includeLoops) {
        this.includeLoops = includeLoops;
    }

    public int getDegreeCutoff() {
        return this.degreeCutoff;
    }

    public void setDegreeCutoff(int degreeCutoff) {
        this.degreeCutoff = degreeCutoff;
    }

    public int getKCore() {
        return this.kCore;
    }

    public void setKCore(int kCore) {
        this.kCore = kCore;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public int getMaxDepthFromStart() {
        return this.maxDepthFromStart;
    }

    public void setMaxDepthFromStart(int maxDepthFromStart) {
        this.maxDepthFromStart = maxDepthFromStart;
    }

    public double getNodeScoreCutoff() {
        return this.nodeScoreCutoff;
    }

    public void setNodeScoreCutoff(double nodeScoreCutoff) {
        this.nodeScoreCutoff = nodeScoreCutoff;
    }

    public boolean isFluff() {
        return this.fluff;
    }

    public void setFluff(boolean fluff) {
        this.fluff = fluff;
    }

    public boolean isHaircut() {
        return this.haircut;
    }

    public void setHaircut(boolean haircut) {
        this.haircut = haircut;
    }

    public double getFluffNodeDensityCutoff() {
        return this.fluffNodeDensityCutoff;
    }

    public void setFluffNodeDensityCutoff(double fluffNodeDensityCutoff) {
        this.fluffNodeDensityCutoff = fluffNodeDensityCutoff;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("   Network Scoring:" + lineSep + "      Include Loops: " + this.includeLoops + "  Degree Cutoff: " + this.degreeCutoff + lineSep);
        sb.append("   Cluster Finding:" + lineSep + "      Node Score Cutoff: " + this.nodeScoreCutoff + "  Haircut: " + this.haircut + "  Fluff: " + this.fluff + (this.fluff ? "  Fluff Density Cutoff " + this.fluffNodeDensityCutoff : "") + "  K-Core: " + this.kCore + "  Max. Depth from Seed: " + this.maxDepthFromStart + lineSep);
        return sb.toString();
    }
}

