/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class SCPSContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @Tunable(description="Epsilon Parameter", groups={"SCPS Tuning"}, gravity=1.0)
    public double epsilon = 1.02;
    @Tunable(description="Number of iterations", groups={"SCPS Tuning"}, gravity=2.0)
    public int iterations = 50;
    @Tunable(description="Number of clusters", groups={"SCPS Tuning"}, gravity=3.0)
    public int clusters = -1;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public SCPSContext() {
        this.advancedAttributes = new AdvancedProperties("__scpsCluster", false);
    }

    public SCPSContext(SCPSContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__scpsCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.epsilon = origin.epsilon;
        this.iterations = origin.iterations;
        this.clusters = origin.clusters;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }
}

