/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.clusteranalysis;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.Edges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.InOut;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fmeassure {
    public static double fMeassure(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        int proteins = Fmeassure.countProteins(clusterReference);
        double fmeasure = 0.0;
        int count = 0;
        Enumeration<String> e = clusterReference.keys();
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            int proteinsInReference = h.size();
            double maxValue = Fmeassure.findMax(proteinsInReference, cluster2, h);
            fmeasure += maxValue * (double)proteinsInReference;
            ++count;
        }
        return fmeasure /= (double)proteins;
    }

    public static double fMeassure2(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        double fmeasure = 0.0;
        int count = 0;
        Enumeration<String> e = clusterReference.keys();
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            int proteinsInReference = h.size();
            double maxValue = Fmeassure.findMax2(proteinsInReference, cluster2, h);
            fmeasure += maxValue;
            ++count;
        }
        return fmeasure /= (double)clusterReference.size();
    }

    public static double fMeassure() throws IOException {
        Hashtable<String, Hashtable<String, Boolean>> clusterReference = Fmeassure.readCluster(TaskConfig.goldstandardPath);
        int proteins = Fmeassure.countProteins(clusterReference);
        String fileName = TaskConfig.clustersPath;
        Hashtable<String, Hashtable<String, Boolean>> cluster2 = Fmeassure.readCluster(fileName);
        double fmeasure = 0.0;
        int count = 0;
        Enumeration<String> e = clusterReference.keys();
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            int proteinsInReference = h.size();
            double maxValue = Fmeassure.findMax(proteinsInReference, cluster2, h);
            fmeasure += maxValue * (double)proteinsInReference;
            ++count;
        }
        return fmeasure /= (double)proteins;
    }

    public static double fMeassure(String goldStandardFile, String clustersFile) {
        double value = 0.0;
        return value;
    }

    public static double ClusterWiseSeperation(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        double seperation = 0.0;
        double[][] tij = new double[clusterReference.size()][cluster2.size()];
        Enumeration<String> e = clusterReference.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            Enumeration<String> e2 = cluster2.keys();
            int j = 0;
            while (e2.hasMoreElements()) {
                int common = 0;
                String id = e2.nextElement();
                Hashtable<String, Boolean> h2 = cluster2.get(id);
                common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
                tij[i][j] = common;
                ++j;
            }
            ++i;
        }
        double[][] fcol = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < fcol.length; ++j) {
            for (int j2 = 0; j2 < fcol[j].length; ++j2) {
                fcol[j][j2] = tij[j][j2];
                double tj = 0.0;
                for (int k = 0; k < tij.length; ++k) {
                    tj += tij[k][j2];
                }
                if (fcol[j][j2] == 0.0 && tj == 0.0) continue;
                double[] dArray = fcol[j];
                int n = j2;
                dArray[n] = dArray[n] / tj;
            }
        }
        double[][] frow = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < frow[0].length; ++j) {
            for (int j2 = 0; j2 < frow.length; ++j2) {
                frow[j2][j] = tij[j2][j];
                double tj = 0.0;
                for (int k = 0; k < tij[0].length; ++k) {
                    tj += tij[j2][k];
                }
                if (frow[j2][j] == 0.0 && tj == 0.0) continue;
                double[] dArray = frow[j2];
                int n = j;
                dArray[n] = dArray[n] / tj;
            }
        }
        double[][] sep = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < sep.length; ++j) {
            for (int j2 = 0; j2 < sep[j].length; ++j2) {
                sep[j][j2] = fcol[j][j2] * frow[j][j2];
                seperation += sep[j][j2];
            }
        }
        return seperation /= (double)cluster2.size();
    }

    public static double ComplexWiseSeperation(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        double seperation = 0.0;
        double[][] tij = new double[clusterReference.size()][cluster2.size()];
        Enumeration<String> e = clusterReference.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            Enumeration<String> e2 = cluster2.keys();
            int j = 0;
            while (e2.hasMoreElements()) {
                int common = 0;
                String id = e2.nextElement();
                Hashtable<String, Boolean> h2 = cluster2.get(id);
                common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
                tij[i][j] = common;
                ++j;
            }
            ++i;
        }
        double[][] fcol = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < fcol.length; ++j) {
            for (int j2 = 0; j2 < fcol[j].length; ++j2) {
                fcol[j][j2] = tij[j][j2];
                double tj = 0.0;
                for (int k = 0; k < tij.length; ++k) {
                    tj += tij[k][j2];
                }
                if (fcol[j][j2] == 0.0 && tj == 0.0) continue;
                double[] dArray = fcol[j];
                int n = j2;
                dArray[n] = dArray[n] / tj;
            }
        }
        double[][] frow = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < frow[0].length; ++j) {
            for (int j2 = 0; j2 < frow.length; ++j2) {
                frow[j2][j] = tij[j2][j];
                double tj = 0.0;
                for (int k = 0; k < tij[0].length; ++k) {
                    tj += tij[j2][k];
                }
                if (frow[j2][j] == 0.0 && tj == 0.0) continue;
                double[] dArray = frow[j2];
                int n = j;
                dArray[n] = dArray[n] / tj;
            }
        }
        double[][] sep = new double[clusterReference.size()][cluster2.size()];
        for (int j = 0; j < sep.length; ++j) {
            for (int j2 = 0; j2 < sep[j].length; ++j2) {
                sep[j][j2] = fcol[j][j2] * frow[j][j2];
                seperation += sep[j][j2];
            }
        }
        return seperation /= (double)clusterReference.size();
    }

    public static double PPV(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        int j;
        int j2;
        int j3;
        int j4;
        double PPV = 0.0;
        double[][] tij = new double[clusterReference.size()][cluster2.size()];
        Enumeration<String> e = clusterReference.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            Enumeration<String> e2 = cluster2.keys();
            j4 = 0;
            while (e2.hasMoreElements()) {
                int common = 0;
                String id = e2.nextElement();
                Hashtable<String, Boolean> h2 = cluster2.get(id);
                common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
                tij[i][j4] = common;
                ++j4;
            }
            ++i;
        }
        double[][] ppv = new double[clusterReference.size()][cluster2.size()];
        double[] tjs = new double[cluster2.size()];
        for (j3 = 0; j3 < ppv.length; ++j3) {
            j2 = 0;
            while (j2 < ppv[j3].length) {
                ppv[j3][j2] = tij[j3][j2];
                double tj = 0.0;
                for (int k = 0; k < tij.length; ++k) {
                    tj += tij[k][j2];
                }
                double[] dArray = ppv[j3];
                int n = j2++;
                dArray[n] = dArray[n] / tj;
            }
        }
        for (j3 = 0; j3 < tij[0].length; ++j3) {
            for (j2 = 0; j2 < tij.length; ++j2) {
                int n = j3;
                tjs[n] = tjs[n] + tij[j2][j3];
            }
        }
        double[] maxppvs = new double[cluster2.size()];
        for (j4 = 0; j4 < tij[0].length; ++j4) {
            double max = 0.0;
            for (int j22 = 0; j22 < tij.length; ++j22) {
                if (!(ppv[j22][j4] > max)) continue;
                max = ppv[j22][j4];
            }
            maxppvs[j4] = max;
        }
        double sum = 0.0;
        for (j = 0; j < tjs.length; ++j) {
            sum += tjs[j];
        }
        for (j = 0; j < maxppvs.length; ++j) {
            PPV += tjs[j] * maxppvs[j];
        }
        return PPV /= sum;
    }

    public static double Sensitivity2(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        int j;
        int j2;
        int j3;
        double PPV = 0.0;
        double[][] tij = new double[clusterReference.size()][cluster2.size()];
        Enumeration<String> e = clusterReference.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            Enumeration<String> e2 = cluster2.keys();
            j3 = 0;
            while (e2.hasMoreElements()) {
                int common = 0;
                String id = e2.nextElement();
                Hashtable<String, Boolean> h2 = cluster2.get(id);
                common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
                tij[i][j3] = common;
                ++j3;
            }
            ++i;
        }
        double[][] ppv = new double[clusterReference.size()][cluster2.size()];
        double[] tjs = new double[clusterReference.size()];
        for (j2 = 0; j2 < ppv[0].length; ++j2) {
            for (j3 = 0; j3 < ppv.length; ++j3) {
                ppv[j3][j2] = tij[j3][j2];
                double tj = 0.0;
                for (int k = 0; k < tij.length; ++k) {
                    tj += tij[j3][k];
                }
                double[] dArray = ppv[j3];
                int n = j2;
                dArray[n] = dArray[n] / tj;
            }
        }
        for (j2 = 0; j2 < tij.length; ++j2) {
            for (j3 = 0; j3 < tij[0].length; ++j3) {
                int n = j2;
                tjs[n] = tjs[n] + tij[j2][j3];
            }
        }
        double[] maxppvs = new double[clusterReference.size()];
        for (int j22 = 0; j22 < tij.length; ++j22) {
            double max = 0.0;
            for (int j4 = 0; j4 < tij[0].length; ++j4) {
                if (!(ppv[j22][j4] > max)) continue;
                max = ppv[j22][j4];
            }
            maxppvs[j22] = max;
        }
        double sum = 0.0;
        for (j = 0; j < tjs.length; ++j) {
            sum += tjs[j];
        }
        for (j = 0; j < maxppvs.length; ++j) {
            PPV += tjs[j] * maxppvs[j];
        }
        return PPV /= sum;
    }

    public static double BCubedPrecision(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        ArrayList<String> al;
        Hashtable<String, Boolean> h;
        Hashtable reference = new Hashtable();
        Hashtable clustering = new Hashtable();
        for (String key : clusterReference.keySet()) {
            h = clusterReference.get(key);
            for (String id : h.keySet()) {
                if (reference.containsKey(id)) {
                    ((ArrayList)reference.get(id)).add(key);
                    continue;
                }
                al = new ArrayList<String>();
                al.add(key);
                reference.put(id, al);
            }
        }
        for (String key : cluster2.keySet()) {
            h = cluster2.get(key);
            for (String id : h.keySet()) {
                if (clustering.containsKey(id)) {
                    ((ArrayList)clustering.get(id)).add(key);
                    continue;
                }
                al = new ArrayList();
                al.add(key);
                clustering.put(id, al);
            }
        }
        double precision = 0.0;
        double recall = 0.0;
        for (String id1 : reference.keySet()) {
            ArrayList referenceList1 = (ArrayList)reference.get(id1);
            ArrayList<String> clusteringList1 = (ArrayList<String>)clustering.get(id1);
            if (clusteringList1 == null) {
                clusteringList1 = new ArrayList<String>();
                clusteringList1.add(id1);
            }
            double elementWisePrecision = 0.0;
            double elementWiseRecall = 0.0;
            int countPrecision = 0;
            int countRecall = 0;
            for (String id2 : reference.keySet()) {
                ArrayList referenceList2 = (ArrayList)reference.get(id2);
                ArrayList<String> clusteringList2 = (ArrayList<String>)clustering.get(id2);
                if (clusteringList2 == null) {
                    clusteringList2 = new ArrayList<String>();
                    clusteringList2.add(id2);
                }
                double commonReference = Fmeassure.calculateCommonClusters(referenceList1, referenceList2);
                double commonClustering = Fmeassure.calculateCommonClusters(clusteringList1, clusteringList2);
                if (commonReference != 0.0) {
                    elementWisePrecision += Math.min(commonReference, commonClustering) / commonReference;
                    ++countPrecision;
                }
                if (commonClustering == 0.0) continue;
                elementWiseRecall += Math.min(commonReference, commonClustering) / commonClustering;
                ++countRecall;
            }
            recall += (elementWiseRecall /= (double)countRecall);
            precision += (elementWisePrecision /= (double)countPrecision);
        }
        double fmeasure = 2.0 * ((recall /= (double)reference.size()) * (precision /= (double)reference.size())) / (recall + precision);
        return precision;
    }

    private static double calculateCommonClusters(ArrayList<String> referenceList1, ArrayList<String> referenceList2) {
        double common = 0.0;
        for (String cluster1 : referenceList2) {
            for (String cluster2 : referenceList1) {
                if (!cluster1.equals(cluster2)) continue;
                common += 1.0;
            }
        }
        return common;
    }

    public static double BCubedRecall(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        double recall = 0.0;
        return recall;
    }

    public static double Sensitivity(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> cluster2) {
        double sensitivity = 0.0;
        double count = 0.0;
        Enumeration<String> e = clusterReference.keys();
        while (e.hasMoreElements()) {
            double sensitivityForCluster = 0.0;
            String clusterID = e.nextElement();
            Hashtable<String, Boolean> h = clusterReference.get(clusterID);
            int proteinsInReference = h.size();
            Enumeration<String> e2 = cluster2.keys();
            while (e2.hasMoreElements()) {
                double dummy = 0.0;
                int common = 0;
                String id = e2.nextElement();
                Hashtable<String, Boolean> h2 = cluster2.get(id);
                common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
                dummy = (double)common / (double)h.size();
                if (!(dummy > sensitivityForCluster)) continue;
                sensitivityForCluster = dummy;
            }
            sensitivity += sensitivityForCluster * (double)h.size();
            count += (double)h.size();
        }
        return sensitivity /= count;
    }

    private static double findMax(int proteinsInReference, Hashtable<String, Hashtable<String, Boolean>> cluster2, Hashtable<String, Boolean> h) {
        double max = 0.0;
        double maxCommon = 0.0;
        double maxh2size = 0.0;
        Enumeration<String> e = cluster2.keys();
        while (e.hasMoreElements()) {
            double dummy = 0.0;
            int common = 0;
            String id = e.nextElement();
            Hashtable<String, Boolean> h2 = cluster2.get(id);
            common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
            double dummy2 = 2 * common;
            double dummy3 = h.size() + h2.size();
            dummy = 2 * common / (h.size() + h2.size());
            dummy = dummy2 / dummy3;
            if (!(dummy > max)) continue;
            max = dummy;
            maxCommon = common;
            maxh2size = h2.size();
        }
        if (maxCommon == 0.0 && h.size() == 1) {
            return 1.0;
        }
        return max;
    }

    private static double findMax2(int proteinsInReference, Hashtable<String, Hashtable<String, Boolean>> cluster2, Hashtable<String, Boolean> h) {
        double max = 0.0;
        double maxCommon = 0.0;
        double maxSizeCluster = 0.0;
        Enumeration<String> e = cluster2.keys();
        while (e.hasMoreElements()) {
            double precision;
            double dummy = 0.0;
            int common = 0;
            String id = e.nextElement();
            Hashtable<String, Boolean> h2 = cluster2.get(id);
            common = h.size() < h2.size() ? Fmeassure.calculateCommonProteins(h, h2) : Fmeassure.calculateCommonProteins(h2, h);
            double tp = common;
            double fp = h2.size() - common;
            double fn = h.size() - common;
            double recall = tp / (tp + fn);
            double fmeasure = 2.0 * (recall * (precision = tp / (tp + fp))) / (recall + precision);
            if (!(fmeasure > max)) continue;
            max = fmeasure;
            maxCommon = common;
            maxSizeCluster = h2.size();
        }
        if (maxCommon == 0.0 && h.size() == 1) {
            return 1.0;
        }
        return max;
    }

    private static int countProteins(Hashtable<String, Hashtable<String, Boolean>> c) {
        int proteins = 0;
        Enumeration<String> e = c.keys();
        while (e.hasMoreElements()) {
            String id = e.nextElement();
            Hashtable<String, Boolean> h = c.get(id);
            proteins += h.size();
        }
        return proteins;
    }

    private static int calculateCommonProteins(Hashtable<String, Boolean> c1, Hashtable<String, Boolean> c2) {
        int common = 0;
        Enumeration<String> e = c1.keys();
        while (e.hasMoreElements()) {
            String id = e.nextElement();
            if (!c2.containsKey(id)) continue;
            ++common;
        }
        return common;
    }

    private static Hashtable<String, Hashtable<String, Boolean>> readCluster(String fileName) throws IOException {
        String line;
        Hashtable<String, Hashtable<String, Boolean>> cluster2 = new Hashtable<String, Hashtable<String, Boolean>>();
        BufferedReader br = Fmeassure.myBufferedReader(fileName);
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split("\t");
            Hashtable<String, Boolean> h = new Hashtable<String, Boolean>();
            if (cluster2.containsKey(tokens[1])) {
                h = cluster2.get(tokens[1]);
            }
            h.put(tokens[0], true);
            cluster2.put(tokens[1], h);
        }
        return cluster2;
    }

    private static BufferedReader myBufferedReader(String file) throws IOException {
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        return br;
    }

    public static double fMeassure(HashMap<String, String> referenceHash, HashMap<String, String> clusterHash) {
        double fmeasure = 0.0;
        double tp = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        double tn = 0.0;
        for (String id1 : clusterHash.keySet()) {
            for (String id2 : clusterHash.keySet()) {
                boolean sameCluster = clusterHash.get(id1).equals(clusterHash.get(id2));
                boolean sameReference = referenceHash.get(id1).equals(referenceHash.get(id2));
                if (sameCluster && sameReference) {
                    tp += 1.0;
                    continue;
                }
                if (sameCluster && !sameReference) {
                    fp += 1.0;
                    continue;
                }
                if (!sameCluster && sameReference) {
                    fn += 1.0;
                    continue;
                }
                tn += 1.0;
            }
        }
        double precision = tp / (tp + fp);
        double recall = tp / (tp + fn);
        fmeasure = 2.0 * (recall * precision) / (recall + precision);
        return fmeasure;
    }

    public static double vidistance(Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> clusters) {
        double numberOfObjects = 0.0;
        for (String key : clusterReference.keySet()) {
            Hashtable<String, Boolean> cluster1 = clusterReference.get(key);
            numberOfObjects += (double)cluster1.size();
        }
        double hxy = 0.0;
        double hyx = 0.0;
        for (String key : clusterReference.keySet()) {
            Hashtable<String, Boolean> cluster1 = clusterReference.get(key);
            for (String key2 : clusters.keySet()) {
                Hashtable<String, Boolean> cluster2 = clusters.get(key2);
                double common = Fmeassure.calculateCommonProteins(cluster1, cluster2);
                if (common == 0.0) continue;
                double pxy = common / numberOfObjects;
                double px = (double)cluster2.size() / numberOfObjects;
                double py = (double)cluster1.size() / numberOfObjects;
                hxy += pxy * Math.log(pxy / py);
                hyx += pxy * Math.log(pxy / px);
            }
        }
        double vidistance = 0.0;
        vidistance -= hxy;
        return vidistance -= hyx;
    }

    public static double silhouette(Hashtable<String, Hashtable<String, Boolean>> clusters, Edges es, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) {
        double silhouette = 0.0;
        HashMap<String, String> protein2cluster = new HashMap<String, String>();
        for (String clustername : clusters.keySet()) {
            Hashtable<String, Boolean> cluster2 = clusters.get(clustername);
            for (String object : cluster2.keySet()) {
                protein2cluster.put(object, clustername);
            }
        }
        int count = 0;
        for (Integer proteinNr : proteins2integers.keySet()) {
            String protein = proteins2integers.get(proteinNr);
            String clusterName = (String)protein2cluster.get(protein);
            Hashtable<String, Boolean> cluster3 = clusters.get(clusterName);
            double a = 0.0;
            for (String element : cluster3.keySet()) {
                if (element.equals(protein)) continue;
                a += (double)InOut.getEdgeValue(proteinNr, integers2proteins.get(element), es);
            }
            a /= (double)(cluster3.size() - 1);
            double b = 0.0;
            for (String clusterName2 : clusters.keySet()) {
                if (clusterName.equals(clusterName2)) continue;
                double localb = 0.0;
                Hashtable<String, Boolean> cluster2 = clusters.get(clusterName2);
                for (String element : cluster2.keySet()) {
                    localb += (double)InOut.getEdgeValue(proteinNr, integers2proteins.get(element), es);
                }
                if (!((localb /= (double)cluster2.size()) > b)) continue;
                b = localb;
            }
            if (cluster3.size() != 1) {
                double dum = (a - b) / Math.max(a, b);
                silhouette += dum;
                continue;
            }
            ++count;
        }
        return silhouette /= (double)(protein2cluster.size() - count);
    }
}

