/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceHSPs {
    private ArrayList<Integer> lines;
    private ArrayList<boolean[]> coverages;
    private int lenght;
    private String id;
    private ArrayList<Integer> cluster;
    private int clusternr;
    private ArrayList<Integer> clusterline;

    public SourceHSPs(ArrayList<boolean[]> coverages, int lenght, ArrayList<Integer> lines, String id) {
        this.coverages = coverages;
        this.lenght = lenght;
        this.lines = lines;
        this.id = id;
        this.cluster = new ArrayList();
        this.clusterline = new ArrayList();
        this.clusternr = 0;
    }

    public SourceHSPs(int size) {
        this.lenght = size;
        this.lines = new ArrayList();
        this.coverages = new ArrayList();
    }

    public boolean addAllCoverages(Collection<? extends boolean[]> c) {
        return this.coverages.addAll(c);
    }

    public boolean addAllLines(int index, Collection<? extends Integer> c) {
        return this.lines.addAll(index, c);
    }

    public void addCluster(Integer element) {
        this.cluster.add(element);
    }

    public boolean addClusterLine(Integer e) {
        return this.clusterline.add(e);
    }

    public boolean addCoverage(boolean[] e) {
        return this.coverages.add(e);
    }

    public boolean addLine(Integer e) {
        return this.lines.add(e);
    }

    private void assignRecursivly(float[][] similarity, int clusterNr, boolean[] already, float distance, int seed, int[] clusters) {
        for (int i = 0; i < already.length; ++i) {
            if (already[i] || !(similarity[i][seed] >= distance)) continue;
            clusters[i] = clusterNr;
            already[i] = true;
            this.assignRecursivly(similarity, clusterNr, already, distance, i, clusters);
        }
    }

    private int calculateClusters(float[][] similarity, float distance, int[] clusters, boolean[] already) {
        int clusterNr = 0;
        for (int i = 0; i < clusters.length; ++i) {
            if (already[i]) continue;
            clusters[i] = clusterNr;
            already[i] = true;
            this.assignRecursivly(similarity, clusterNr, already, distance, i, clusters);
            ++clusterNr;
        }
        return clusterNr;
    }

    private float calculateSimilarity(boolean[] bs, boolean[] bs2) {
        float sim = 0.0f;
        for (int i = 0; i < bs2.length; ++i) {
            if ((!bs[i] || !bs2[i]) && (bs[i] || bs2[i])) continue;
            sim += 1.0f;
        }
        return sim /= (float)bs.length;
    }

    public void cluster() {
        float[][] similarity = new float[this.lines.size()][this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int j = i + 1; j < this.lines.size(); ++j) {
                float sim;
                float f = sim = this.calculateSimilarity(this.coverages.get(i), this.coverages.get(j));
                similarity[j][i] = f;
                similarity[i][j] = f;
            }
        }
        int[] clusters = new int[this.lines.size()];
        boolean[] already = new boolean[this.lines.size()];
        int clusternr = this.calculateClusters(similarity, 0.9f, clusters, already);
        System.out.println(this.id + "\t" + clusternr + "\t" + this.lines.size());
        System.out.println(Arrays.toString(clusters));
        for (int i = 0; i < clusters.length; ++i) {
            this.cluster.add(clusters[i]);
        }
    }

    public ArrayList<Integer> getCluster() {
        return this.cluster;
    }

    public Integer getCluster(int index) {
        return this.cluster.get(index);
    }

    public ArrayList<Integer> getClusterline() {
        return this.clusterline;
    }

    public Integer getClusterLine(int index) {
        return this.clusterline.get(index);
    }

    public int getClusternr() {
        return this.clusternr;
    }

    public boolean[] getCoverage(int index) {
        return this.coverages.get(index);
    }

    public ArrayList<boolean[]> getCoverages() {
        return this.coverages;
    }

    public int getLenght() {
        return this.lenght;
    }

    public Integer getLine(int index) {
        return this.lines.get(index);
    }

    public ArrayList<Integer> getLines() {
        return this.lines;
    }

    public void setCluster(ArrayList<Integer> cluster2) {
        this.cluster = cluster2;
    }

    public void setClusterline(ArrayList<Integer> clusterline) {
        this.clusterline = clusterline;
    }

    public void setClusternr(int clusternr) {
        this.clusternr = clusternr;
    }

    public void setCoverages(ArrayList<boolean[]> coverages) {
        this.coverages = coverages;
    }

    public void setLenght(int lenght) {
        this.lenght = lenght;
    }

    public void setLines(ArrayList<Integer> lines) {
        this.lines = lines;
    }
}

