/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.gui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.gui.Console;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Config;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Creator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Splitter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class MainFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JPanel fcPanelBlast = new JPanel();
    JPanel fcPanelBlastText = new JPanel();
    JPanel fcPanelFasta = new JPanel();
    JPanel fcPanelFastaText = new JPanel();
    JPanel fcPanelSim = new JPanel();
    JPanel fcPanelSimText = new JPanel();
    JPanel fcPanelCmDir = new JPanel();
    JPanel fcPanelCmDirText = new JPanel();
    JButton exit = new JButton("EXIT");
    JButton run = new JButton("RUN");
    JButton blast = new JButton("open BLAST file");
    JFileChooser fcBlast = new JFileChooser();
    JButton fasta = new JButton("open Fasta file");
    JFileChooser fcFasta = new JFileChooser();
    JButton sim = new JButton("choose sim file");
    JFileChooser fcSim = new JFileChooser();
    JButton cmDir = new JButton("choose cmDir ");
    JFileChooser fcCmDir = new JFileChooser();
    JPanel mainPanel = new JPanel();
    JRadioButton createSimilartyFile = new JRadioButton("createSimilartyFile");
    JRadioButton createCostMatrices = new JRadioButton("createCostMatrices");
    private JTextField threshold = new JTextField(Float.toString(Config.threshold));
    private JTextField penaltyForMultipleHighScoringPairs = new JTextField(Double.toString(Config.penaltyForMultipleHighScoringPairs));
    private JTextField blastCutoff = new JTextField(Double.toString(Config.blastCutoff));
    private JTextField upperBound = new JTextField(Float.toString(Config.upperBound));
    private JTextField coverageFactor = new JTextField(Integer.toString(Config.coverageFactor));
    private JRadioButton BeH = new JRadioButton();
    private JRadioButton SoH = new JRadioButton();
    private JRadioButton BeHCoverage = new JRadioButton();
    private JRadioButton SoHCoverage = new JRadioButton();
    private JRadioButton reduceMatrices = new JRadioButton();
    public static MainThread t;

    public MainFrame() {
        super("CostMatrixCreator");
        this.setSize(800, 600);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.fcPanelBlast.setLayout(new BoxLayout(this.fcPanelBlast, 0));
        this.blast.setActionCommand("blast");
        this.blast.addActionListener(this);
        this.fcPanelBlast.add(this.blast);
        this.fcPanelBlastText.setLayout(new BoxLayout(this.fcPanelBlastText, 0));
        JLabel blastFile = new JLabel();
        if (Config.blastFile == null) {
            blastFile.setText("not chosen yet");
        } else {
            blastFile.setText(Config.blastFile);
        }
        this.fcPanelBlastText.add(blastFile);
        this.fcPanelFasta.setLayout(new BoxLayout(this.fcPanelFasta, 0));
        this.fasta.setActionCommand("fasta");
        this.fasta.addActionListener(this);
        this.fcPanelFasta.add(this.fasta);
        this.fcPanelFastaText.setLayout(new BoxLayout(this.fcPanelFastaText, 0));
        JLabel fastaFile = new JLabel();
        if (Config.fastaFile == null) {
            fastaFile.setText("not choosen yet");
        } else {
            fastaFile.setText(Config.fastaFile);
        }
        this.fcPanelFastaText.add(fastaFile);
        this.fcPanelSim.setLayout(new BoxLayout(this.fcPanelSim, 0));
        this.sim.setActionCommand("sim");
        this.sim.addActionListener(this);
        this.fcPanelSim.add(this.sim);
        this.fcPanelSimText.setLayout(new BoxLayout(this.fcPanelSimText, 0));
        JLabel simFile = new JLabel();
        if (Config.similarityFile == null) {
            simFile.setText("not choosen yet");
        } else {
            simFile.setText(Config.similarityFile);
        }
        this.fcPanelSimText.add(simFile);
        this.fcPanelCmDir.setLayout(new BoxLayout(this.fcPanelCmDir, 0));
        this.cmDir.setActionCommand("cmDir");
        this.cmDir.addActionListener(this);
        this.fcPanelCmDir.add(this.cmDir);
        this.fcPanelCmDirText.setLayout(new BoxLayout(this.fcPanelCmDirText, 0));
        JLabel cmDirFile = new JLabel();
        if (Config.costMatrixDirectory == null) {
            cmDirFile.setText("not choosen yet");
        } else {
            cmDirFile.setText(Config.costMatrixDirectory);
        }
        this.fcPanelCmDirText.add(cmDirFile);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.run.setActionCommand("run");
        this.run.addActionListener(this);
        buttonPanel.add(this.run);
        this.exit.setActionCommand("exit");
        this.exit.addActionListener(this);
        buttonPanel.add(this.exit);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 0));
        if (Config.createSimilarityFile) {
            this.createSimilartyFile.setSelected(true);
        }
        if (Config.splitAndWriteCostMatrices) {
            this.createCostMatrices.setSelected(true);
        }
        radioButtonPanel.add(new JLabel("Mode: "));
        radioButtonPanel.add(this.createSimilartyFile);
        radioButtonPanel.add(new JLabel("             "));
        radioButtonPanel.add(this.createCostMatrices);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(radioButtonPanel);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(this.fcPanelBlast);
        this.mainPanel.add(this.fcPanelBlastText);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(this.fcPanelFasta);
        this.mainPanel.add(this.fcPanelFastaText);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(this.fcPanelSim);
        this.mainPanel.add(this.fcPanelSimText);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(this.fcPanelCmDir);
        this.mainPanel.add(this.fcPanelCmDirText);
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(new JLabel("   "));
        this.mainPanel.add(buttonPanel);
        JPanel root = (JPanel)this.getContentPane();
        root.setLayout(new BoxLayout(root, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Main", this.mainPanel);
        JScrollPane optionsPanel = new JScrollPane(this.makeOptionsPanel());
        tabbedPane.add("Options", optionsPanel);
        root.add(tabbedPane);
    }

    private JPanel makeOptionsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.addOptionSplit(p, "Similarity file creation");
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.BeH);
        bg.add(this.SoH);
        bg.add(this.BeHCoverage);
        bg.add(this.SoHCoverage);
        if (Config.costModel == 0) {
            this.BeH.setSelected(true);
            this.penaltyForMultipleHighScoringPairs.setEnabled(false);
            this.coverageFactor.setEnabled(false);
        } else if (Config.costModel == 1) {
            this.SoH.setSelected(true);
            this.coverageFactor.setEnabled(false);
        } else if (Config.costModel == 2) {
            this.BeHCoverage.setSelected(true);
            this.penaltyForMultipleHighScoringPairs.setEnabled(false);
        } else if (Config.costModel == 3) {
            this.SoHCoverage.setSelected(true);
        }
        this.BeH.setActionCommand("costModel");
        this.BeH.addActionListener(this);
        this.SoH.setActionCommand("costModel");
        this.SoH.addActionListener(this);
        this.BeHCoverage.setActionCommand("costModel");
        this.BeHCoverage.addActionListener(this);
        this.SoHCoverage.setActionCommand("costModel");
        this.SoHCoverage.addActionListener(this);
        radioButtonPanel.add(new JLabel("\t BeH:"));
        radioButtonPanel.add(this.BeH);
        radioButtonPanel.add(new JLabel("\t SoH"));
        radioButtonPanel.add(this.SoH);
        radioButtonPanel.add(new JLabel("\t BeHCoverage"));
        radioButtonPanel.add(this.BeHCoverage);
        radioButtonPanel.add(new JLabel("\t SoHCoverage"));
        radioButtonPanel.add(this.SoHCoverage);
        this.addOption(p, "costModel:  ", radioButtonPanel, "");
        this.addOption(p, "penalty for multiple HSPs", this.penaltyForMultipleHighScoringPairs, "");
        this.addOption(p, "BLAST cutoff", this.blastCutoff, "");
        this.addOption(p, "coverage Factor", this.coverageFactor, "");
        this.addOptionSplit(p, "CostMatrixCreation");
        this.addOption(p, "threshold", this.threshold, "");
        if (Config.reducedMatrix) {
            this.reduceMatrices.setSelected(true);
        } else {
            this.reduceMatrices.setSelected(false);
            this.upperBound.setEnabled(false);
        }
        JPanel radioButtonPanel2 = new JPanel();
        radioButtonPanel2.setLayout(new BoxLayout(radioButtonPanel2, 0));
        radioButtonPanel2.add(new JLabel("reduce Matrices "));
        radioButtonPanel2.add(this.reduceMatrices);
        this.reduceMatrices.setActionCommand("reduceMatrices");
        this.reduceMatrices.addActionListener(this);
        this.addOption(p, "", radioButtonPanel2, "");
        this.addOption(p, "upper Bound", this.upperBound, "");
        JPanel dummy = new JPanel();
        dummy.setPreferredSize(new Dimension(200, 200));
        p.add(dummy);
        return p;
    }

    private void addOption(JPanel p, String before, JComponent c, String after) {
        JPanel d = new JPanel();
        d.setLayout(new BoxLayout(d, 0));
        d.add(new JLabel(before + " "));
        d.add(c);
        d.add(new JLabel(" " + after));
        p.add(d);
    }

    private void addOptionSplit(JPanel p, String s) {
        p.add(new JSeparator());
        p.add(new JLabel(" "));
        p.add(new JLabel(s));
        p.add(new JLabel(" "));
        p.add(new JSeparator());
    }

    private void setOptions() {
        Config.blastCutoff = Double.parseDouble(this.blastCutoff.getText());
        Config.coverageFactor = Integer.parseInt(this.coverageFactor.getText());
        Config.threshold = Float.parseFloat(this.threshold.getText());
        Config.penaltyForMultipleHighScoringPairs = Float.parseFloat(this.penaltyForMultipleHighScoringPairs.getText());
        Config.upperBound = Float.parseFloat(this.upperBound.getText());
        if (this.BeH.isSelected()) {
            Config.costModel = 0;
        } else if (this.SoH.isSelected()) {
            Config.costModel = 1;
        } else if (this.BeHCoverage.isSelected()) {
            Config.costModel = 2;
        } else if (this.SoHCoverage.isSelected()) {
            Config.costModel = 3;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equalsIgnoreCase("run")) {
            Color fg;
            JLabel dum;
            this.setOptions();
            Config.splitAndWriteCostMatrices = this.createCostMatrices.isSelected();
            Config.createSimilarityFile = this.createSimilartyFile.isSelected();
            boolean error = false;
            if (Config.createSimilarityFile) {
                if (Config.blastFile == null) {
                    dum = (JLabel)this.fcPanelBlastText.getComponent(0);
                    fg = new Color(255, 0, 0);
                    dum.setForeground(fg);
                    dum.setText("please specify Blast file");
                    error = true;
                }
                if (Config.fastaFile == null) {
                    dum = (JLabel)this.fcPanelFastaText.getComponent(0);
                    fg = new Color(255, 0, 0);
                    dum.setForeground(fg);
                    dum.setText("please specify Fasta file");
                    error = true;
                }
                if (Config.similarityFile == null) {
                    dum = (JLabel)this.fcPanelSimText.getComponent(0);
                    fg = new Color(255, 0, 0);
                    dum.setForeground(fg);
                    dum.setText("please specify similarity file");
                    error = true;
                }
            }
            if (Config.splitAndWriteCostMatrices) {
                if (Config.similarityFile == null) {
                    dum = (JLabel)this.fcPanelSimText.getComponent(0);
                    fg = new Color(255, 0, 0);
                    dum.setForeground(fg);
                    dum.setText("please specify similarity file");
                    error = true;
                }
                if (Config.costMatrixDirectory == null) {
                    dum = (JLabel)this.fcPanelCmDirText.getComponent(0);
                    fg = new Color(255, 0, 0);
                    dum.setForeground(fg);
                    dum.setText("please specify costMatrix directory");
                    error = true;
                }
            }
            if (error) {
                return;
            }
            t = new MainThread(this.run, this.exit, new Semaphore(1));
            t.start();
        } else if (s.equalsIgnoreCase("exit")) {
            System.exit(0);
        } else if (s.equalsIgnoreCase("stop")) {
            t.stop();
            Console.println();
            Console.println("STOPPED.");
            Console.println();
            this.exit.setText("EXIT");
            this.exit.setActionCommand("exit");
            this.run.setEnabled(true);
        } else if (s.equalsIgnoreCase("blast")) {
            this.fcBlast.showOpenDialog(this.mainPanel);
            Config.blastFile = this.fcBlast.getSelectedFile().getAbsolutePath();
            JLabel dum = (JLabel)this.fcPanelBlastText.getComponent(0);
            Color fg = new Color(0, 0, 0);
            dum.setForeground(fg);
            dum.setText(Config.blastFile);
        } else if (s.equalsIgnoreCase("fasta")) {
            this.fcFasta.showOpenDialog(this.mainPanel);
            Config.fastaFile = this.fcFasta.getSelectedFile().getAbsolutePath();
            JLabel dum = (JLabel)this.fcPanelFastaText.getComponent(0);
            Color fg = new Color(0, 0, 0);
            dum.setForeground(fg);
            dum.setText(Config.fastaFile);
        } else if (s.equalsIgnoreCase("sim")) {
            if (this.createSimilartyFile.isSelected()) {
                this.fcSim.showSaveDialog(this.mainPanel);
            } else {
                this.fcSim.showOpenDialog(this.mainPanel);
            }
            Config.similarityFile = this.fcSim.getSelectedFile().getAbsolutePath();
            JLabel dum = (JLabel)this.fcPanelSimText.getComponent(0);
            Color fg = new Color(0, 0, 0);
            dum.setForeground(fg);
            dum.setText(Config.similarityFile);
        } else if (s.equalsIgnoreCase("cmDir")) {
            this.fcCmDir.setFileSelectionMode(1);
            this.fcCmDir.showSaveDialog(this.mainPanel);
            Config.costMatrixDirectory = this.fcCmDir.getSelectedFile().getAbsolutePath();
            JLabel dum = (JLabel)this.fcPanelCmDirText.getComponent(0);
            Color fg = new Color(0, 0, 0);
            dum.setForeground(fg);
            dum.setText(Config.costMatrixDirectory);
        } else if (s.equalsIgnoreCase("reduceMatrices")) {
            Config.reducedMatrix = this.reduceMatrices.isSelected();
            if (Config.reducedMatrix) {
                this.upperBound.setEnabled(true);
            } else {
                this.upperBound.setEnabled(false);
            }
        } else if (s.equalsIgnoreCase("costModel")) {
            if (this.BeH.isSelected()) {
                this.blastCutoff.setEnabled(true);
                this.penaltyForMultipleHighScoringPairs.setEnabled(false);
                this.coverageFactor.setEnabled(false);
            } else if (this.SoH.isSelected()) {
                this.coverageFactor.setEnabled(false);
                this.blastCutoff.setEnabled(true);
                this.penaltyForMultipleHighScoringPairs.setEnabled(true);
            } else if (this.BeHCoverage.isSelected()) {
                this.coverageFactor.setEnabled(true);
                this.blastCutoff.setEnabled(true);
                this.penaltyForMultipleHighScoringPairs.setEnabled(false);
            } else if (this.SoHCoverage.isSelected()) {
                this.coverageFactor.setEnabled(true);
                this.blastCutoff.setEnabled(true);
                this.penaltyForMultipleHighScoringPairs.setEnabled(true);
            }
        }
    }

    public class MainThread
    extends Thread {
        JButton run;
        JButton exit;
        Semaphore sem;

        public MainThread(JButton run, JButton exit, Semaphore s) {
            this.run = run;
            this.exit = exit;
            this.sem = s;
            exit.setActionCommand("stop");
        }

        public void run() {
            HashMap<Integer, String> proteins2integers = new HashMap<Integer, String>();
            HashMap<String, Integer> integers2proteins = new HashMap<String, Integer>();
            if (Config.createSimilarityFile) {
                Creator c = new Creator();
                try {
                    c.run(proteins2integers, integers2proteins);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (Config.splitAndWriteCostMatrices) {
                Splitter s = new Splitter();
                try {
                    s.run(proteins2integers, integers2proteins);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Console.println("FINISHED.");
            this.exit.setText("EXIT");
            this.exit.setActionCommand("exit");
            this.run.setEnabled(true);
            this.sem.release();
        }
    }
}

