/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.BlastFile;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.SourceHSPs;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.gui.Console;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Config;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.InOut;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Creator {
    public void run(HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        if (Config.source == "blast") {
            if (Config.gui) {
                Console.println("Read Fasta file ... ");
            }
            int[] proteinLengths = InOut.readFastaFile(Config.fastaFile, proteins2integers, integers2proteins);
            if (Config.gui) {
                Console.println();
            }
            if (Config.gui) {
                Console.println("Read Blast file ... ");
            }
            BlastFile bf = InOut.readBlastFileWithArray(Config.blastFile, integers2proteins, proteinLengths);
            if (Config.gui) {
                Console.println();
            }
            if (Config.gui) {
                Console.println("Create similarity file ...");
            }
            this.createSimilarityFileFromArray(Config.similarityFile, bf, proteins2integers, proteinLengths, Config.costModel);
            if (Config.gui) {
                Console.println();
            }
            if (Config.splitAndWriteCostMatrices) {
                bf = null;
                System.gc();
            }
        }
    }

    public void runWithExpression() throws IOException {
        if (Config.gui) {
            Console.println("Read Matrix ...");
        }
        this.createSimilarityFileFromExpressionMatrix(Config.similarityFile, Config.expressionMatrix, Config.withHeader, Config.withRowDescription, Config.costModel);
    }

    private void createSimilarityFileFromExpressionMatrix(String simFile, String expressionMatrix, boolean withHeader, boolean withRowDescription, int costModel) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(expressionMatrix));
        HashMap vectors = new HashMap();
        int count = 0;
        if (withHeader) {
            br.readLine();
        }
        while ((line = br.readLine()) != null) {
            if (line.trim().equals("")) continue;
            String[] tabs = line.split("\t");
            String elementName = Integer.toString(++count);
            int modifier = 0;
            if (withRowDescription) {
                elementName = tabs[0];
                modifier = 1;
            }
            ArrayList<Double> al = new ArrayList<Double>();
            for (int i = modifier; i < tabs.length; ++i) {
                al.add(Double.parseDouble(tabs[i]));
            }
            vectors.put(elementName, al);
        }
        br.close();
        BufferedWriter bw = new BufferedWriter(new FileWriter(simFile));
        for (String key : vectors.keySet()) {
            ArrayList al1 = (ArrayList)vectors.get(key);
            for (String key2 : vectors.keySet()) {
                ArrayList al2 = (ArrayList)vectors.get(key2);
                if (costModel == 1) {
                    bw.write(key + "\t" + key2 + "\t" + this.calculatePearson(al1, al2));
                    bw.newLine();
                    continue;
                }
                if (costModel != 2) continue;
                bw.write(key + "\t" + key2 + "\t" + this.calculateNegativeEuclidian(al1, al2));
                bw.newLine();
            }
        }
        bw.flush();
        bw.close();
    }

    private double calculateNegativeEuclidian(ArrayList<Double> al1, ArrayList<Double> al2) {
        double negativeEuclidian = 0.0;
        for (int i = 0; i < al1.size(); ++i) {
            double d1 = al1.get(i);
            double d2 = al2.get(i);
            negativeEuclidian += (d1 - d2) * (d1 - d2);
        }
        negativeEuclidian = Math.sqrt(negativeEuclidian);
        negativeEuclidian = -negativeEuclidian;
        return negativeEuclidian;
    }

    private double calculatePearson(ArrayList<Double> x, ArrayList<Double> y) {
        if (x.size() != y.size()) {
            System.err.println("The size of x and y have to be equal");
            return Double.NEGATIVE_INFINITY;
        }
        double correlation = 0.0;
        double meanX = Creator.mean(x);
        double meanY = Creator.mean(y);
        double standardDeviationX = Creator.standardDeviation(x, meanX);
        double standardDeviationY = Creator.standardDeviation(y, meanY);
        for (int i = 0; i < y.size(); ++i) {
            correlation += (x.get(i) - meanX) * (y.get(i) - meanY);
        }
        return correlation /= (double)x.size() * standardDeviationX * standardDeviationY;
    }

    private static double standardDeviation(ArrayList<Double> x, double meanX) {
        double standardDeviation = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            standardDeviation += (x.get(i) - meanX) * (x.get(i) - meanX);
        }
        standardDeviation /= (double)x.size();
        standardDeviation = Math.sqrt(standardDeviation);
        return standardDeviation;
    }

    private static double mean(ArrayList<Double> x) {
        double mean = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            mean += x.get(i).doubleValue();
        }
        return mean /= (double)x.size();
    }

    private void createHSPCluster(BlastFile bf, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins, int[] proteinLengths) {
        int j;
        HashMap integers2proteinsClone = (HashMap)integers2proteins.clone();
        HashMap proteins2integersClone = (HashMap)proteins2integers.clone();
        HashMap<String, SourceHSPs> sourceHSPs = new HashMap<String, SourceHSPs>();
        for (String id : integers2proteinsClone.keySet()) {
            int idInt = (Integer)integers2proteinsClone.get(id);
            SourceHSPs sHSP = new SourceHSPs(new ArrayList<boolean[]>(), proteinLengths[idInt], new ArrayList<Integer>(), id);
            sourceHSPs.put(id, sHSP);
        }
        for (int i = 0; i < bf.size; ++i) {
            if (bf.getSource(i) == bf.getTarget(i)) continue;
            SourceHSPs sourceHSP = (SourceHSPs)sourceHSPs.get(proteins2integersClone.get(bf.getSource(i)));
            SourceHSPs targetHSP = (SourceHSPs)sourceHSPs.get(proteins2integersClone.get(bf.getTarget(i)));
            boolean[] sourceCoverage = new boolean[proteinLengths[bf.getSource(i)]];
            boolean[] targetCoverage = new boolean[proteinLengths[bf.getTarget(i)]];
            Arrays.fill(sourceCoverage, bf.getStartQuery(i), bf.getEndQuery(i), true);
            Arrays.fill(targetCoverage, bf.getStartSubject(i), bf.getEndSubject(i), true);
            ArrayList<boolean[]> coveragesSource = sourceHSP.getCoverages();
            sourceHSP.addLine(i);
            if (coveragesSource.isEmpty()) {
                coveragesSource.add(sourceCoverage);
                sourceHSP.addCluster(0);
                sourceHSP.addClusterLine(0);
            } else {
                boolean match = false;
                for (j = 0; j < coveragesSource.size(); ++j) {
                    boolean[] coverage = coveragesSource.get(j);
                    float sim = this.calculateSimilarity(coverage, sourceCoverage);
                    if (!((double)sim > 0.8)) continue;
                    match = true;
                    sourceHSP.addCluster(j);
                    break;
                }
                if (!match) {
                    coveragesSource.add(sourceCoverage);
                    sourceHSP.setClusternr(sourceHSP.getClusternr() + 1);
                    sourceHSP.addClusterLine(i);
                    sourceHSP.addCluster(sourceHSP.getClusternr());
                }
            }
            ArrayList<boolean[]> coveragesTarget = targetHSP.getCoverages();
            targetHSP.addLine(i);
            if (coveragesTarget.isEmpty()) {
                coveragesTarget.add(targetCoverage);
                targetHSP.addCluster(0);
                targetHSP.addClusterLine(0);
                continue;
            }
            boolean match = false;
            for (int j2 = 0; j2 < coveragesTarget.size(); ++j2) {
                boolean[] coverage = coveragesTarget.get(j2);
                float sim = this.calculateSimilarity(coverage, targetCoverage);
                if (!((double)sim > 0.8)) continue;
                match = true;
                targetHSP.addCluster(j2);
                break;
            }
            if (match) continue;
            coveragesTarget.add(targetCoverage);
            targetHSP.setClusternr(targetHSP.getClusternr() + 1);
            targetHSP.addClusterLine(i);
            targetHSP.addCluster(targetHSP.getClusternr());
        }
        for (String key : sourceHSPs.keySet()) {
            SourceHSPs s = (SourceHSPs)sourceHSPs.get(key);
        }
        try {
            SourceHSPs source;
            String line;
            BufferedReader br = new BufferedReader(new FileReader(Config.blastFile));
            BufferedWriter bw = new BufferedWriter(new FileWriter(Config.blastFile + "HSP"));
            int k = 0;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("")) continue;
                String[] tabs = line.split("\t");
                if (tabs[0].equals(tabs[1])) {
                    ++k;
                    continue;
                }
                SourceHSPs source2 = (SourceHSPs)sourceHSPs.get(tabs[0]);
                SourceHSPs target = (SourceHSPs)sourceHSPs.get(tabs[1]);
                int sourceIndex = source2.getLines().indexOf(k);
                int targetIndex = target.getLines().indexOf(k);
                bw.write(tabs[0] + "_HSP" + source2.getCluster(sourceIndex) + "\t" + tabs[1] + "_HSP" + target.getCluster(targetIndex) + "\t");
                for (int j3 = 2; j3 < tabs.length; ++j3) {
                    bw.write(tabs[j3]);
                    if (j3 < tabs.length - 1) {
                        bw.write("\t");
                        continue;
                    }
                    bw.newLine();
                }
                ++k;
            }
            br.close();
            bw.flush();
            bw.close();
            br = new BufferedReader(new FileReader(Config.fastaFile));
            bw = new BufferedWriter(new FileWriter(Config.fastaFile + "HSP"));
            String sequence = "";
            String id = "";
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("")) continue;
                if (line.startsWith(">")) {
                    if (!sequence.equals("")) {
                        source = (SourceHSPs)sourceHSPs.get(id);
                        for (j = 0; j <= source.getClusternr(); ++j) {
                            bw.write(">" + id + "_HSP" + j);
                            bw.newLine();
                            bw.write(sequence);
                            bw.newLine();
                        }
                        sequence = "";
                    }
                    id = line.substring(1);
                    continue;
                }
                sequence = sequence + line;
            }
            source = (SourceHSPs)sourceHSPs.get(id);
            for (j = 0; j <= source.getClusternr(); ++j) {
                bw.write(">" + id + "_HSP" + j);
                bw.newLine();
                bw.write(sequence);
                bw.newLine();
            }
            br.close();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private float calculateSimilarity(boolean[] bs, boolean[] bs2) {
        float sim = 0.0f;
        for (int i = 0; i < bs2.length; ++i) {
            if ((!bs[i] || !bs2[i]) && (bs[i] || bs2[i])) continue;
            sim += 1.0f;
        }
        return sim /= (float)bs.length;
    }

    private void createSimilarityFileFromArray(String outputFile, BlastFile bf, HashMap<Integer, String> proteins2integers, int[] proteinLengths, int costModel) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        double percent = 0.0;
        double percentOld = 0.0;
        if (Config.gui) {
            Console.println("start calculating similarities and writing file ...");
            Console.setBarValue(0);
            Console.restartBarTimer();
            Console.setBarText("calculating similarities and writing file");
        }
        int i = 0;
        while (i < bf.size) {
            int target;
            if (i % 100000 == 0 && i > 0 && (percent = Math.rint((double)i / (double)bf.size * 10000.0) / 100.0) > percentOld + 1.0) {
                percentOld = percent;
                if (Config.gui) {
                    Console.setBarValue((int)Math.rint(percent));
                    Console.setBarTextPlusRestTime("calculating similarities and writing file  " + percent + " %");
                }
            }
            Vector<Integer> v = new Vector<Integer>();
            int source = bf.getSource(i);
            if (source == (target = bf.getTarget(i))) {
                ++i;
                continue;
            }
            v.add(i);
            int j = 1;
            try {
                while (true) {
                    int source2 = bf.getSource(i + j);
                    int target2 = bf.getTarget(i + j);
                    if (source != source2 || target != target2) break;
                    v.add(i + j);
                    ++j;
                }
                i += j;
            }
            catch (Exception e) {
                i += j;
            }
            switch (costModel) {
                case 0: {
                    double similarity = Creator.calculateBeH(v, bf);
                    String sourceString = proteins2integers.get(source);
                    String targetString = proteins2integers.get(target);
                    if (similarity == 0.0) break;
                    bw.write(sourceString + InOut.TAB + targetString + InOut.TAB + Double.toString(similarity));
                    bw.newLine();
                    ++Config.linesInSimilarityFile;
                    break;
                }
                case 1: {
                    double similarity = Creator.calculateSoH(v, bf);
                    if (similarity == 0.0) break;
                    String sourceString = proteins2integers.get(source);
                    String targetString = proteins2integers.get(target);
                    bw.write(sourceString + InOut.TAB + targetString + InOut.TAB + Double.toString(similarity));
                    bw.newLine();
                    ++Config.linesInSimilarityFile;
                    break;
                }
                case 2: {
                    double similarity = Creator.calculateBeH(v, bf);
                    double coverage = Creator.calculateCoverage(v, bf, proteinLengths, source, target);
                    if (similarity == 0.0) break;
                    String sourceString = proteins2integers.get(source);
                    String targetString = proteins2integers.get(target);
                    bw.write(sourceString + InOut.TAB + targetString + InOut.TAB + Double.toString(similarity + coverage));
                    bw.newLine();
                    ++Config.linesInSimilarityFile;
                    break;
                }
                case 3: {
                    double similarity = Creator.calculateSoH(v, bf);
                    double coverage = Creator.calculateCoverage(v, bf, proteinLengths, source, target);
                    if (similarity == 0.0) break;
                    String sourceString = proteins2integers.get(source);
                    String targetString = proteins2integers.get(target);
                    bw.write(sourceString + InOut.TAB + targetString + InOut.TAB + Double.toString(similarity + coverage));
                    bw.newLine();
                    ++Config.linesInSimilarityFile;
                    break;
                }
                case 4: {
                    double similarity = Creator.calculateScore(v, bf);
                    String sourceString = proteins2integers.get(source);
                    String targetString = proteins2integers.get(target);
                    if (similarity == 0.0) break;
                    bw.write(sourceString + InOut.TAB + targetString + InOut.TAB + Double.toString(similarity));
                    bw.newLine();
                    ++Config.linesInSimilarityFile;
                    break;
                }
            }
        }
        bw.close();
    }

    private static double calculateBeH(Vector<Integer> v, BlastFile bf) {
        double bestEvalue = 0.0;
        for (int k = 0; k < v.size(); ++k) {
            int line = v.get(k);
            double evalue = bf.getEvalue(line);
            if (!(evalue > bestEvalue)) continue;
            bestEvalue = evalue;
        }
        if (bestEvalue < 0.0) {
            Console.println("" + bestEvalue);
        }
        return bestEvalue;
    }

    private static double calculateScore(Vector<Integer> v, BlastFile bf) {
        double bestEvalue = 0.0;
        for (int k = 0; k < v.size(); ++k) {
            int line = v.get(k);
            double evalue = bf.getScore(line);
            if (!(evalue > bestEvalue)) continue;
            bestEvalue = evalue;
        }
        if (bestEvalue < 0.0) {
            Console.println("" + bestEvalue);
        }
        return bestEvalue;
    }

    private static double calculateSoH(Vector<Integer> v, BlastFile bf) {
        double similarity = 0.0;
        for (int k = 0; k < v.size(); ++k) {
            int line = v.get(k);
            double evalue = bf.getEvalue(line);
            similarity += evalue;
        }
        return similarity;
    }

    private static double calculateCoverage(Vector<Integer> v, BlastFile bf, int[] proteinLengths, int source, int target) {
        double coverage = 0.0;
        int sourceLength = proteinLengths[source];
        int targetLength = proteinLengths[target];
        boolean[] query = new boolean[sourceLength];
        boolean[] subject = new boolean[targetLength];
        for (int k = 0; k < v.size(); ++k) {
            int i;
            int line = v.get(k);
            int startQuery = bf.getStartQuery(line);
            int endQuery = bf.getEndQuery(line);
            int startSubject = bf.getStartSubject(line);
            int endSubject = bf.getEndSubject(line);
            for (i = startQuery; i < endQuery; ++i) {
                query[i] = true;
            }
            for (i = startSubject; i < endSubject; ++i) {
                subject[i] = true;
            }
        }
        double queryCoverage = 0.0;
        for (int i = 0; i < query.length; ++i) {
            if (!query[i]) continue;
            queryCoverage += 1.0;
        }
        double subjectCoverage = 0.0;
        for (int i = 0; i < subject.length; ++i) {
            if (!subject[i]) continue;
            subjectCoverage += 1.0;
        }
        coverage = Math.min(queryCoverage /= (double)sourceLength, subjectCoverage /= (double)targetLength) * (double)Config.coverageFactor;
        return coverage;
    }
}

