/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering.FixedParameterTreeNode;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;

public class FixedParameterClusterer {
    private ConnectedComponent cc;
    private double maxK;
    private FixedParameterTreeNode solution;
    private long startTime;

    public FixedParameterClusterer(ConnectedComponent cc) {
        this.cc = cc;
        this.maxK = 0.0;
        this.startTime = System.currentTimeMillis();
        while (this.solution == null) {
            if (System.currentTimeMillis() - this.startTime > TaskConfig.fpMaxTimeMillis) {
                TaskConfig.fpStopped = true;
                return;
            }
            FixedParameterTreeNode fptn = this.initFirstTreeNode();
            this.cluster(fptn);
            this.maxK += 10.0;
        }
        this.buildClusters(this.solution);
    }

    public FixedParameterClusterer(ConnectedComponent cc, double maxK) {
        this.cc = cc;
        this.maxK = maxK / 2.0;
        this.startTime = System.currentTimeMillis();
        while (this.solution == null) {
            if (System.currentTimeMillis() - this.startTime > TaskConfig.fpMaxTimeMillis) {
                TaskConfig.fpStopped = true;
                return;
            }
            FixedParameterTreeNode fptn = this.initFirstTreeNode();
            this.cluster(fptn);
            this.maxK += maxK / 10.0;
        }
        this.buildClusters(this.solution);
    }

    public void assingCluster(int[] nodes2clusters, int clusterNr, int node_i, boolean[] already, float[][] edges) {
        for (int i = 0; i < edges.length; ++i) {
            if (already[i] || !(edges[node_i][i] > 0.0f)) continue;
            nodes2clusters[i] = clusterNr;
            already[i] = true;
            this.assingCluster(nodes2clusters, clusterNr, i, already, edges);
        }
    }

    public void buildClusters(FixedParameterTreeNode solution) {
        float[][] edges = solution.edgeCosts;
        int[] nodes2clustersReduced = new int[solution.size];
        int clusterNr = 0;
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        for (int i = 0; i < edges.length; ++i) {
            if (already[i]) continue;
            nodes2clustersReduced[i] = clusterNr;
            already[i] = true;
            this.assingCluster(nodes2clustersReduced, clusterNr, i, already, edges);
            ++clusterNr;
        }
        int[] nodes2clusters = new int[this.cc.getNodeNumber()];
        for (int i = 0; i < nodes2clustersReduced.length; ++i) {
            for (int j = 0; j < solution.clusters[i].length; ++j) {
                if (!solution.clusters[i][j]) continue;
                nodes2clusters[j] = nodes2clustersReduced[i];
            }
        }
        this.cc.initialiseClusterInfo(clusterNr);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(nodes2clusters));
        this.cc.setClusters(nodes2clusters);
        this.cc.calculateClusterDistribution();
    }

    public float calculateCostsForMerging(FixedParameterTreeNode fptn, int node_i, int node_j) {
        float costsForMerging = 0.0f;
        for (int i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j) continue;
            if (fptn.edgeCosts[i][node_i] > 0.0f && fptn.edgeCosts[i][node_j] <= 0.0f) {
                costsForMerging += Math.min(fptn.edgeCosts[i][node_i], -fptn.edgeCosts[i][node_j]);
                continue;
            }
            if (!(fptn.edgeCosts[i][node_i] <= 0.0f) || !(fptn.edgeCosts[i][node_j] > 0.0f)) continue;
            costsForMerging += Math.min(-fptn.edgeCosts[i][node_i], fptn.edgeCosts[i][node_j]);
        }
        return costsForMerging;
    }

    public float calculateCostsForSetForbidden(FixedParameterTreeNode fptn, int node_i, int node_j) {
        float costs = 0.0f;
        for (int i = 0; i < fptn.size; ++i) {
            if (!(fptn.edgeCosts[node_i][i] > 0.0f) || !(fptn.edgeCosts[node_j][i] > 0.0f)) continue;
            costs += Math.min(fptn.edgeCosts[node_i][i], fptn.edgeCosts[node_j][i]);
        }
        return costs += fptn.edgeCosts[node_i][node_j];
    }

    public void cluster(FixedParameterTreeNode fptn) {
        float costsForMerging;
        if (System.currentTimeMillis() - this.startTime > TaskConfig.fpMaxTimeMillis) {
            TaskConfig.fpStopped = true;
            return;
        }
        int[] edge = this.findNextConflictTriple2(fptn);
        if (edge == null) {
            this.maxK = fptn.costs;
            this.solution = fptn.copy();
            return;
        }
        float costsForSetForbidden = this.calculateCostsForSetForbidden(fptn, edge[0], edge[1]);
        if ((double)(fptn.costs + costsForSetForbidden) <= this.maxK) {
            this.setForbiddenAndCluster(fptn, edge[0], edge[1], fptn.edgeCosts[edge[0]][edge[1]]);
        }
        if ((double)((costsForMerging = this.calculateCostsForMerging(fptn, edge[0], edge[1])) + fptn.costs) <= this.maxK) {
            FixedParameterTreeNode fptn2 = this.mergeNodes(fptn, edge[0], edge[1], costsForMerging);
            this.cluster(fptn2);
        }
    }

    public int[] findNextConflictTriple2(FixedParameterTreeNode fptn) {
        int[] bestEdge = new int[2];
        float highestOccurence = 0.0f;
        float occurence = 0.0f;
        for (int i = 0; i < fptn.size; ++i) {
            for (int j = i + 1; j < fptn.size; ++j) {
                if (!(fptn.edgeCosts[i][j] > 0.0f) || !((occurence = Math.abs(this.calculateCostsForMerging(fptn, i, j) - this.calculateCostsForSetForbidden(fptn, i, j))) > highestOccurence)) continue;
                highestOccurence = occurence;
                bestEdge[0] = i;
                bestEdge[1] = j;
            }
        }
        if (highestOccurence == 0.0f) {
            return null;
        }
        return bestEdge;
    }

    public int[] findNextConflictTriple3(FixedParameterTreeNode fptn) {
        int j;
        int i;
        float[][] numberOfOccurencesInConflictTriples = new float[fptn.size][fptn.size];
        for (i = 0; i < fptn.size; ++i) {
            for (j = i + 1; j < fptn.size; ++j) {
                for (int k = j + 1; k < fptn.size; ++k) {
                    if (fptn.edgeCosts[i][j] + fptn.edgeCosts[i][k] + fptn.edgeCosts[k][j] != 2.0f) continue;
                    float[] fArray = numberOfOccurencesInConflictTriples[i];
                    int n = j;
                    fArray[n] = fArray[n] + 1.0f;
                    float[] fArray2 = numberOfOccurencesInConflictTriples[i];
                    int n2 = k;
                    fArray2[n2] = fArray2[n2] + 1.0f;
                    float[] fArray3 = numberOfOccurencesInConflictTriples[j];
                    int n3 = k;
                    fArray3[n3] = fArray3[n3] + 1.0f;
                }
            }
        }
        for (i = 0; i < fptn.size; ++i) {
            for (j = i + 1; j < fptn.size; ++j) {
                if (!(fptn.edgeCosts[i][j] > 0.0f)) continue;
                float f = Math.abs(this.calculateCostsForMerging(fptn, i, j) - this.calculateCostsForSetForbidden(fptn, i, j));
                numberOfOccurencesInConflictTriples[j][i] = f;
                numberOfOccurencesInConflictTriples[i][j] = f;
            }
        }
        int[] bestEdge = new int[2];
        float highestOccurence = 0.0f;
        for (int i2 = 0; i2 < fptn.size; ++i2) {
            for (int j2 = i2 + 1; j2 < fptn.size; ++j2) {
                if (!(numberOfOccurencesInConflictTriples[i2][j2] > highestOccurence)) continue;
                highestOccurence = numberOfOccurencesInConflictTriples[i2][j2];
                bestEdge[0] = i2;
                bestEdge[1] = j2;
            }
        }
        if (highestOccurence == 0.0f) {
            return null;
        }
        return bestEdge;
    }

    public FixedParameterTreeNode initFirstTreeNode() {
        FixedParameterTreeNode fptn = new FixedParameterTreeNode(this.cc.getNodeNumber(), 0.0f, this.cc.getNodeNumber());
        for (int i = 0; i < fptn.size; ++i) {
            fptn.clusters[i][i] = true;
            for (int j = i + 1; j < fptn.size; ++j) {
                float f = this.cc.getCCEdges().getEdgeCost(i, j);
                fptn.edgeCosts[j][i] = f;
                fptn.edgeCosts[i][j] = f;
            }
        }
        fptn = this.reductionicf(fptn);
        return fptn;
    }

    public FixedParameterTreeNode mergeNodes(FixedParameterTreeNode fptn, int node_i, int node_j, float costsForMerging) {
        int i;
        FixedParameterTreeNode fptnNew = new FixedParameterTreeNode(fptn.size - 1, fptn.costs, this.cc.getNodeNumber());
        fptnNew.costs = fptn.costs + costsForMerging;
        int[] mappingOld2New = new int[fptn.size];
        int j = 0;
        for (i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j) continue;
            mappingOld2New[i] = j;
            fptnNew.clusters[j] = fptn.clusters[i];
            ++j;
        }
        for (i = 0; i < mappingOld2New.length; ++i) {
            if (i == node_i || i == node_j) continue;
            for (j = i + 1; j < mappingOld2New.length; ++j) {
                if (j == node_i || j == node_j) continue;
                float f = fptn.edgeCosts[i][j];
                fptnNew.edgeCosts[mappingOld2New[j]][mappingOld2New[i]] = f;
                fptnNew.edgeCosts[mappingOld2New[i]][mappingOld2New[j]] = f;
            }
        }
        for (i = 0; i < this.cc.getNodeNumber(); ++i) {
            fptnNew.clusters[fptnNew.size - 1][i] = fptn.clusters[node_i][i] || fptn.clusters[node_j][i];
        }
        for (i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j) continue;
            float f = fptn.edgeCosts[i][node_i] + fptn.edgeCosts[i][node_j];
            fptnNew.edgeCosts[fptnNew.size - 1][mappingOld2New[i]] = f;
            fptnNew.edgeCosts[mappingOld2New[i]][fptnNew.size - 1] = f;
        }
        return fptnNew;
    }

    public FixedParameterTreeNode reductionicf(FixedParameterTreeNode fptnNew) {
        if ((double)fptnNew.costs > this.maxK) {
            return fptnNew;
        }
        for (int i = 0; i < fptnNew.size; ++i) {
            for (int j = i + 1; j < fptnNew.size; ++j) {
                if (fptnNew.edgeCosts[i][j] <= 0.0f) continue;
                float sumIcf = this.calculateCostsForSetForbidden(fptnNew, i, j);
                float sumIcp = this.calculateCostsForMerging(fptnNew, i, j);
                if ((double)(sumIcf + fptnNew.costs) > this.maxK && (double)(sumIcp + fptnNew.costs) > this.maxK) {
                    fptnNew.costs = Float.POSITIVE_INFINITY;
                    return fptnNew;
                }
                if ((double)(sumIcf + fptnNew.costs) > this.maxK) {
                    float costsForMerging = this.calculateCostsForMerging(fptnNew, i, j);
                    FixedParameterTreeNode fptnNew2 = this.mergeNodes(fptnNew, i, j, costsForMerging);
                    fptnNew2 = this.reductionicf(fptnNew2);
                    return fptnNew2;
                }
                if (!((double)(sumIcp + fptnNew.costs) > this.maxK)) continue;
                fptnNew.costs += fptnNew.edgeCosts[i][j];
                fptnNew.edgeCosts[j][i] = Float.NEGATIVE_INFINITY;
                fptnNew.edgeCosts[i][j] = Float.NEGATIVE_INFINITY;
                fptnNew = this.reductionicf(fptnNew);
                return fptnNew;
            }
        }
        return fptnNew;
    }

    public void setForbiddenAndCluster(FixedParameterTreeNode fptn, int node_i, int node_j, float costsForSetForbidden) {
        fptn.costs += fptn.edgeCosts[node_i][node_j];
        fptn.edgeCosts[node_j][node_i] = Float.NEGATIVE_INFINITY;
        fptn.edgeCosts[node_i][node_j] = Float.NEGATIVE_INFINITY;
        this.cluster(fptn);
        fptn.costs -= costsForSetForbidden;
        float f = costsForSetForbidden;
        fptn.edgeCosts[node_j][node_i] = f;
        fptn.edgeCosts[node_i][node_j] = f;
    }
}

