/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;

public class FixedParameterClusterer2 {
    private ConnectedComponent cc;
    private double maxK;
    private long startTime;
    private float[][] graph;
    private double costs;
    private double solutionCost;
    private float[][] solution;
    private long treesize;
    private int depth;

    public FixedParameterClusterer2(ConnectedComponent cc, double maxK) {
        this.cc = cc;
        this.maxK = maxK / 2.0;
        this.startTime = System.currentTimeMillis();
        this.graph = new float[this.cc.getNodeNumber()][this.cc.getNodeNumber()];
        this.solutionCost = -1.0;
        this.costs = this.cc.getClusteringScore();
        this.costs = 0.0;
        this.depth = 0;
        if (this.costs == -1.0) {
            this.costs = 0.0;
        }
        this.treesize = 0L;
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            for (int j = i + 1; j < this.cc.getNodeNumber(); ++j) {
                float f = this.cc.getCCEdges().getEdgeCost(i, j);
                this.graph[j][i] = f;
                this.graph[i][j] = f;
            }
        }
        this.run();
    }

    private void run() {
        this.findNextEdge();
        while (this.solutionCost < 0.0) {
            if (System.currentTimeMillis() - this.startTime > TaskConfig.fpMaxTimeMillis) {
                TaskConfig.fpStopped = true;
                return;
            }
            this.cluster();
            this.maxK += this.maxK / 10.0;
        }
        this.buildSolution();
        TaskConfig.fpStopped = true;
    }

    private void buildSolution() {
        float[][] edges = this.solution;
        int[] nodes2clustersReduced = new int[this.solution.length];
        int clusterNr = 0;
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        for (int i = 0; i < edges.length; ++i) {
            if (already[i]) continue;
            nodes2clustersReduced[i] = clusterNr;
            already[i] = true;
            this.assingCluster(nodes2clustersReduced, clusterNr, i, already, edges);
            ++clusterNr;
        }
        this.cc.initialiseClusterInfo(clusterNr);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(nodes2clustersReduced));
        this.cc.setClusters(nodes2clustersReduced);
        this.cc.calculateClusterDistribution();
    }

    public void assingCluster(int[] nodes2clusters, int clusterNr, int node_i, boolean[] already, float[][] edges) {
        for (int i = 0; i < edges.length; ++i) {
            if (already[i] || !(edges[node_i][i] > 0.0f)) continue;
            nodes2clusters[i] = clusterNr;
            already[i] = true;
            this.assingCluster(nodes2clusters, clusterNr, i, already, edges);
        }
    }

    private void cluster() {
        float costsForSetForbidden;
        ++this.treesize;
        if (System.currentTimeMillis() - this.startTime > TaskConfig.fpMaxTimeMillis) {
            TaskConfig.fpStopped = true;
            return;
        }
        this.reductionicf();
        int[] edge = this.findNextEdge();
        if (edge == null) {
            this.maxK = this.costs;
            this.solutionCost = this.costs;
            this.solution = (float[][])this.graph.clone();
            return;
        }
        float costsForMerging = this.calculateCostsForMerging(edge[0], edge[1]);
        if ((double)costsForMerging + this.costs <= this.maxK) {
            float oldvalue = this.graph[edge[0]][edge[1]];
            if (this.graph[edge[0]][edge[1]] < 0.0f) {
                this.costs -= (double)oldvalue;
            }
            float[][] graphCopy = (float[][])this.graph.clone();
            this.graph[edge[1]][edge[0]] = Float.POSITIVE_INFINITY;
            this.graph[edge[0]][edge[1]] = Float.POSITIVE_INFINITY;
            float dum = 0.0f;
            for (int i = 0; i < this.graph.length; ++i) {
                if (i == edge[0] || i == edge[1]) continue;
                if (this.graph[edge[0]][i] == Float.POSITIVE_INFINITY && this.graph[edge[1]][i] != Float.POSITIVE_INFINITY) {
                    if (this.graph[edge[1]][i] < 0.0f) {
                        dum -= this.graph[edge[1]][i];
                    }
                    this.graph[edge[1]][i] = Float.POSITIVE_INFINITY;
                    continue;
                }
                if (this.graph[edge[1]][i] != Float.POSITIVE_INFINITY || this.graph[edge[0]][i] == Float.POSITIVE_INFINITY) continue;
                if (this.graph[edge[0]][i] < 0.0f) {
                    dum -= this.graph[edge[0]][i];
                }
                this.graph[edge[0]][i] = Float.POSITIVE_INFINITY;
            }
            if (dum < Float.POSITIVE_INFINITY) {
                this.costs += (double)dum;
                ++this.depth;
                this.cluster();
                --this.depth;
                this.costs -= (double)dum;
            }
            this.graph = graphCopy;
            float f = oldvalue;
            this.graph[edge[1]][edge[0]] = f;
            this.graph[edge[0]][edge[1]] = f;
            if (oldvalue < 0.0f) {
                this.costs += (double)oldvalue;
            }
        }
        if (this.costs + (double)(costsForSetForbidden = this.calculateCostsForSetForbidden(edge[0], edge[1])) <= this.maxK) {
            float oldvalue = this.graph[edge[0]][edge[1]];
            if (this.graph[edge[0]][edge[1]] > 0.0f) {
                this.costs += (double)oldvalue;
            }
            this.graph[edge[1]][edge[0]] = Float.NEGATIVE_INFINITY;
            this.graph[edge[0]][edge[1]] = Float.NEGATIVE_INFINITY;
            ++this.depth;
            this.cluster();
            --this.depth;
            float f = oldvalue;
            this.graph[edge[1]][edge[0]] = f;
            this.graph[edge[0]][edge[1]] = f;
            if (oldvalue > 0.0f) {
                this.costs -= (double)oldvalue;
            }
        }
    }

    private void reductionicf() {
    }

    public int[] findNextEdge() {
        int[] bestEdge = new int[2];
        float[][] numberOfOccurencesInConflictTriples = new float[this.graph.length][this.graph.length];
        for (int i = 0; i < this.graph.length; ++i) {
            for (int j = i + 1; j < this.graph.length; ++j) {
                if (this.graph[i][j] == Float.POSITIVE_INFINITY || this.graph[i][j] == Float.NEGATIVE_INFINITY || !(this.graph[i][j] > 0.0f)) continue;
                float f = Math.abs(this.calculateCostsForMerging(i, j) - this.calculateCostsForSetForbidden(i, j));
                numberOfOccurencesInConflictTriples[j][i] = f;
                numberOfOccurencesInConflictTriples[i][j] = f;
            }
        }
        float highestOccurence = 0.0f;
        for (int i = 0; i < this.graph.length; ++i) {
            for (int j = i + 1; j < this.graph.length; ++j) {
                if (!(numberOfOccurencesInConflictTriples[i][j] > highestOccurence)) continue;
                highestOccurence = numberOfOccurencesInConflictTriples[i][j];
                bestEdge[0] = i;
                bestEdge[1] = j;
            }
        }
        if (highestOccurence == 0.0f) {
            return null;
        }
        return bestEdge;
    }

    private float calculateCostsForMerging(int node_i, int node_j) {
        float costsForMerging = 0.0f;
        for (int i = 0; i < this.graph.length; ++i) {
            if (i == node_i || i == node_j || this.graph[i][node_i] > 0.0f && this.graph[i][node_j] > 0.0f || this.graph[i][node_i] <= 0.0f && this.graph[i][node_j] <= 0.0f) continue;
            costsForMerging += Math.min(Math.abs(this.graph[i][node_i]), Math.abs(this.graph[i][node_j]));
        }
        return costsForMerging;
    }

    private float calculateCostsForSetForbidden(int node_i, int node_j) {
        float costs = 0.0f;
        for (int i = 0; i < this.graph.length; ++i) {
            if (!(this.graph[i][node_i] > 0.0f) || !(this.graph[i][node_j] > 0.0f)) continue;
            costs += Math.min(this.graph[i][node_i], this.graph[i][node_j]);
        }
        return costs += this.graph[node_i][node_j];
    }
}

