/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering;

import java.util.Arrays;

public class FixedParameterTreeNode {
    public float[][] edgeCosts;
    public boolean[][] clusters;
    public float costs;
    public int size;

    public FixedParameterTreeNode(int size, float costs, int elementNumber) {
        this.size = size;
        this.edgeCosts = new float[size][size];
        this.clusters = new boolean[size][elementNumber];
        this.costs = costs;
    }

    public FixedParameterTreeNode copy() {
        FixedParameterTreeNode fptn = new FixedParameterTreeNode(this.size, this.costs, this.clusters[0].length);
        for (int i = 0; i < this.size; ++i) {
            fptn.edgeCosts[i] = Arrays.copyOf(this.edgeCosts[i], this.size);
            fptn.clusters[i] = Arrays.copyOf(this.clusters[i], this.clusters[i].length);
        }
        return fptn;
    }

    public float calculateCostsForSetForbidden(int node_i, int node_j) {
        float costsForSetForbidden = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.edgeCosts[node_i][i] > 0.0f) || !(this.edgeCosts[node_j][i] > 0.0f)) continue;
            costsForSetForbidden += Math.min(this.edgeCosts[node_i][i], this.edgeCosts[node_j][i]);
        }
        return costsForSetForbidden += this.edgeCosts[node_i][node_j];
    }
}

