/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.KmeansClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.SingleLinkageClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ConfigFile;

public class GeometricClusteringFactory {
    public static EnumGeometricClusteringClass getClustererEnumByClass(String className) throws InvalidTypeException {
        if (className.equals(EnumGeometricClusteringClass.SINGLE_LINKAGE_CLUSTERING.getClassname())) {
            return EnumGeometricClusteringClass.SINGLE_LINKAGE_CLUSTERING;
        }
        if (className.equals(EnumGeometricClusteringClass.KMEANS_CLUSTERING.getClassname())) {
            return EnumGeometricClusteringClass.KMEANS_CLUSTERING;
        }
        throw new InvalidTypeException("GeometricClusteringFactory: This geometric clustering class does not exist: " + className + ".\nOr it has not been bound into the program correctly.");
    }

    public static void printParametersToConfig(ConfigFile confile) {
        confile.printSubHeader("SINGLE LINKAGE CLUSTERING");
        confile.printParameter("slc.minDistance", "" + GeometricClusteringConfig.minDistance);
        confile.printParameter("slc.maxDistance", "" + GeometricClusteringConfig.maxDistance);
        confile.printParameter("slc.stepsize", "" + GeometricClusteringConfig.stepsize);
        confile.printParameter("slc.stepsizeFactor", "" + GeometricClusteringConfig.stepsizeFactor);
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
        confile.printSubHeader("K-MEANS CLUSTERING");
        confile.printParameter("km.maxK", "" + GeometricClusteringConfig.kLimit);
        confile.printParameter("km.maxInitStartConfigs", "" + GeometricClusteringConfig.maxInitStartConfigs);
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumGeometricClusteringClass {
        SINGLE_LINKAGE_CLUSTERING("SingleLinkageClusterer", 0),
        KMEANS_CLUSTERING("KmeansClusterer", 1);

        private final String classname;
        private final int intvalue;

        private EnumGeometricClusteringClass(String classname, int intvalue) {
            this.classname = classname;
            this.intvalue = intvalue;
        }

        public String getClassname() {
            return this.classname;
        }

        public int getIntvalue() {
            return this.intvalue;
        }

        public IGeometricClusterer createGeometricClusterer() {
            if (this.intvalue == 0) {
                return new SingleLinkageClusterer();
            }
            if (this.intvalue == 1) {
                return new KmeansClusterer();
            }
            return null;
        }

        public static String[] getClassnames() {
            EnumGeometricClusteringClass[] values = EnumGeometricClusteringClass.values();
            String[] classnames = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                classnames[i] = values[i].getClassname();
            }
            return classnames;
        }
    }
}

