/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy.AffinityObject;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreedyClusterer {
    private ConnectedComponent cc;
    private int[] listOfElementsSortedByCosts;
    private boolean changed = false;
    private ICCEdges icce;
    private int count;
    private int[] bestClusters;
    private double bestCosts = Double.MAX_VALUE;
    private int k = 0;

    public GreedyClusterer(ConnectedComponent cc) {
        this.cc = cc;
        this.listOfElementsSortedByCosts = new int[cc.getNodeNumber()];
        this.icce = cc.getCCEdges();
        this.count = cc.getNodeNumber();
        this.cluster2();
    }

    public GreedyClusterer(ConnectedComponent cc, int limitK) {
        this.cc = cc;
        this.listOfElementsSortedByCosts = new int[cc.getNodeNumber()];
        this.icce = cc.getCCEdges();
        this.count = cc.getNodeNumber();
        this.k = limitK;
        this.cluster2(this.k);
    }

    private void cluster2(int k2) {
        int i;
        this.generateSortedList();
        this.count = 0;
        int startNode = this.listOfElementsSortedByCosts[0];
        Vector clusters = new Vector();
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        TreeMap<AffinityObject, Integer> affinities = new TreeMap<AffinityObject, Integer>();
        TreeMap<AffinityObject, Integer> internalAffinities = new TreeMap<AffinityObject, Integer>();
        already[startNode] = true;
        ++this.count;
        int count2 = 0;
        for (int i2 = 0; i2 < this.listOfElementsSortedByCosts.length; ++i2) {
            if (already[i2]) continue;
            ++count2;
            double affinity = this.icce.getEdgeCost(i2, startNode);
            AffinityObject ao = new AffinityObject(i2);
            ao.affinity = affinity;
            affinities.put(ao, i2);
        }
        AffinityObject startObject = new AffinityObject(startNode);
        startObject.affinity = 0.0;
        internalAffinities.put(startObject, startNode);
        this.buildCluster2(affinities, internalAffinities, already);
        Vector<Integer> cluster2 = new Vector<Integer>();
        cluster2.addAll(internalAffinities.values());
        clusters.add(cluster2);
        this.generateSortedList(already);
        for (i = 0; i < this.listOfElementsSortedByCosts.length && clusters.size() < this.k; ++i) {
            System.out.println(clusters.size() + "\t" + this.k);
            startNode = this.listOfElementsSortedByCosts[i];
            if (already[startNode]) continue;
            ++this.count;
            already[startNode] = true;
            affinities = new TreeMap();
            internalAffinities = new TreeMap();
            for (int j = 0; j < this.listOfElementsSortedByCosts.length; ++j) {
                if (already[j]) continue;
                double affinity = this.icce.getEdgeCost(j, startNode);
                AffinityObject ao = new AffinityObject(j);
                ao.affinity = affinity;
                affinities.put(ao, j);
            }
            startObject = new AffinityObject(startNode);
            startObject.affinity = 0.0;
            internalAffinities.put(startObject, startNode);
            this.buildCluster2(affinities, internalAffinities, already);
            cluster2 = new Vector<Integer>();
            cluster2.addAll(internalAffinities.values());
            clusters.add(cluster2);
            this.generateSortedList(already);
            i = 0;
            if (this.count == this.listOfElementsSortedByCosts.length) continue;
            i = 0;
        }
        for (i = 0; i < already.length; ++i) {
            if (already[i]) continue;
            double bestCosts = Double.NEGATIVE_INFINITY;
            Vector bestcluster = new Vector();
            for (Vector vector : clusters) {
                double costs = 0.0;
                for (Integer integer : vector) {
                    costs += (double)this.icce.getEdgeCost(i, integer);
                }
                if (!(costs < bestCosts)) continue;
                bestCosts = costs;
                bestcluster = vector;
            }
            bestcluster.add(i);
        }
        int[] clusters2nodes = new int[this.cc.getNodeNumber()];
        for (int i3 = 0; i3 < clusters.size(); ++i3) {
            cluster2 = (Vector<Integer>)clusters.get(i3);
            for (int j = 0; j < cluster2.size(); ++j) {
                clusters2nodes[((Integer)cluster2.get((int)j)).intValue()] = i3;
            }
        }
        this.bestClusters = clusters2nodes;
        int noOfClusters = 0;
        noOfClusters = clusters.size();
        this.cc.initialiseClusterInfo(noOfClusters);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(this.bestClusters));
        this.cc.setClusters(this.bestClusters);
        this.cc.calculateClusterDistribution();
    }

    private double cluster2() {
        this.generateSortedList();
        this.count = 0;
        int startNode = this.listOfElementsSortedByCosts[0];
        Vector clusters = new Vector();
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        TreeMap<AffinityObject, Integer> affinities = new TreeMap<AffinityObject, Integer>();
        TreeMap<AffinityObject, Integer> internalAffinities = new TreeMap<AffinityObject, Integer>();
        already[startNode] = true;
        ++this.count;
        int count2 = 0;
        for (int i = 0; i < this.listOfElementsSortedByCosts.length; ++i) {
            if (already[i]) continue;
            ++count2;
            double affinity = this.icce.getEdgeCost(i, startNode);
            AffinityObject ao = new AffinityObject(i);
            ao.affinity = affinity;
            affinities.put(ao, i);
        }
        AffinityObject startObject = new AffinityObject(startNode);
        startObject.affinity = 0.0;
        internalAffinities.put(startObject, startNode);
        this.buildCluster2(affinities, internalAffinities, already);
        Vector<Integer> cluster2 = new Vector<Integer>();
        cluster2.addAll(internalAffinities.values());
        clusters.add(cluster2);
        for (int i = 0; i < this.listOfElementsSortedByCosts.length; ++i) {
            startNode = this.listOfElementsSortedByCosts[i];
            if (already[startNode]) continue;
            ++this.count;
            already[startNode] = true;
            affinities = new TreeMap();
            internalAffinities = new TreeMap();
            for (int j = 0; j < this.listOfElementsSortedByCosts.length; ++j) {
                if (already[j]) continue;
                double affinity = this.icce.getEdgeCost(j, startNode);
                AffinityObject ao = new AffinityObject(j);
                ao.affinity = affinity;
                affinities.put(ao, j);
            }
            startObject = new AffinityObject(startNode);
            startObject.affinity = 0.0;
            internalAffinities.put(startObject, startNode);
            this.buildCluster2(affinities, internalAffinities, already);
            cluster2 = new Vector<Integer>();
            cluster2.addAll(internalAffinities.values());
            clusters.add(cluster2);
            if (this.count == this.listOfElementsSortedByCosts.length) continue;
            i = 0;
        }
        int[] clusters2nodes = new int[this.cc.getNodeNumber()];
        for (int i = 0; i < clusters.size(); ++i) {
            cluster2 = (Vector<Integer>)clusters.get(i);
            for (int j = 0; j < cluster2.size(); ++j) {
                clusters2nodes[((Integer)cluster2.get((int)j)).intValue()] = i;
            }
        }
        this.bestClusters = clusters2nodes;
        int noOfClusters = 0;
        noOfClusters = clusters.size();
        this.cc.initialiseClusterInfo(noOfClusters);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(this.bestClusters));
        this.cc.setClusters(this.bestClusters);
        this.cc.calculateClusterDistribution();
        return this.cc.getClusteringScore();
    }

    private void buildCluster2(TreeMap<AffinityObject, Integer> affinities, TreeMap<AffinityObject, Integer> internalAffinities, boolean[] already) {
        TreeMap aos;
        int id;
        AffinityObject ao;
        boolean change = false;
        if (!affinities.isEmpty()) {
            while (affinities.lastKey().affinity > 0.0) {
                ao = affinities.lastKey();
                id = affinities.pollLastEntry().getValue();
                already[id] = true;
                ++this.count;
                aos = (TreeMap)affinities.clone();
                affinities.clear();
                for (AffinityObject key : aos.keySet()) {
                    key.affinity += (double)this.icce.getEdgeCost(key.id, id);
                    affinities.put(key, key.id);
                }
                aos = (TreeMap)internalAffinities.clone();
                internalAffinities.clear();
                for (AffinityObject key : aos.keySet()) {
                    key.affinity += (double)this.icce.getEdgeCost(key.id, id);
                    internalAffinities.put(key, key.id);
                }
                internalAffinities.put(ao, ao.id);
                change = true;
                if (!affinities.isEmpty()) continue;
                break;
            }
        }
        if (internalAffinities.size() > 1) {
            while (internalAffinities.firstKey().affinity < 0.0) {
                ao = internalAffinities.firstKey();
                id = internalAffinities.pollFirstEntry().getValue();
                already[id] = false;
                --this.count;
                aos = (TreeMap)affinities.clone();
                affinities.clear();
                for (AffinityObject key : aos.keySet()) {
                    key.affinity -= (double)this.icce.getEdgeCost(key.id, id);
                    affinities.put(key, key.id);
                }
                aos = (TreeMap)internalAffinities.clone();
                internalAffinities.clear();
                for (AffinityObject key : aos.keySet()) {
                    key.affinity -= (double)this.icce.getEdgeCost(key.id, id);
                    internalAffinities.put(key, key.id);
                }
                affinities.put(ao, ao.id);
                change = true;
                if (internalAffinities.size() != 1) continue;
                break;
            }
        }
        if (change) {
            this.buildCluster2(affinities, internalAffinities, already);
        }
    }

    private void cluster() {
        this.generateSortedList();
        this.calculateCostsForClusterStartingWithSpecificNode(this.listOfElementsSortedByCosts[0]);
    }

    private void buildCluster(boolean[] already, int startNode, Vector<Vector<Integer>> clusters) {
        Vector<Integer> cluster2 = new Vector<Integer>();
        cluster2.add(startNode);
        already[startNode] = true;
        --this.count;
        this.addNodesToClusterRecursivly(already, cluster2);
        clusters.add(cluster2);
    }

    private double calculateCostsForClusterStartingWithSpecificNode(int node_i) {
        int startNode = this.listOfElementsSortedByCosts[0];
        this.count = this.cc.getNodeNumber();
        Vector<Vector<Integer>> clusters = new Vector<Vector<Integer>>();
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        this.buildCluster(already, startNode, clusters);
        for (int i = 0; i < this.listOfElementsSortedByCosts.length; ++i) {
            startNode = this.listOfElementsSortedByCosts[i];
            if (already[startNode]) continue;
            this.buildCluster(already, startNode, clusters);
        }
        int[] clusters2nodes = new int[this.cc.getNodeNumber()];
        for (int i = 0; i < clusters.size(); ++i) {
            Vector<Integer> cluster2 = clusters.get(i);
            for (int j = 0; j < cluster2.size(); ++j) {
                clusters2nodes[cluster2.get((int)j).intValue()] = i;
            }
        }
        this.bestClusters = clusters2nodes;
        int noOfClusters = 0;
        for (int i = 0; i < this.bestClusters.length; ++i) {
            if (this.bestClusters[i] <= noOfClusters) continue;
            noOfClusters = this.bestClusters[i];
        }
        this.cc.initialiseClusterInfo(++noOfClusters);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(this.bestClusters));
        this.cc.setClusters(this.bestClusters);
        this.cc.calculateClusterDistribution();
        return this.cc.getClusteringScore();
    }

    private void addNodesToClusterRecursivly(boolean[] already, Vector<Integer> cluster2) {
        double minCosts = Double.MAX_VALUE;
        int minNode = -1;
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            double costs;
            if (already[i] || !((costs = this.calculateCostsForAddingNode(cluster2, i)) < minCosts)) continue;
            minCosts = costs;
            minNode = i;
        }
        if (minCosts > 0.0) {
            this.removeWorstRecursively(already, cluster2);
            return;
        }
        --this.count;
        cluster2.add(minNode);
        already[minNode] = true;
        this.addNodesToClusterRecursivly(already, cluster2);
    }

    private void removeWorstRecursively(boolean[] already, Vector<Integer> cluster2) {
        double minCost = Double.POSITIVE_INFINITY;
        int minInt = -1;
        for (int i = 0; i < cluster2.size(); ++i) {
            double costs = this.calculateCostsForRemovingNode(cluster2, cluster2.get(i));
            if (!(costs < minCost)) continue;
            minCost = costs;
            minInt = i;
        }
        if (minCost < 0.0) {
            ++this.count;
            already[cluster2.get((int)minInt).intValue()] = false;
            cluster2.remove(minInt);
            this.changed = true;
            this.removeWorstRecursively(already, cluster2);
            this.changed = false;
        }
        if (this.changed) {
            this.changed = false;
            this.addNodesToClusterRecursivly(already, cluster2);
        }
    }

    private double calculateCostsForRemovingNode(Vector<Integer> cluster2, int j) {
        double costs = 0.0;
        for (int i = 0; i < cluster2.size(); ++i) {
            int node_i = cluster2.get(i);
            if (node_i == j) continue;
            costs += (double)this.icce.getEdgeCost(node_i, j);
        }
        return costs;
    }

    private double calculateCostsForAddingNode(Vector<Integer> clusters, int j) {
        double costs = 0.0;
        for (int i = 0; i < clusters.size(); ++i) {
            int node_i = clusters.get(i);
            costs -= (double)this.icce.getEdgeCost(node_i, j);
        }
        return costs;
    }

    private void generateSortedList() {
        ICCEdges icce = this.cc.getCCEdges();
        double[] costs = new double[this.cc.getNodeNumber()];
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            double cost = 0.0;
            for (int j = 0; j < this.cc.getNodeNumber(); ++j) {
                if (i == j) continue;
                cost += (double)icce.getEdgeCost(i, j);
            }
            costs[i] = cost;
        }
        double[] costsClone = Arrays.copyOf(costs, costs.length);
        Arrays.sort(costs);
        boolean[] already = new boolean[costs.length];
        for (int i = costs.length - 1; i >= 0; --i) {
            int position = 0;
            for (int j = 0; j < costsClone.length; ++j) {
                if (costs[i] != costsClone[j] || already[j]) continue;
                position = j;
                already[j] = true;
                break;
            }
            this.listOfElementsSortedByCosts[costs.length - 1 - i] = position;
        }
    }

    private void generateSortedList(boolean[] already2) {
        ICCEdges icce = this.cc.getCCEdges();
        double[] costs = new double[this.cc.getNodeNumber()];
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            if (already2[i]) {
                costs[i] = Double.POSITIVE_INFINITY;
                continue;
            }
            double cost = 0.0;
            for (int j = 0; j < this.cc.getNodeNumber(); ++j) {
                if (i == j || already2[j]) continue;
                cost += (double)icce.getEdgeCost(i, j);
            }
            costs[i] = cost;
        }
        double[] costsClone = Arrays.copyOf(costs, costs.length);
        Arrays.sort(costs);
        boolean[] already = new boolean[costs.length];
        for (int i = costs.length - 1; i >= 0; --i) {
            int position = 0;
            for (int j = 0; j < costsClone.length; ++j) {
                if (costs[i] != costsClone[j] || already[j]) continue;
                position = j;
                already[j] = true;
                break;
            }
            this.listOfElementsSortedByCosts[costs.length - 1 - i] = position;
        }
    }
}

