/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.start;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ArgsParseException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ArgsUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.Console;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ConsoleFormatter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.UniqueFilter;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransClust {
    private static Logger log = Logger.getLogger(TransClust.class.getName());
    public static String[] args;

    public static void main(String[] args) {
        Handler[] handler;
        TransClust.args = args;
        Logger logger = Logger.getLogger("");
        for (Handler h : handler = logger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            h.setLevel(Level.INFO);
            h.setFormatter(new ConsoleFormatter());
            h.setFilter(new UniqueFilter());
        }
        if (args.length == 0) {
            log.severe("ERROR: Please define at least an input file/directory and an output file for the results. Use -help for more details or see the respective documentation.\n\n");
            System.out.println(ArgsUtility.createUsage().toString());
            System.exit(-1);
        }
        if (args.length == 1 && (args[0].trim().equalsIgnoreCase("-help") || args[0].trim().equalsIgnoreCase("--help"))) {
            System.out.println(ArgsUtility.createUsage().toString());
            System.exit(-1);
        } else {
            try {
                new Console(args);
            }
            catch (InvalidInputFileException e) {
                log.severe("ERROR: An invalid file/path name was given.");
                e.printStackTrace();
                System.exit(-1);
            }
            catch (ArgsParseException e) {
                log.severe(e.getMessage());
                log.severe("ERROR: please see usage details!");
                System.out.println(ArgsUtility.createUsage().toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

