/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering.FixedParameterClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy.GreedyClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.concurrent.Semaphore;

public class ClusterPostProcessingTask
implements Runnable {
    private ConnectedComponent cc = null;
    private Semaphore semaphore = null;
    private IParameters[] allparameters = null;
    private LayoutFactory.EnumLayouterClass[] layouterEnumTypes = null;

    public ClusterPostProcessingTask(ConnectedComponent cc, IParameters[] allparameters, LayoutFactory.EnumLayouterClass[] layouterEnumTypes) {
        this.cc = cc;
        this.allparameters = allparameters;
        this.layouterEnumTypes = layouterEnumTypes;
    }

    public void run() {
        if (this.cc.getReducedConnectedComponent() != null) {
            if (this.cc.getReducedConnectedComponent().getNodeNumber() != 1) {
                this.runClustering(this.cc.getReducedConnectedComponent());
            } else {
                this.cc.initialiseClusterInfo(1);
            }
        } else {
            this.runClustering(this.cc);
        }
        if (this.cc.getReducedConnectedComponent() != null) {
            this.cc.rebuildCC();
        }
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    private void runClustering(ConnectedComponent cc) {
        IPostProcessing pp;
        ConnectedComponent ccCopy = cc.copy(true);
        new GreedyClusterer(ccCopy);
        if (!TaskConfig.fixedParameter || cc.getNodeNumber() >= TaskConfig.fixedParameterMax) {
            TaskConfig.fpStopped = true;
        }
        if (TaskConfig.fixedParameter && cc.getNodeNumber() < TaskConfig.fixedParameterMax) {
            new FixedParameterClusterer(cc, ccCopy.getClusteringScore());
        }
        if (TaskConfig.greedy && TaskConfig.fpStopped) {
            cc.setClusteringScore(Double.MAX_VALUE);
            TaskConfig.fpStopped = false;
        } else if (TaskConfig.fpStopped) {
            TaskConfig.fpStopped = false;
            ILayouter previousLayouter = null;
            for (int i = 0; i < this.layouterEnumTypes.length; ++i) {
                IParameters param = this.allparameters[i];
                ILayouter layouter = this.layouterEnumTypes[i].createLayouter();
                if (previousLayouter == null) {
                    if (TaskConfig.mode == 0 || TaskConfig.mode == 2 || TaskConfig.mode == 3) {
                        ILayoutInitialiser li = this.layouterEnumTypes[i].createLayoutInitialiser();
                        li.initLayoutInitialiser(cc);
                        layouter.initLayouter(cc, li, param);
                        layouter.run();
                        previousLayouter = layouter;
                        continue;
                    }
                    if (TaskConfig.mode != 1) continue;
                    layouter.initLayouter(cc, param);
                    layouter.run();
                    previousLayouter = layouter;
                    continue;
                }
                layouter.initLayouter(cc, previousLayouter, param);
                layouter.run();
            }
            IGeometricClusterer geoClust = TaskConfig.geometricClusteringEnum.createGeometricClusterer();
            geoClust.initGeometricClusterer(cc);
            geoClust.run();
        }
        if (TaskConfig.doPostProcessing && cc.getClusteringScore() != Double.MAX_VALUE) {
            pp = PostProcessingFactory.EnumPostProcessingClass.PP_REARRANGE_AND_MERGE_BEST.createPostProcessor();
            pp.initPostProcessing(cc);
            pp.run();
        }
        if (TaskConfig.doPostProcessing && ccCopy.getClusteringScore() != Double.MAX_VALUE) {
            pp = PostProcessingFactory.EnumPostProcessingClass.PP_REARRANGE_AND_MERGE_BEST.createPostProcessor();
            pp.initPostProcessing(ccCopy);
            pp.run();
        }
        if (ccCopy.getClusteringScore() < cc.getClusteringScore()) {
            cc.initialiseClusterInfo(ccCopy.getNumberOfClusters());
            cc.setClusters(ccCopy.getClusters());
            cc.calculateClusterDistribution();
            cc.setClusteringScore(ccCopy.getClusteringScore());
        }
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

