/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering.FixedParameterClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy.GreedyClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_DivideAndRecluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_DivideAndReclusterRecursively;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManager;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ClusterFile;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.InfoFile;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringTask
implements Runnable {
    private ConnectedComponent cc;
    private Semaphore semaphore = null;
    private Semaphore maxThreadSemaphore = null;
    private ArrayList<Thread> allThreads = null;
    private Thread runningThread = null;
    private long time = -1L;
    private LayoutFactory.EnumLayouterClass[] layouterEnumTypes = null;
    private IParameters[] parameters = null;
    private ClusterFile clusterFile = null;

    public ClusteringTask(ConnectedComponent cc, IParameters[] parameters, LayoutFactory.EnumLayouterClass[] layouterEnumTypes, ClusterFile clusterFile) {
        this.cc = cc;
        this.parameters = parameters;
        this.layouterEnumTypes = layouterEnumTypes;
        this.clusterFile = clusterFile;
    }

    @Override
    public void run() {
        if (this.allThreads != null) {
            this.allThreads.add(this.runningThread);
        }
        if (this.cc.getReducedConnectedComponent() != null) {
            if (this.cc.getReducedConnectedComponent().getNodeNumber() != 1) {
                this.runClustering(this.cc.getReducedConnectedComponent());
            } else {
                this.cc.initialiseClusterInfo(1);
            }
        } else {
            this.runClustering(this.cc);
        }
        if (this.cc.getReducedConnectedComponent() != null) {
            this.cc.rebuildCC();
        }
        double score = this.cc.getClusteringScore();
        ClusteringManager.addClusteringScoreToSum(score += this.cc.getReductionCost());
        if (TaskConfig.mode == 0) {
            int i;
            String ccPath = this.cc.getCcPath();
            int ccSize = this.cc.getNodeNumber();
            int[] distribution = this.cc.getClusterInfo();
            int clusterNo = this.cc.getNumberOfClusters();
            String delimiter = "\t";
            StringBuffer resultForCCBuffer = new StringBuffer(distribution.length * 4);
            resultForCCBuffer.append(ccPath);
            resultForCCBuffer.append(delimiter);
            resultForCCBuffer.append("size=");
            resultForCCBuffer.append(ccSize);
            resultForCCBuffer.append(delimiter);
            resultForCCBuffer.append("score=");
            resultForCCBuffer.append(TaskUtility.round(score, 3));
            resultForCCBuffer.append(delimiter);
            resultForCCBuffer.append("clusters=");
            resultForCCBuffer.append(clusterNo);
            resultForCCBuffer.append(delimiter);
            for (int i2 = 0; i2 < distribution.length; ++i2) {
                resultForCCBuffer.append(distribution[i2]);
                resultForCCBuffer.append(" ");
            }
            resultForCCBuffer.append(delimiter);
            resultForCCBuffer.append("time=");
            this.time = System.currentTimeMillis() - this.time;
            resultForCCBuffer.append(TaskUtility.convertTime(this.time));
            resultForCCBuffer.append(delimiter);
            resultForCCBuffer.append("time-ms=");
            resultForCCBuffer.append(this.time);
            TaskConfig.monitor.setStatusMessage(resultForCCBuffer.toString());
            InfoFile.appendLnProjectResults(resultForCCBuffer.toString());
            ArrayList clustersWithIDs = new ArrayList(this.cc.getNumberOfClusters());
            for (i = 0; i < this.cc.getNumberOfClusters(); ++i) {
                clustersWithIDs.add(new ArrayList());
            }
            for (i = 0; i < this.cc.getNodeNumber(); ++i) {
                int n = this.cc.getClusterNoForObject(i);
                String objectID = this.cc.getObjectID(i);
                ((ArrayList)clustersWithIDs.get(n)).add(objectID);
            }
            for (ArrayList arrayList : clustersWithIDs) {
                this.clusterFile.printCluster(arrayList);
            }
            this.clusterFile.flushbw();
        }
        if (this.semaphore != null) {
            this.semaphore.release();
        }
        if (this.maxThreadSemaphore != null) {
            this.maxThreadSemaphore.release();
            this.allThreads.remove(this.runningThread);
        }
    }

    private void runClustering(ConnectedComponent cc) {
        IPostProcessing pp;
        PostProcessingFactory.EnumPostProcessingClass ppEnum;
        ConnectedComponent ccCopy = cc.copy(true);
        new GreedyClusterer(ccCopy);
        if (!TaskConfig.fixedParameter || cc.getNodeNumber() >= TaskConfig.fixedParameterMax) {
            TaskConfig.fpStopped = true;
        }
        if (TaskConfig.fixedParameter && cc.getNodeNumber() < TaskConfig.fixedParameterMax) {
            new FixedParameterClusterer(cc, ccCopy.getClusteringScore());
        }
        if (TaskConfig.greedy && TaskConfig.fpStopped) {
            cc.setClusteringScore(Double.MAX_VALUE);
            TaskConfig.fpStopped = false;
        } else if (TaskConfig.fpStopped) {
            TaskConfig.fpStopped = false;
            ILayouter previousLayouter = null;
            for (int i = 0; i < this.layouterEnumTypes.length; ++i) {
                IParameters param = this.parameters[i];
                ILayouter layouter = this.layouterEnumTypes[i].createLayouter();
                if (previousLayouter == null) {
                    ILayoutInitialiser li;
                    if (TaskConfig.mode == 0 || TaskConfig.mode == 2 || TaskConfig.mode == 3) {
                        li = this.layouterEnumTypes[i].createLayoutInitialiser();
                        li.initLayoutInitialiser(cc);
                        layouter.initLayouter(cc, li, param);
                        layouter.run();
                        previousLayouter = layouter;
                        continue;
                    }
                    if (TaskConfig.mode != 1) continue;
                    li = this.layouterEnumTypes[i].createLayoutInitialiser();
                    li.initLayoutInitialiser(cc);
                    layouter.initLayouter(cc, li, param);
                    layouter.run();
                    previousLayouter = layouter;
                    continue;
                }
                layouter.initLayouter(cc, previousLayouter, param);
                layouter.run();
            }
            IGeometricClusterer geoClust = TaskConfig.geometricClusteringEnum.createGeometricClusterer();
            geoClust.initGeometricClusterer(cc);
            geoClust.run();
        }
        if (TaskConfig.doPostProcessing && cc.getClusteringScore() != Double.MAX_VALUE) {
            ppEnum = TaskConfig.postProcessingEnum;
            pp = ppEnum.createPostProcessor();
            pp.initPostProcessing(cc);
            if (ppEnum.equals((Object)PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER)) {
                ((PP_DivideAndRecluster)pp).setLayoutingInfo(this.parameters, this.layouterEnumTypes);
            } else if (ppEnum.equals((Object)PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER_RECURSIVELY)) {
                ((PP_DivideAndReclusterRecursively)pp).setLayoutingInfo(this.parameters, this.layouterEnumTypes);
            }
            pp.run();
        }
        if (TaskConfig.doPostProcessing && ccCopy.getClusteringScore() != Double.MAX_VALUE) {
            ppEnum = TaskConfig.postProcessingEnum;
            pp = ppEnum.createPostProcessor();
            pp.initPostProcessing(ccCopy);
            if (ppEnum.equals((Object)PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER)) {
                ((PP_DivideAndRecluster)pp).setLayoutingInfo(this.parameters, this.layouterEnumTypes);
            } else if (ppEnum.equals((Object)PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER_RECURSIVELY)) {
                ((PP_DivideAndReclusterRecursively)pp).setLayoutingInfo(this.parameters, this.layouterEnumTypes);
            }
            pp.run();
        }
        if (ccCopy.getClusteringScore() < cc.getClusteringScore()) {
            cc.initialiseClusterInfo(ccCopy.getNumberOfClusters());
            cc.setClusters(ccCopy.getClusters());
            cc.calculateClusterDistribution();
            cc.setClusteringScore(ccCopy.getClusteringScore());
        }
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setMaxThreadSemaphore(Semaphore semaphore, ArrayList<Thread> allThreads, Thread t) {
        this.maxThreadSemaphore = semaphore;
        this.allThreads = allThreads;
        this.runningThread = t;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTime(long time) {
        this.time = time;
    }
}

