/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CostMatrixReader;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManager;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.IParametersArrayComparator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralParameterTraining {
    private ClusteringManager clusteringManager;
    private int generationSize = TaskConfig.noOfParameterConfigurationsPerGeneration;
    private int noOfGenerations = TaskConfig.noOfGenerations;
    private IParametersArrayComparator paramComparator = null;
    private IParameters[] bestPreviousIParameters = null;
    private Vector<IParameters[]> bestConfigs = null;

    public GeneralParameterTraining(ClusteringManager clusteringManager) {
        this.clusteringManager = clusteringManager;
        this.paramComparator = new IParametersArrayComparator();
        this.bestConfigs = new Vector();
    }

    public IParameters[] runGeneralTraining() throws InvalidInputFileException, InvalidTypeException {
        int i;
        this.clusteringManager.initParametersAndCCs();
        ArrayList<File> connectedComponents = this.clusteringManager.getConnectedComponents();
        for (File cc : connectedComponents) {
            ILayoutInitialiser li = TaskConfig.layouterEnumTypes[0].createLayoutInitialiser();
            li.initLayoutInitialiser(new CostMatrixReader(cc).getConnectedComponent());
            li.run();
        }
        boolean terminateTraining = false;
        IParameters[][] initialGeneration = this.createInitialParameterGeneration();
        this.runOneGeneration(initialGeneration, connectedComponents, 0);
        terminateTraining = this.terminateTraining(initialGeneration);
        for (int i2 = 0; i2 < initialGeneration.length; ++i2) {
            this.bestConfigs.add(initialGeneration[i2]);
        }
        for (int i3 = 1; i3 <= this.noOfGenerations && !terminateTraining; ++i3) {
            IParameters[][] generation = this.createParameterGeneration();
            this.runOneGeneration(generation, connectedComponents, i3);
            terminateTraining = this.terminateTraining(generation);
            for (int j = 0; j < this.generationSize / 2; ++j) {
                this.bestConfigs.add(initialGeneration[j]);
            }
        }
        IParameters[][] bestConfigsArray = new IParameters[this.bestConfigs.size()][TaskConfig.layouterEnumTypes.length];
        for (i = 0; i < this.bestConfigs.size(); ++i) {
            bestConfigsArray[i] = this.bestConfigs.get(i);
        }
        Arrays.sort(bestConfigsArray, this.paramComparator);
        this.bestPreviousIParameters = bestConfigsArray[0];
        for (i = 0; i < bestConfigsArray[0].length; ++i) {
            bestConfigsArray[0][i].saveParametersToConfig();
        }
        for (i = 0; i < 30; ++i) {
            FORCEnDParameters ip = (FORCEnDParameters)bestConfigsArray[i][0];
            ip.printParamters();
        }
        return bestConfigsArray[0];
    }

    private IParameters[][] createParameterGeneration() {
        int k;
        IParameters[] bestConfigsArray;
        int j;
        int i;
        IParameters[][] paramsGen = new IParameters[this.generationSize][TaskConfig.layouterEnumTypes.length];
        IParameters param = null;
        for (int i2 = 0; i2 < TaskConfig.layouterEnumTypes.length; ++i2) {
            IParameters[] bestConfigsArray2 = new IParameters[this.bestConfigs.size()];
            for (int j2 = 0; j2 < this.bestConfigs.size(); ++j2) {
                bestConfigsArray2[j2] = this.bestConfigs.get(j2)[i2];
            }
            param = TaskConfig.layouterEnumTypes[i2].createIParameters();
            param.combineConfigurationsRandomly(bestConfigsArray2);
            paramsGen[0][i2] = param;
        }
        int currentPosition = 0;
        int third = (this.generationSize - 1) / 3;
        for (i = currentPosition; i < currentPosition + third; ++i) {
            for (j = 0; j < TaskConfig.layouterEnumTypes.length; ++j) {
                bestConfigsArray = new IParameters[this.bestConfigs.size()];
                for (k = 0; k < this.bestConfigs.size(); ++k) {
                    bestConfigsArray[k] = this.bestConfigs.get(k)[j];
                }
                param = TaskConfig.layouterEnumTypes[j].createIParameters();
                param.combineConfigurationsRandomly(bestConfigsArray);
                paramsGen[i][j] = param;
            }
        }
        for (i = currentPosition += third; i < currentPosition + third; ++i) {
            for (j = 0; j < TaskConfig.layouterEnumTypes.length; ++j) {
                bestConfigsArray = new IParameters[this.bestConfigs.size()];
                for (k = 0; k < this.bestConfigs.size(); ++k) {
                    bestConfigsArray[k] = this.bestConfigs.get(k)[j];
                }
                param = TaskConfig.layouterEnumTypes[j].createIParameters();
                param.combineParametersRandomlyAndGetNewRandom(bestConfigsArray);
                paramsGen[i][j] = param;
            }
        }
        for (i = currentPosition += third; i < this.generationSize; ++i) {
            paramsGen[i] = this.createRandomParametersForLayouters();
        }
        return paramsGen;
    }

    private boolean terminateTraining(IParameters[][] parameters) {
        boolean terminate = true;
        Arrays.sort(parameters, this.paramComparator);
        double bestScore = parameters[0][0].getScore();
        if (bestScore == 0.0 || parameters.length < 10) {
            terminate = false;
        } else {
            for (int i = 1; i < parameters.length - 2; ++i) {
                if (!(parameters[i][0].getScore() > bestScore)) continue;
                terminate = false;
            }
        }
        return terminate;
    }

    private void runOneGeneration(IParameters[][] parameters, ArrayList<File> connectedComponents, int gen) throws InvalidInputFileException, InvalidTypeException {
        TaskConfig.monitor.setStatusMessage("Start training generation: " + gen);
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            ArrayList newConnectedComponents = new ArrayList(connectedComponents.size());
            this.clusteringManager.setConnectedComponents(connectedComponents);
            this.clusteringManager.setLayouterParameters(parameters[i]);
            this.clusteringManager.runClustering();
            FORCEnDParameters fndparam = (FORCEnDParameters)parameters[i][0];
            fndparam.printParamters();
            newConnectedComponents.clear();
        }
    }

    private IParameters[][] createInitialParameterGeneration() {
        ArrayList<FORCEnDParameters> parameters = new ArrayList<FORCEnDParameters>();
        for (double attraction = 1.0; attraction <= 100.0; attraction += 5.0) {
            for (float temperature = 100.0f; temperature <= 1000.0f; temperature += 100.0f) {
                for (int iterations = 50; iterations < 500; iterations += 50) {
                    FORCEnDParameters fndparam = new FORCEnDParameters();
                    fndparam.setAttractionFactor(attraction);
                    fndparam.setRepulsionFactor(attraction);
                    fndparam.setTemperature(temperature);
                    fndparam.setIterations(iterations);
                    parameters.add(fndparam);
                }
            }
        }
        IParameters[][] paramsGen = new IParameters[parameters.size()][TaskConfig.layouterEnumTypes.length];
        for (int i = 0; i < paramsGen.length; ++i) {
            paramsGen[i][0] = (IParameters)parameters.get(i);
        }
        return paramsGen;
    }

    private IParameters[] createRandomParametersForLayouters() {
        IParameters[] params = new IParameters[TaskConfig.layouterEnumTypes.length];
        for (int i = 0; i < TaskConfig.layouterEnumTypes.length; ++i) {
            params[i] = TaskConfig.layouterEnumTypes[i].createIParameters();
            params[i].createRandomConfiguration();
        }
        return params;
    }
}

