/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Config;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayoutConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.ParameterTrainingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManagerTask;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ArgsParseException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.cytoscape.work.TaskMonitor;

public class Console {
    private String[] args = null;

    public Console(String[] args) throws InvalidInputFileException, ArgsParseException, IOException {
        this.args = args;
        this.parseArgsAndInitProgram();
    }

    private void parseArgsAndInitProgram() throws InvalidInputFileException, ArgsParseException, IOException {
        boolean inputAndOutputGiven = this.findAndReadConfigIfGivenAndSetMode();
        this.initGivenParameters();
        if (!TaskConfig.gui) {
            if (inputAndOutputGiven && !TaskConfig.gui) {
                ClusteringManagerTask manageTask = new ClusteringManagerTask();
                manageTask.run();
            } else {
                throw new ArgsParseException("Either input file/directory (-i) or output file (-o) is missing!");
            }
        }
    }

    private void initGivenParameters() throws ArgsParseException, IOException {
        int i = 0;
        String key = null;
        String value = null;
        while (i < this.args.length) {
            key = this.args[i].trim();
            if (key.equals("-gui")) {
                value = "true";
                this.setParameter(key, value);
                ++i;
                continue;
            }
            if (key.equals("-verbose")) {
                value = "true";
                this.setParameter(key, value);
                ++i;
                continue;
            }
            try {
                value = this.args[i + 1].trim();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ArgsParseException("One of the keys does not have a value!");
            }
            if (!key.startsWith("-")) {
                throw new ArgsParseException("ERROR: This key does not begin with a '-', or the input is in the wrong format! Key=" + key);
            }
            if (value.startsWith("-")) {
                throw new ArgsParseException("ERROR: This value starts with a '-', which indicates that it is a key. Please look at your input again!");
            }
            this.setParameter(key, value);
            i += 2;
        }
    }

    private void setParameter(String key, String value) throws ArgsParseException {
        block51: {
            try {
                if (key.equals("-i")) {
                    TaskConfig.cmPath = value;
                    break block51;
                }
                if (key.equals("-o")) {
                    if (TaskConfig.mode == 1) {
                        TaskConfig.outConfigPath = value;
                    } else {
                        TaskConfig.clustersPath = value;
                    }
                    break block51;
                }
                if (key.equals("-cf")) {
                    TaskConfig.useConfigFile = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-log")) {
                    TaskConfig.setLogLevel = true;
                    break block51;
                }
                if (key.equals("-verbose")) {
                    TaskConfig.verbose = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-info")) {
                    TaskConfig.info = true;
                    TaskConfig.infoPath = value.endsWith(".info") ? value : value + ".info";
                    break block51;
                }
                if (key.equals("-gui")) {
                    TaskConfig.gui = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-l")) {
                    TaskConfig.layouterClasses = value;
                    TaskConfig.layouterEnumTypes = LayoutFactory.getEnumArrayFromLayoutersString();
                    break block51;
                }
                if (key.equals("-g")) {
                    TaskConfig.geometricClusteringClass = value;
                    TaskConfig.geometricClusteringEnum = GeometricClusteringFactory.getClustererEnumByClass(value);
                    break block51;
                }
                if (key.equals("-p")) {
                    if (value.equals("none")) {
                        TaskConfig.doPostProcessing = false;
                    } else {
                        TaskConfig.postProcessingClass = value;
                        TaskConfig.doPostProcessing = true;
                        TaskConfig.postProcessingEnum = PostProcessingFactory.getPostProcessorEnumByClass(value);
                    }
                    break block51;
                }
                if (key.equals("-e")) {
                    TaskConfig.ccEdgesClass = value;
                    TaskConfig.ccEdgesEnum = LayoutFactory.getCCEdgesEnumByClass(value);
                    break block51;
                }
                if (key.equals("-t")) {
                    TaskConfig.useThreads = true;
                    int givenMax = Integer.parseInt(value);
                    if (givenMax > TaskConfig.SYSTEM_NO_AVAILABLE_PROCESSORS) {
                        givenMax = TaskConfig.SYSTEM_NO_AVAILABLE_PROCESSORS;
                    }
                    TaskConfig.maxNoThreads = givenMax;
                    break block51;
                }
                if (key.equals("-ld")) {
                    int dim = Integer.parseInt(value);
                    if (dim < 2) {
                        throw new ArgsParseException("The dimension given is too small: " + value);
                    }
                    if (dim > 3) {
                        TaskConfig.monitor.showMessage(TaskMonitor.Level.WARN, "If using the ACCLayouter, then any dimension greater than 3 is very time expensive. Recommended are dimensions 2 or 3.");
                    }
                    TaskConfig.dimension = dim;
                    break block51;
                }
                if (key.equals("-lp")) {
                    if (value.equals("none")) {
                        TaskConfig.doLayoutParameterTraining = false;
                    } else {
                        TaskConfig.parameterTrainingClass = value;
                        TaskConfig.doLayoutParameterTraining = true;
                        TaskConfig.parameterTrainingEnum = ParameterTrainingFactory.getParameterTrainingEnumByClass(value);
                    }
                    break block51;
                }
                if (key.equals("-lps")) {
                    int no = Integer.parseInt(value);
                    if (no < 2) {
                        throw new ArgsParseException("The number of parameter configurations per generation need to be at least two! Number given=" + value);
                    }
                    TaskConfig.noOfParameterConfigurationsPerGeneration = no;
                    break block51;
                }
                if (key.equals("-lpn")) {
                    int no = Integer.parseInt(value);
                    if (no < 1) {
                        throw new ArgsParseException("The number of generations for the layout parameter training is too small! Number given=" + value);
                    }
                    TaskConfig.noOfGenerations = no;
                    break block51;
                }
                if (key.equals("-fa")) {
                    FORCEnDLayoutConfig.attractionFactor = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-fr")) {
                    FORCEnDLayoutConfig.repulsionFactor = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-fi")) {
                    FORCEnDLayoutConfig.iterations = Integer.parseInt(value);
                    break block51;
                }
                if (key.equals("-ft")) {
                    FORCEnDLayoutConfig.temperature = Float.parseFloat(value);
                    break block51;
                }
                if (key.equals("-sm")) {
                    GeometricClusteringConfig.minDistance = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-sx")) {
                    GeometricClusteringConfig.maxDistance = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-ss")) {
                    GeometricClusteringConfig.stepsize = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-sf")) {
                    GeometricClusteringConfig.stepsizeFactor = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-km")) {
                    GeometricClusteringConfig.kLimit = Integer.parseInt(value);
                    break block51;
                }
                if (key.equals("-ki")) {
                    GeometricClusteringConfig.maxInitStartConfigs = Integer.parseInt(value);
                    break block51;
                }
                if (key.equals("-mode")) {
                    TaskConfig.mode = Integer.parseInt(value);
                    break block51;
                }
                if (key.equals("-sim")) {
                    Config.similarityFile = value;
                    break block51;
                }
                if (key.equals("-gs")) {
                    TaskConfig.goldstandardPath = value;
                    break block51;
                }
                if (key.equals("-greedy")) {
                    TaskConfig.greedy = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-ub")) {
                    TaskConfig.upperBound = Float.parseFloat(value);
                    break block51;
                }
                if (key.equals("-minT")) {
                    TaskConfig.minThreshold = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-maxT")) {
                    TaskConfig.maxThreshold = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-tss")) {
                    TaskConfig.thresholdStepSize = Double.parseDouble(value);
                    break block51;
                }
                if (key.equals("-chc")) {
                    TaskConfig.clusterHierarchicalComplete = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-fp")) {
                    TaskConfig.fixedParameter = Boolean.parseBoolean(value);
                    break block51;
                }
                if (key.equals("-fpt")) {
                    TaskConfig.fpMaxTimeMillis = (long)Math.rint(Double.parseDouble(value) * 1000.0);
                    break block51;
                }
                if (key.equals("-fps")) {
                    TaskConfig.fixedParameterMax = Integer.parseInt(value);
                    break block51;
                }
                throw new ArgsParseException("This key does not exist: " + key);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ArgsParseException("The value is of the wrong type: " + value);
            }
        }
    }

    private boolean findAndReadConfigIfGivenAndSetMode() throws InvalidInputFileException, ArgsParseException {
        boolean input = false;
        boolean output = false;
        String configPath = "Default.conf";
        for (int i = 0; i < this.args.length; ++i) {
            String value;
            if (this.args[i].trim().equals("-i")) {
                input = true;
                ++i;
            }
            if (this.args[i].trim().equals("-o")) {
                output = true;
                ++i;
            }
            if (this.args[i].trim().equals("-mode")) {
                block17: {
                    value = this.args[i + 1].trim();
                    try {
                        int md = Integer.parseInt(value);
                        if (md == 1) {
                            TaskConfig.mode = 1;
                            break block17;
                        }
                        if (md == 0) {
                            TaskConfig.mode = 0;
                            break block17;
                        }
                        if (md == 2) {
                            TaskConfig.mode = 2;
                            break block17;
                        }
                        if (md == 3) {
                            TaskConfig.mode = 3;
                            break block17;
                        }
                        throw new ArgsParseException("The given mode is incorrect - it does not exist! " + md);
                    }
                    catch (Exception e) {
                        throw new ArgsParseException("The given mode is not an interger value: " + value);
                    }
                }
                ++i;
            }
            if (this.args[i].trim().equals("-config")) {
                value = this.args[i + 1].trim();
                if (!value.endsWith(".conf")) {
                    throw new InvalidInputFileException("An invalid config file was entered. The file must end with '.conf'. Please try again! Given file=" + value);
                }
                TaskConfig.useConfigFile = true;
                TaskConfig.inputConfigPath = value;
                configPath = value;
                ++i;
            }
            if (!this.args[i].trim().equals("-cf")) continue;
            TaskConfig.useConfigFile = Boolean.parseBoolean(this.args[i + 1].trim());
            ++i;
        }
        if (TaskConfig.useConfigFile) {
            try {
                FileInputStream s = new FileInputStream(configPath);
                PropertyResourceBundle configrb = new PropertyResourceBundle(s);
                TaskConfig.initFromConfigFile(configrb);
                FORCEnDLayoutConfig.initFromConfigFile(configrb);
                GeometricClusteringConfig.initSLCFromConfigFile(configrb);
                GeometricClusteringConfig.initKmeansFromConfigFile(configrb);
            }
            catch (MissingResourceException ex) {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, "WARNING: Resources are missing in the given config file: Default.conf, key=" + ex.getKey() + ". Either you have defined these parameters in the input, or the default values are used from the " + "Default.conf" + ". Or these parameters do not interest you, because they belong to an unused implemtation.");
            }
            catch (IOException ex) {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, "ERROR: Unable to read the given config file: " + configPath);
                System.exit(-1);
            }
            catch (InvalidTypeException ex) {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, "ERROR: You have perhaps given an incorrect class name of an implemtation. Please note that this is case sensitive.");
                System.exit(-1);
            }
        }
        return input && output;
    }
}

