/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import java.io.File;
import javax.swing.JOptionPane;

public class FileSet {
    private ConfigNode node = null;
    public static final int AUTO_STYLE = 0;
    public static final int CLASSIC_STYLE = 1;
    public static final int KMEANS_STYLE = 2;
    public static final int LINKED_STYLE = 3;
    private static final String validStyles = "auto|classic|kmeans|linked";
    public static final int PARSE_QUOTED = 1;

    public boolean isUrl() {
        return this.getDir().startsWith("http");
    }

    public boolean hasMoved() {
        if (this.isUrl()) {
            return false;
        }
        try {
            File f = new File(this.getCdt());
            return !f.exists();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public FileSet(ConfigNode configNode) {
        this.node = configNode;
    }

    public FileSet(String cdt, String dir) {
        this.node = new DummyConfigNode("FileSet");
        this.setCdt(cdt);
        this.setDir(dir);
    }

    public ConfigNode getConfigNode() {
        return this.node;
    }

    public void copyState(FileSet fileSet) {
        this.setRoot(fileSet.getRoot());
        this.setDir(fileSet.getDir());
        this.setExt(fileSet.getExt());
        this.setName(fileSet.getName());
        this.setStyle(fileSet.getStyle());
    }

    public String toString() {
        return this.getCdt();
    }

    public boolean equals(FileSet fileSet) {
        return this.getCdt().equals(fileSet.getCdt());
    }

    public String getAtr() {
        return this.getDir() + this.getRoot() + this.node.getAttribute("atr", ".atr");
    }

    public String getCdt() {
        return this.getDir() + this.getRoot() + this.getExt();
    }

    public String getDir() {
        return this.node.getAttribute("dir", "");
    }

    public String getGtr() {
        return this.getDir() + this.getRoot() + this.node.getAttribute("gtr", ".gtr");
    }

    public String getJtv() {
        return this.getDir() + this.getRoot() + this.node.getAttribute("jtv", ".jtv");
    }

    public String getRoot() {
        return this.node.getAttribute("root", "");
    }

    public String getExt() {
        return this.node.getAttribute("cdt", ".cdt");
    }

    public String getName() {
        return this.node.getAttribute("name", "No name");
    }

    public void setCdt(String string1) {
        if (string1 != null) {
            this.setRoot(string1.substring(0, string1.length() - 4));
            this.setExt(string1.substring(string1.length() - 4, string1.length()));
        }
    }

    public void setRoot(String string) {
        this.node.setAttribute("root", string, "");
    }

    public void setDir(String string) {
        this.node.setAttribute("dir", string, "");
    }

    public void setExt(String string) {
        this.node.setAttribute("cdt", string, ".cdt");
    }

    public void setName(String string) {
        this.node.setAttribute("name", string, "No name");
    }

    public String getKgg() {
        int postfix;
        String filename = this.getRoot();
        if (filename.indexOf("_G", postfix = filename.lastIndexOf("_K")) == -1) {
            return "";
        }
        int arrayid = filename.indexOf("_A", postfix);
        if (arrayid != -1) {
            filename = filename.substring(0, arrayid);
        }
        return this.getDir() + filename + this.node.getAttribute("kgg", ".kgg");
    }

    public String getKag() {
        String filename = this.getRoot();
        int postfix = filename.lastIndexOf("_K");
        int arrayid = filename.indexOf("_A");
        if (arrayid == -1) {
            return "";
        }
        int geneid = filename.indexOf("_G", postfix);
        if (geneid != -1) {
            filename = filename.substring(0, geneid) + filename.substring(arrayid);
        }
        return this.getDir() + filename + this.node.getAttribute("kag", ".kag");
    }

    public static String getStyleByIndex(int i) {
        switch (i) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "classic";
            }
            case 2: {
                return "kmeans";
            }
            case 3: {
                return "linked";
            }
        }
        return null;
    }

    public static int getStyleByName(String name) {
        if (name.equalsIgnoreCase("auto")) {
            return 0;
        }
        if (name.equalsIgnoreCase("classic")) {
            return 1;
        }
        if (name.equalsIgnoreCase("kmeans")) {
            return 2;
        }
        if (name.equalsIgnoreCase("linked")) {
            return 3;
        }
        JOptionPane.showMessageDialog(null, "Error: Invalid Style " + name + ". Valid styles " + validStyles);
        return -1;
    }

    public int getStyle() {
        return this.node.getAttribute("style", 0);
    }

    public void setStyle(int newStyle) {
        this.node.setAttribute("style", newStyle, 0);
    }

    public void setStyle(String newStyle) {
        if (newStyle == null) {
            JOptionPane.showMessageDialog(null, "Error: Invalid Style null. Valid styles auto|classic|kmeans|linked");
        } else {
            int style = FileSet.getStyleByName(newStyle);
            if (style != -1) {
                this.setStyle(style);
            }
        }
    }

    public void setParseQuotedStrings(boolean parseQuote) {
        if (parseQuote) {
            this.node.setAttribute("quotes", 1, 1);
        } else {
            this.node.setAttribute("quotes", 0, 1);
        }
    }

    public boolean getParseQuotedStrings() {
        return this.node.getAttribute("quotes", 1) == 1;
    }
}

