/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.cytoscape.property.CyProperty;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConfig {
    static int depth = 0;
    private CyProperty<Properties> cyProps = null;
    private PropertyConfigNode root = null;
    private String prefix = null;
    private boolean changed = false;

    public PropertyConfig(CyProperty<Properties> cyProps, String prefix, String tag) {
        this.prefix = prefix;
        this.cyProps = cyProps;
        Properties props = (Properties)cyProps.getProperties();
        String xml = props.getProperty(prefix + "." + tag);
        this.root = this.xmlParse(xml, tag);
        if (this.root == null) {
            this.root = new PropertyConfigNode(tag);
        }
    }

    public ConfigNode getNode(String name) {
        ConfigNode t = this.root.fetchFirst(name);
        if (t != null) {
            return t;
        }
        return this.root.create(name);
    }

    public ConfigNode getRoot() {
        return this.root;
    }

    public void store() {
        Properties props = (Properties)this.cyProps.getProperties();
        String config = this.getProperty(this.root);
        props.setProperty(this.prefix + "." + this.root.getName(), config);
    }

    public String toString() {
        return "PropertyConfig object based on prefix " + this.prefix + "\n";
    }

    private String getProperty(PropertyConfigNode node) {
        String element = node.getStartElement();
        for (String key : node.getChildKeys()) {
            for (PropertyConfigNode child : node.getChildren(key)) {
                element = element + this.getProperty(child);
            }
        }
        element = element + node.getEndElement();
        return element;
    }

    private PropertyConfigNode xmlParse(String xml, String docTag) {
        if (xml == null) {
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader is = new StringReader(xml);
            doc = db.parse(new InputSource(is));
            doc.getDocumentElement().normalize();
            if (doc.getDocumentElement().getNodeName() != docTag) {
                return null;
            }
            depth = 0;
        }
        catch (Exception e) {
            return null;
        }
        return this.createConfigFromXML(doc.getDocumentElement());
    }

    private PropertyConfigNode createConfigFromXML(Element node) {
        PropertyConfigNode newConfigNode = new PropertyConfigNode(node.getTagName());
        NamedNodeMap attrs = node.getAttributes();
        ++depth;
        for (int attrIndex = 0; attrIndex < attrs.getLength(); ++attrIndex) {
            Attr attrNode = (Attr)attrs.item(attrIndex);
            String value = attrNode.getValue().replace("&amp;", "&");
            newConfigNode.setAttribute(attrNode.getName(), value, null);
        }
        NodeList children = node.getChildNodes();
        int nChildren = children.getLength();
        for (int childIndex = 0; childIndex < nChildren; ++childIndex) {
            Element child = (Element)children.item(childIndex);
            newConfigNode.add(this.createConfigFromXML(child));
        }
        --depth;
        return newConfigNode;
    }

    private String indent() {
        String dStr = "";
        for (int i = 0; i < depth; ++i) {
            dStr = dStr + "\t";
        }
        return dStr;
    }

    public static WindowListener getStoreOnWindowClose(final ConfigNode node) {
        return new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                node.store();
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyConfigNode
    implements ConfigNode {
        protected HashMap<String, List<PropertyConfigNode>> children = new HashMap();
        protected String name;
        protected HashMap<String, Object> attributes = new HashMap();

        public PropertyConfigNode(String name) {
            this.name = name;
        }

        @Override
        public void store() {
            PropertyConfig.this.store();
        }

        @Override
        public ConfigNode create(String name) {
            PropertyConfigNode kid = new PropertyConfigNode(name);
            List<PropertyConfigNode> list = this.children.containsKey(name) ? this.children.get(name) : new ArrayList<PropertyConfigNode>();
            list.add(kid);
            this.children.put(name, list);
            return kid;
        }

        @Override
        public ConfigNode[] fetch(String name) {
            ConfigNode[] ret = new ConfigNode[]{};
            if (this.children.containsKey(name)) {
                List<PropertyConfigNode> list = this.children.get(name);
                ret = list.toArray(ret);
            }
            return ret;
        }

        @Override
        public ConfigNode fetchFirst(String string) {
            if (this.children.containsKey(string)) {
                List<PropertyConfigNode> list = this.children.get(string);
                return list.get(0);
            }
            return null;
        }

        @Override
        public ConfigNode fetchOrCreate(String string) {
            ConfigNode t = this.fetchFirst(string);
            if (t != null) {
                return t;
            }
            return this.create(string);
        }

        public boolean equals(Object cn) {
            return ((PropertyConfigNode)cn).name == this.name;
        }

        @Override
        public void remove(ConfigNode configNode) {
            String childName = ((PropertyConfigNode)configNode).getName();
            if (!this.children.containsKey(childName)) {
                return;
            }
            List<PropertyConfigNode> childList = this.children.get(childName);
            childList.remove((PropertyConfigNode)configNode);
            this.children.put(childName, childList);
            PropertyConfig.this.changed = true;
        }

        @Override
        public void removeAll(String string) {
            ConfigNode[] ret = this.fetch(string);
            for (int i = 0; i < ret.length; ++i) {
                this.remove(ret[i]);
            }
        }

        @Override
        public void setLast(ConfigNode configNode) {
            String childName = ((PropertyConfigNode)configNode).getName();
            List<PropertyConfigNode> childList = this.getChildren(childName);
            childList.remove((PropertyConfigNode)configNode);
            childList.add((PropertyConfigNode)configNode);
            this.children.put(childName, childList);
            PropertyConfig.this.changed = true;
        }

        public void add(ConfigNode configNode) {
            String childName = ((PropertyConfigNode)configNode).getName();
            List<PropertyConfigNode> childList = this.getChildren(childName);
            childList.add((PropertyConfigNode)configNode);
            this.children.put(childName, childList);
            PropertyConfig.this.changed = true;
        }

        @Override
        public boolean hasAttribute(String string) {
            return this.attributes.containsKey(string);
        }

        @Override
        public double getAttribute(String string, double d) {
            if (!this.attributes.containsKey(string)) {
                return d;
            }
            double val = 0.0;
            Object attr = this.attributes.get(string);
            if (attr.getClass() == Integer.class) {
                val = ((Integer)attr).doubleValue();
            } else if (attr.getClass() == Double.class) {
                val = (Double)attr;
            } else if (attr.getClass() == String.class) {
                val = Double.parseDouble((String)attr);
            }
            return val;
        }

        @Override
        public int getAttribute(String string, int i) {
            if (!this.attributes.containsKey(string)) {
                return i;
            }
            int val = 0;
            Object attr = this.attributes.get(string);
            if (attr.getClass() == Integer.class) {
                val = (Integer)attr;
            } else if (attr.getClass() == Double.class) {
                val = ((Double)attr).intValue();
            } else if (attr.getClass() == String.class) {
                val = Integer.parseInt((String)attr);
            }
            return val;
        }

        @Override
        public String getAttribute(String string, String dval) {
            if (!this.attributes.containsKey(string)) {
                return dval;
            }
            String val = (String)this.attributes.get(string);
            return val;
        }

        @Override
        public void setAttribute(String att, double val, double dval) {
            double cur = this.getAttribute(att, dval);
            if (cur != val) {
                PropertyConfig.this.changed = true;
                this.attributes.put(att, new Double(val));
            }
        }

        @Override
        public void setAttribute(String att, int val, int dval) {
            int cur = this.getAttribute(att, dval);
            if (cur != val) {
                PropertyConfig.this.changed = true;
                this.attributes.put(att, new Integer(val));
            }
        }

        @Override
        public void setAttribute(String att, String val, String dval) {
            String cur = this.getAttribute(att, dval);
            if (cur == null || !cur.equals(val)) {
                PropertyConfig.this.changed = true;
                this.attributes.put(att, val);
            }
        }

        public String toString() {
            String ret = "Node:" + this.name + "\n";
            for (String keys : this.children.keySet()) {
                for (PropertyConfigNode node : this.children.get(keys)) {
                    ret = ret + " " + node.name + "\n";
                }
            }
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getChildKeys() {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.children.keySet());
            return list;
        }

        public List<PropertyConfigNode> getChildren(String key) {
            if (this.children.containsKey(key)) {
                return this.children.get(key);
            }
            return new ArrayList<PropertyConfigNode>();
        }

        public String getStartElement() {
            String element = "<" + this.name;
            for (String key : this.attributes.keySet()) {
                String value = this.attributes.get(key).toString().replace("&", "&amp;");
                element = element + " " + key + "=\"" + value + "\"";
            }
            element = this.children.keySet() != null || this.children.keySet().size() > 0 ? element + ">" : element + "/>";
            return element;
        }

        public String getEndElement() {
            if (this.children.keySet() != null || this.children.keySet().size() > 0) {
                return "</" + this.name + ">";
            }
            return "";
        }
    }
}

