/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import java.awt.Color;
import java.util.Stack;

public class TreeDrawerNode {
    private double corr = 0.0;
    private double ind = -1.0;
    private double minInd;
    private double maxInd;
    private TreeDrawerNode parent = null;
    private TreeDrawerNode left = null;
    private TreeDrawerNode right = null;
    private String id = null;
    private Color color = Color.black;

    public double getIndex() {
        return this.ind;
    }

    public double getCorr() {
        return this.corr;
    }

    public String getId() {
        return this.id;
    }

    public TreeDrawerNode getParent() {
        return this.parent;
    }

    public TreeDrawerNode getLeft() {
        return this.left;
    }

    public TreeDrawerNode getRight() {
        return this.right;
    }

    public void setParent(TreeDrawerNode n) {
        this.parent = n;
    }

    public void setCorr(double newCorr) {
        this.corr = newCorr;
    }

    public double getMaxCorr() {
        double curCorr = this.getCorr();
        if (this.isLeaf()) {
            return curCorr;
        }
        Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
        remaining.push(this);
        while (!remaining.empty()) {
            TreeDrawerNode rightNode;
            TreeDrawerNode leftNode;
            TreeDrawerNode node = (TreeDrawerNode)remaining.pop();
            if (node.getCorr() > curCorr) {
                curCorr = node.getCorr();
            }
            if ((leftNode = node.getLeft()) != null) {
                remaining.push(leftNode);
            }
            if ((rightNode = node.getRight()) == null) continue;
            remaining.push(rightNode);
        }
        return curCorr;
    }

    public double getMinCorr() {
        double curCorr = this.getCorr();
        if (this.isLeaf()) {
            return curCorr;
        }
        Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
        remaining.push(this);
        while (!remaining.empty()) {
            TreeDrawerNode rightNode;
            TreeDrawerNode leftNode;
            TreeDrawerNode node = (TreeDrawerNode)remaining.pop();
            if (node.getCorr() < curCorr) {
                curCorr = node.getCorr();
            }
            if ((leftNode = node.getLeft()) != null) {
                remaining.push(leftNode);
            }
            if ((rightNode = node.getRight()) == null) continue;
            remaining.push(rightNode);
        }
        return curCorr;
    }

    public TreeDrawerNode findNode(String nodeid) {
        Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
        remaining.push(this);
        while (!remaining.empty()) {
            TreeDrawerNode rightNode;
            TreeDrawerNode node = (TreeDrawerNode)remaining.pop();
            if (node.getId().equals(nodeid)) {
                return node;
            }
            TreeDrawerNode leftNode = node.getLeft();
            if (leftNode != null) {
                remaining.push(leftNode);
            }
            if ((rightNode = node.getRight()) == null) continue;
            remaining.push(rightNode);
        }
        return null;
    }

    public double getDist(double index, double correlation, double weight) {
        double dx = this.ind - index;
        double dy = this.corr - correlation;
        return dx * dx + (dy *= weight) * dy;
    }

    public TreeDrawerNode(String i, double correlation, double index) {
        this.id = i;
        this.corr = correlation;
        this.ind = index;
        this.minInd = index;
        this.maxInd = index;
    }

    public TreeDrawerNode(String i, double correlation, TreeDrawerNode l, TreeDrawerNode r) {
        this.id = i;
        this.corr = correlation;
        this.right = r;
        this.left = l;
        this.ind = (this.right.getIndex() + this.left.getIndex()) / 2.0;
        this.minInd = Math.min(this.right.getMinIndex(), this.left.getMinIndex());
        this.maxInd = Math.max(this.right.getMaxIndex(), this.left.getMaxIndex());
        if (this.minInd > this.maxInd) {
            throw new RuntimeException("min was less than max! this should not happen.");
        }
    }

    public double getMaxIndex() {
        return this.maxInd;
    }

    public double getMinIndex() {
        return this.minInd;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public TreeDrawerNode getLeftLeaf() {
        TreeDrawerNode cand = this;
        while (!cand.isLeaf()) {
            cand = cand.getLeft();
        }
        return cand;
    }

    public TreeDrawerNode getRightLeaf() {
        TreeDrawerNode cand = this;
        while (!cand.isLeaf()) {
            cand = cand.getRight();
        }
        return cand;
    }

    public double getRange() {
        return this.maxInd - this.minInd;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void printSubtree() {
        this.printRecursive("");
    }

    private void printRecursive(String pre) {
        if (this.getLeft() != null) {
            System.out.println(pre + this.getId() + ", corr " + this.getCorr() + ", index " + this.getIndex());
            System.out.println(pre + "Left:");
            this.getLeft().printRecursive(pre + " ");
            System.out.println(pre + "Right:");
            this.getRight().printRecursive(pre + " ");
        } else {
            System.out.println(pre + this.getId() + " LEAF, corr " + this.getCorr() + ", index " + this.getIndex());
        }
    }
}

