/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ToolTipManager;

public abstract class TreeViewApp
implements WindowListener {
    public static final String versionTag = "1.1.1";
    protected Vector windows = new Vector();
    private PropertyConfig globalConfig;
    private boolean exitOnWindowsClosed = true;

    public static String getVersionTag() {
        return versionTag;
    }

    public TreeViewApp() {
        this(null);
    }

    public TreeViewApp(PropertyConfig propertyConfig) {
        this.setConfigDefaults(propertyConfig);
        try {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConfigDefaults(PropertyConfig propertyConfig) {
        this.globalConfig = propertyConfig;
    }

    public ViewFrame openNew() {
        TreeViewFrame tvFrame = new TreeViewFrame(this);
        tvFrame.addWindowListener(this);
        return tvFrame;
    }

    public PropertyConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void windowOpened(WindowEvent e) {
        this.windows.addElement((ViewFrame)e.getWindow());
        this.rebuildWindowMenus();
    }

    public void rebuildWindowMenus() {
        int max = this.windows.size();
        for (int i = 0; i < max; ++i) {
            ViewFrame viewFrame = (ViewFrame)this.windows.elementAt(i);
        }
    }

    public void windowClosed(WindowEvent e) {
        this.windows.removeElement(e.getWindow());
        if (this.windows.isEmpty() && this.exitOnWindowsClosed) {
            this.endProgram();
        }
        this.rebuildWindowMenus();
    }

    public void closeAllWindows() {
        Enumeration e = this.windows.elements();
        while (e.hasMoreElements()) {
            ViewFrame f = (ViewFrame)e.nextElement();
            f.closeWindow();
        }
    }

    public ViewFrame[] getWindows() {
        ViewFrame[] frames = new ViewFrame[this.windows.size()];
        int i = 0;
        Enumeration e = this.windows.elements();
        while (e.hasMoreElements()) {
            frames[i++] = (ViewFrame)e.nextElement();
        }
        return frames;
    }

    private void endProgram() {
        try {
            if (this.globalConfig != null) {
                this.globalConfig.store();
            }
            this.closeAllWindows();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    protected static String globalConfigName() {
        return "TreeViewConfig";
    }

    public void setExitOnWindowsClosed(boolean exitOnWindowsClosed) {
        this.exitOnWindowsClosed = exitOnWindowsClosed;
    }
}

