/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelViewBuffered;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.InvertedTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ATRView
extends ModelViewBuffered
implements MouseListener,
KeyListener {
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    protected HeaderSummary headerSummary = new HeaderSummary();
    private TreeSelectionI arraySelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer map;
    private JScrollBar scrollbar;
    private InvertedTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public ATRView() {
        this.panel = new JPanel();
        this.scrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.destRect = new Rectangle();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this, "Center");
        this.panel.add((Component)this.scrollbar, "East");
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public void setSelectedNode(TreeDrawerNode n) {
        if (this.selectedNode == n) {
            return;
        }
        if (this.selectedNode != null) {
            this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, false);
        }
        this.selectedNode = n;
        if (this.selectedNode != null && this.xScaleEq != null) {
            this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, true);
        }
        if (this.status != null && this.hasMouse) {
            this.status.setMessages(this.getStatus());
        }
        this.synchMap();
        this.repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.arraySelection != null) {
            int start = (int)this.selectedNode.getLeftLeaf().getIndex();
            int end = (int)this.selectedNode.getRightLeaf().getIndex();
            this.arraySelection.deselectAllIndexes();
            this.arraySelection.setSelectedNode(this.selectedNode.getId());
            this.arraySelection.selectIndexRange(start, end);
            this.arraySelection.notifyObservers();
        }
        if (this.status != null && this.hasMouse) {
            this.status.setMessages(this.getStatus());
        }
    }

    public void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        this.arraySelection.addObserver(this);
    }

    public void setInvertedTreeDrawer(InvertedTreeDrawer d) {
        if (this.drawer != null) {
            this.drawer.deleteObserver(this);
        }
        this.drawer = d;
        this.drawer.addObserver(this);
    }

    public void setMap(MapContainer m) {
        if (this.map != null) {
            this.map.deleteObserver(this);
        }
        this.map = m;
        this.map.addObserver(this);
    }

    public void update(Observable o, Object arg) {
        if (!this.isEnabled()) {
            return;
        }
        if (o == this.map) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.drawer) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.arraySelection) {
            TreeDrawerNode cand = null;
            if (this.arraySelection.getNSelectedIndexes() > 0) {
                if (this.arraySelection.getMinIndex() == this.arraySelection.getMaxIndex()) {
                    cand = this.drawer.getLeaf(this.arraySelection.getMinIndex());
                }
                if (this.arraySelection.getMinIndex() == this.map.getMinIndex() && this.arraySelection.getMaxIndex() == this.map.getMaxIndex()) {
                    cand = this.drawer.getRootNode();
                }
            }
            if (cand != null && cand.getId() != this.arraySelection.getSelectedNode()) {
                this.arraySelection.setSelectedNode(cand.getId());
                this.arraySelection.notifyObservers();
            } else {
                this.setSelectedNode(this.drawer.getNodeById(this.arraySelection.getSelectedNode()));
            }
        } else {
            System.out.println(this.viewName() + "Got an update from unknown " + o);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.repaint();
    }

    public String viewName() {
        return "ATRView";
    }

    public String[] getStatus() {
        String[] status;
        if (this.selectedNode != null) {
            if (this.selectedNode.isLeaf()) {
                status = new String[]{"Leaf Node " + this.selectedNode.getId(), "Pos " + this.selectedNode.getCorr()};
            } else {
                int[] nameIndex = this.getHeaderSummary().getIncluded();
                status = new String[nameIndex.length * 2];
                HeaderInfo atrInfo = this.getViewFrame().getDataModel().getAtrHeaderInfo();
                String[] names = atrInfo.getNames();
                for (int i = 0; i < nameIndex.length; ++i) {
                    status[2 * i] = names[nameIndex[i]] + ":";
                    status[2 * i + 1] = " " + atrInfo.getHeader(atrInfo.getHeaderIndex(this.selectedNode.getId()))[nameIndex[i]];
                }
            }
        } else {
            status = new String[]{"Select Node to ", "view annotation."};
        }
        return status;
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void updateBuffer(Graphics g) {
        if (this.offscreenChanged) {
            this.offscreenValid = false;
        }
        if (!this.offscreenValid && this.drawer != null) {
            this.map.setAvailablePixels(this.offscreenSize.width);
            g.setColor(Color.white);
            g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            g.setColor(Color.black);
            this.destRect.setBounds(0, 0, this.map.getUsedPixels(), this.offscreenSize.height);
            this.xScaleEq = new LinearTransformation(this.map.getIndex(this.destRect.x), this.destRect.x, this.map.getIndex(this.destRect.x + this.destRect.width), this.destRect.x + this.destRect.width);
            this.yScaleEq = new LinearTransformation(this.drawer.getCorrMin(), this.destRect.y, this.drawer.getCorrMax(), this.destRect.y + this.destRect.height);
            this.drawer.paint(g, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this == null) {
            return;
        }
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null) {
            this.setSelectedNode(this.drawer.getClosest(this.xScaleEq.inverseTransform(e.getX()), this.yScaleEq.inverseTransform(e.getY()), this.yScaleEq.getSlope() / this.xScaleEq.getSlope()));
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.selectedNode == null) {
            return;
        }
        int c = e.getKeyCode();
        Object cand = null;
        switch (c) {
            case 38: {
                this.selectParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                this.selectLeft();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                this.selectRight();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode right = this.selectedNode.getRight();
                TreeDrawerNode left = this.selectedNode.getLeft();
                if (right.getRange() > left.getRange()) {
                    this.selectRight();
                    break;
                }
                this.selectLeft();
            }
        }
    }

    private void selectParent() {
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getParent();
        if (this.selectedNode == null) {
            this.selectedNode = current;
            return;
        }
        current = current == this.selectedNode.getLeft() ? this.selectedNode.getRight() : this.selectedNode.getLeft();
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, current, true);
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, true);
        this.synchMap();
        this.repaint();
    }

    private void selectRight() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getRight();
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, current, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, current.getLeft(), false);
        this.synchMap();
        this.repaint();
    }

    private void selectLeft() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getLeft();
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, current, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, current.getRight(), false);
        this.synchMap();
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

