/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.InvertedTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ATRZoomView
extends ModelView
implements MouseListener,
KeyListener {
    protected HeaderSummary headerSummary = new HeaderSummary();
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    private TreeSelectionI arraySelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer zoomMap;
    private JScrollBar scrollbar;
    private InvertedTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public ATRZoomView() {
        this.panel = new JPanel();
        this.scrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.destRect = new Rectangle();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this, "Center");
        this.panel.add((Component)this.scrollbar, "East");
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public String[] getHints() {
        return hints;
    }

    public void setSelectedNode(TreeDrawerNode n) {
        if (this.selectedNode == n) {
            return;
        }
        this.selectedNode = n;
        this.offscreenValid = false;
        if (this.status != null && this.hasMouse) {
            this.status.setMessages(this.getStatus());
        }
        this.synchMap();
        this.repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.arraySelection != null) {
            int start = (int)this.selectedNode.getLeftLeaf().getIndex();
            int end = (int)this.selectedNode.getRightLeaf().getIndex();
            if (this.viewFrame.getDataModel().getDataMatrix().getNumCol() > this.viewFrame.getDataModel().getDataMatrix().getNumUnappendedCol()) {
                end = Math.max(this.viewFrame.getDataModel().getDataMatrix().getNumCol(), end);
            }
            this.arraySelection.deselectAllIndexes();
            this.arraySelection.setSelectedNode(this.selectedNode.getId());
            this.arraySelection.selectIndexRange(start, end);
            this.arraySelection.notifyObservers();
        }
    }

    public void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        this.arraySelection.addObserver(this);
    }

    public void setInvertedTreeDrawer(InvertedTreeDrawer d) {
        if (this.drawer != null) {
            this.drawer.deleteObserver(this);
        }
        this.drawer = d;
        this.drawer.addObserver(this);
    }

    public void setZoomMap(MapContainer m) {
        if (this.zoomMap != null) {
            this.zoomMap.deleteObserver(this);
        }
        this.zoomMap = m;
        this.zoomMap.addObserver(this);
    }

    public void update(Observable o, Object arg) {
        if (o == this.drawer) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.zoomMap) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.arraySelection) {
            this.setSelectedNode(this.drawer.getNodeById(this.arraySelection.getSelectedNode()));
        } else {
            System.out.println(this.viewName() + "Got an update from unknown " + o);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.repaint();
    }

    public String viewName() {
        return "ATRZoomView";
    }

    public String[] getStatus() {
        String[] status;
        if (this.selectedNode != null) {
            int[] nameIndex = this.getHeaderSummary().getIncluded();
            status = new String[nameIndex.length * 2];
            HeaderInfo atrInfo = this.getViewFrame().getDataModel().getAtrHeaderInfo();
            String[] names = atrInfo.getNames();
            for (int i = 0; i < nameIndex.length; ++i) {
                status[2 * i] = names[nameIndex[i]] + ":";
                int index = atrInfo.getHeaderIndex(this.selectedNode.getId());
                status[2 * i + 1] = index >= 0 ? " " + atrInfo.getHeader(atrInfo.getHeaderIndex(this.selectedNode.getId()))[nameIndex[i]] : " ";
            }
        } else {
            status = new String[]{"Select Node to ", "view annotation."};
        }
        return status;
    }

    public void updateBuffer(Graphics g) {
        if (this.offscreenChanged) {
            this.offscreenValid = false;
        }
        if (!this.offscreenValid) {
            if (this.drawer != null && this.selectedNode != null) {
                this.zoomMap.setAvailablePixels(this.offscreenSize.width);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
                g.setColor(Color.black);
                if (this.selectedNode.isLeaf()) {
                    return;
                }
                this.destRect.setBounds(0, 0, this.zoomMap.getUsedPixels(), this.offscreenSize.height);
                g.setClip(this.destRect.x, this.destRect.y, this.destRect.width, this.destRect.height);
                this.xScaleEq = new LinearTransformation(this.zoomMap.getIndex(this.destRect.x), this.destRect.x, this.zoomMap.getIndex(this.destRect.x + this.destRect.width), this.destRect.x + this.destRect.width);
                this.yScaleEq = new LinearTransformation(this.selectedNode.getMinCorr(), this.destRect.y, this.drawer.getCorrMax(), this.destRect.y + this.destRect.height);
                this.drawer.paint(g, this.xScaleEq, this.yScaleEq, this.destRect, null);
            } else {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null && this.xScaleEq != null && this.yScaleEq != null) {
            this.setSelectedNode(this.drawer.getClosest(this.xScaleEq.inverseTransform(e.getX()), this.yScaleEq.inverseTransform(e.getY()), this.yScaleEq.getSlope() / this.xScaleEq.getSlope()));
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.selectedNode == null) {
            return;
        }
        int c = e.getKeyCode();
        TreeDrawerNode cand = null;
        switch (c) {
            case 38: {
                cand = this.selectedNode.getParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                cand = this.selectedNode.getRight();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                cand = this.selectedNode.getLeft();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode right = this.selectedNode.getRight();
                TreeDrawerNode left = this.selectedNode.getLeft();
                cand = right.getRange() > left.getRange() ? right : left;
            }
        }
        if (cand != null) {
            this.setSelectedNode(cand);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

