/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;

public class ColorPresets
implements ConfigNodePersistent {
    private ConfigNode root;
    private static final int dIndex = 1;
    public static ColorSet[] defaultColorSets = new ColorSet[7];

    public ColorPresets(ConfigNode parent) {
        this.bindConfig(parent);
        int nNames = this.getPresetNames().length;
        if (nNames == 0) {
            this.addDefaultPresets();
        }
    }

    public ColorPresets() {
        this.root = new DummyConfigNode("ColorPresets");
    }

    public int getDefaultIndex() {
        return this.root.getAttribute("default", 1);
    }

    public boolean isDefaultEnabled() {
        return this.getDefaultIndex() != -1;
    }

    public ColorSet getDefaultColorSet() {
        int defaultPreset = this.getDefaultIndex();
        try {
            return this.getColorSet(defaultPreset);
        }
        catch (Exception e) {
            return this.getColorSet(0);
        }
    }

    public void setDefaultIndex(int i) {
        this.root.setAttribute("default", i, 1);
    }

    public void addDefaultPresets() {
        for (int i = 0; i < defaultColorSets.length; ++i) {
            this.addColorSet(defaultColorSets[i]);
        }
    }

    public String[] getPresetNames() {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        String[] astring = new String[aconfigNode.length];
        ColorSet temp = new ColorSet();
        for (int i = 0; i < aconfigNode.length; ++i) {
            temp.bindConfig(aconfigNode[i]);
            astring[i] = temp.getName();
        }
        return astring;
    }

    public int getNumPresets() {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        return aconfigNode.length;
    }

    public String toString() {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        ColorSet tmp = new ColorSet();
        String[] names = this.getPresetNames();
        String ret = "No Presets";
        if (names.length > 0) {
            ret = "Default is " + names[this.getDefaultIndex()] + " index " + this.getDefaultIndex() + "\n";
        }
        for (int index = 0; index < aconfigNode.length; ++index) {
            tmp.bindConfig(aconfigNode[index]);
            ret = ret + tmp.toString() + "\n";
        }
        return ret;
    }

    public ColorSet getColorSet(int index) {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        try {
            ColorSet ret = new ColorSet();
            ret.bindConfig(aconfigNode[index]);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ColorSet getColorSet(String name) {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        ColorSet ret = new ColorSet();
        for (int i = 0; i < aconfigNode.length; ++i) {
            ret.bindConfig(aconfigNode[i]);
            if (!name.equals(ret.getName())) continue;
            return ret;
        }
        return null;
    }

    public void addColorSet(String name, String up, String zero, String down, String missing) {
        ColorSet preset = new ColorSet();
        preset.bindConfig(this.root.create("ColorSet"));
        preset.setName(name);
        preset.setUp(up);
        preset.setZero(zero);
        preset.setDown(down);
        preset.setMissing(missing);
    }

    public void addColorSet(ColorSet set) {
        ColorSet preset = new ColorSet();
        if (this.root != null) {
            preset.bindConfig(this.root.create("ColorSet"));
        }
        preset.copyStateFrom(set);
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        int nNames = this.getPresetNames().length;
        if (nNames == 0) {
            this.addDefaultPresets();
        }
    }

    public void removeColorSet(int i) {
        ConfigNode[] aconfigNode = this.root.fetch("ColorSet");
        this.root.remove(aconfigNode[i]);
    }

    private ConfigNode createSubNode() {
        return this.root.create("ColorSet");
    }

    static {
        ColorPresets.defaultColorSets[0] = new ColorSet("RedYellow", "#FF0000", "#000000", "#FEFF00", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[1] = new ColorSet("YellowCyan", "#FEFF00", "#000000", "#1BB7E5", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[2] = new ColorSet("YellowPurple", "#FEFF00", "#000000", "#CC00CC", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[3] = new ColorSet("GreenPurple", "#00FF00", "#000000", "#CC00CC", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[4] = new ColorSet("YellowBlue", "#FEFF00", "#000000", "#0000FF", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[5] = new ColorSet("OrangeBlue", "#FF7F00", "#000000", "#0000FF", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[6] = new ColorSet("RedGreen", "#FF0000", "#000000", "#00FF00", "#909090", "#FFFFFF");
    }
}

