/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DragGridPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MainPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MessagePanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelessSettingsDialog;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ReorderedTreeSelection;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ATRView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ATRZoomView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayNameView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.CancelableSettingsDialog;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresetEditor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresets;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DendroException;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DoubleArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.GTRView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.GlobalView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.GraphicsExportPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.InvertedTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.LeftTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.PixelSettingsSelector;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TextViewManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TreeColorer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ZoomView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.DataModelWriter;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.ReorderedDataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TVModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TreeViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NetworkColorDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;

public class DendroView
extends JPanel
implements ConfigNodePersistent,
MainPanel,
Observer {
    protected ViewFrame viewFrame;
    protected ScrollPane[] panes;
    protected boolean loaded;
    private DataModel dataModel;
    private int[] arrayIndex = null;
    private int[] geneIndex = null;
    protected DendroView myView;
    protected JScrollBar globalXscrollbar;
    protected JScrollBar globalYscrollbar;
    protected GlobalView globalview;
    protected JScrollBar zoomXscrollbar;
    protected JScrollBar zoomYscrollbar;
    protected ZoomView zoomview;
    protected TextViewManager textview;
    protected ArrayNameView arraynameview;
    protected GTRView gtrview;
    protected ATRView atrview;
    protected ATRZoomView atrzview;
    protected InvertedTreeDrawer invertedTreeDrawer;
    protected LeftTreeDrawer leftTreeDrawer;
    private TreeSelectionI geneSelection = null;
    private TreeSelectionI arraySelection = null;
    protected MapContainer globalXmap;
    protected MapContainer globalYmap;
    protected MapContainer zoomXmap;
    protected MapContainer zoomYmap;
    protected MessagePanel hintpanel;
    protected MessagePanel statuspanel;
    protected ArrayDrawer arrayDrawer;
    protected ConfigNode root;
    protected ColorPresets colorPresets;
    protected ColorPresetEditor cpresetEditor;
    protected JDialog settingsFrame;
    private static ImageIcon treeviewIcon = null;

    public DendroView(DataModel tVModel, ViewFrame vFrame) {
        this(tVModel, null, vFrame, "Dendrogram");
    }

    public DendroView(DataModel tVModel, ConfigNode root, ViewFrame vFrame) {
        this(tVModel, root, vFrame, "Dendrogram");
    }

    public DendroView(DataModel dataModel, ConfigNode root, ViewFrame vFrame, String name) {
        int groupIndex;
        HeaderInfo headerInfo;
        super.setName(name);
        this.myView = this;
        this.viewFrame = vFrame;
        if (root == null) {
            if (dataModel.getDocumentConfig() != null) {
                this.bindConfig(dataModel.getDocumentConfig().fetchOrCreate("MainView"));
            } else {
                this.bindConfig(new DummyConfigNode("MainView"));
            }
        } else {
            this.bindConfig(root);
        }
        if (dataModel.getArrayHeaderInfo().getIndex("GROUP") != -1) {
            headerInfo = dataModel.getArrayHeaderInfo();
            groupIndex = headerInfo.getIndex("GROUP");
            this.arrayIndex = this.getGroupVector(headerInfo, groupIndex);
        } else {
            this.arrayIndex = null;
        }
        if (dataModel.getGeneHeaderInfo().getIndex("GROUP") != -1) {
            headerInfo = dataModel.getGeneHeaderInfo();
            groupIndex = headerInfo.getIndex("GROUP");
            this.geneIndex = this.getGroupVector(headerInfo, groupIndex);
        } else {
            this.geneIndex = null;
        }
        if (this.arrayIndex != null || this.geneIndex != null) {
            dataModel = new ReorderedDataModel(dataModel, this.geneIndex, this.arrayIndex);
        }
        this.setDataModel(dataModel);
        this.setupViews();
        if (this.geneIndex != null) {
            this.setGeneSelection(new ReorderedTreeSelection(this.viewFrame.getGeneSelection(), this.geneIndex));
        } else {
            this.setGeneSelection(this.viewFrame.getGeneSelection());
        }
        if (this.arrayIndex != null) {
            this.setArraySelection(new ReorderedTreeSelection(this.viewFrame.getArraySelection(), this.arrayIndex));
        } else {
            this.setArraySelection(this.viewFrame.getArraySelection());
        }
    }

    private int[] getGroupVector(HeaderInfo headerInfo, int groupIndex) {
        int ngroup = 0;
        String cur = headerInfo.getHeader(0, groupIndex);
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            String test = headerInfo.getHeader(i, groupIndex);
            if (cur.equals(test)) continue;
            cur = test;
            ++ngroup;
        }
        int[] groupVector = new int[ngroup + headerInfo.getNumHeaders()];
        ngroup = 0;
        cur = headerInfo.getHeader(0, groupIndex);
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            String test = headerInfo.getHeader(i, groupIndex);
            if (!cur.equals(test)) {
                groupVector[i + ngroup] = -1;
                cur = test;
                ++ngroup;
            }
            groupVector[i + ngroup] = i;
        }
        return groupVector;
    }

    protected DendroView(int cols, int rows, String name) {
        super.setName(name);
    }

    protected ConfigNode getFirst(String name) {
        return this.getConfigNode().fetchOrCreate(name);
    }

    public TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    public TreeSelectionI getArraySelection() {
        return this.arraySelection;
    }

    public InvertedTreeDrawer getArrayTreeDrawer() {
        return this.invertedTreeDrawer;
    }

    public LeftTreeDrawer getGeneTreeDrawer() {
        return this.leftTreeDrawer;
    }

    public ArrayDrawer getArrayDrawer() {
        return this.arrayDrawer;
    }

    protected void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        arraySelection.addObserver(this);
        this.globalview.setArraySelection(arraySelection);
        this.zoomview.setArraySelection(arraySelection);
        this.atrview.setArraySelection(arraySelection);
        this.atrzview.setArraySelection(arraySelection);
        this.arraynameview.setArraySelection(arraySelection);
    }

    protected void setGeneSelection(TreeSelectionI geneSelection) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver(this);
        }
        this.geneSelection = geneSelection;
        geneSelection.addObserver(this);
        this.globalview.setGeneSelection(geneSelection);
        this.zoomview.setGeneSelection(geneSelection);
        this.gtrview.setGeneSelection(geneSelection);
        this.textview.setGeneSelection(geneSelection);
    }

    private void flipSelectedATRNode() {
        int i;
        TreeDrawerNode arrayNode = this.invertedTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode());
        if (arrayNode == null || arrayNode.isLeaf()) {
            return;
        }
        String selectedID = arrayNode.getId();
        int leftIndex = this.getDataModel().getArrayHeaderInfo().getHeaderIndex(arrayNode.getLeft().getLeftLeaf().getId());
        int rightIndex = this.getDataModel().getArrayHeaderInfo().getHeaderIndex(arrayNode.getRight().getRightLeaf().getId());
        int num = this.getDataModel().getDataMatrix().getNumUnappendedCol();
        int[] newOrder = new int[num];
        for (i = 0; i < num; ++i) {
            newOrder[i] = i;
        }
        for (i = 0; i <= rightIndex - leftIndex; ++i) {
            newOrder[leftIndex + i] = rightIndex - i;
        }
        ((TVModel)this.getDataModel()).reorderArrays(newOrder);
        ((TVModel)this.getDataModel()).saveOrder(newOrder);
        ((Observable)((Object)this.getDataModel())).notifyObservers();
        this.updateATRDrawer(selectedID);
    }

    private void updateATRDrawer(String selectedID) {
        try {
            TVModel tvmodel = (TVModel)this.getDataModel();
            this.invertedTreeDrawer.setData(tvmodel.getAtrHeaderInfo(), tvmodel.getArrayHeaderInfo());
            HeaderInfo trHeaderInfo = tvmodel.getAtrHeaderInfo();
            if (trHeaderInfo.getIndex("NODECOLOR") >= 0) {
                TreeColorer.colorUsingHeader(this.invertedTreeDrawer.getRootNode(), trHeaderInfo, trHeaderInfo.getIndex("NODECOLOR"));
            }
        }
        catch (DendroException e) {
            Box mismatch = new Box(1);
            mismatch.add(new JLabel(e.getMessage()));
            mismatch.add(new JLabel("Perhaps there is a mismatch between your ATR and CDT files?"));
            mismatch.add(new JLabel("Ditching Array Tree, since it's lame."));
            JOptionPane.showMessageDialog(this.viewFrame, mismatch, "Tree Construction Error", 0);
            this.atrview.setEnabled(false);
            this.atrzview.setEnabled(false);
            try {
                this.invertedTreeDrawer.setData(null, null);
            }
            catch (DendroException ex) {
                // empty catch block
            }
        }
        TreeDrawerNode arrayNode = this.invertedTreeDrawer.getRootNode().findNode(selectedID);
        this.arraySelection.setSelectedNode(arrayNode.getId());
        this.atrzview.setSelectedNode(arrayNode);
        this.atrview.setSelectedNode(arrayNode);
        this.arraySelection.notifyObservers();
        this.invertedTreeDrawer.notifyObservers();
    }

    public MapContainer getGlobalXmap() {
        return this.globalXmap;
    }

    public MapContainer getGlobalYmap() {
        return this.globalYmap;
    }

    public MapContainer getZoomXmap() {
        return this.zoomXmap;
    }

    public MapContainer getZoomYmap() {
        return this.zoomYmap;
    }

    public void scrollToGene(int i) {
        this.getGlobalYmap().scrollToIndex(i);
        this.getGlobalYmap().notifyObservers();
    }

    public void scrollToArray(int i) {
        this.getGlobalXmap().scrollToIndex(i);
        this.getGlobalXmap().notifyObservers();
    }

    public void update(Observable o, Object arg) {
        if (o == this.geneSelection) {
            this.gtrview.scrollToNode(this.geneSelection.getSelectedNode());
        }
    }

    protected void setupViews() {
        this.colorPresets = new ColorPresets(this.root);
        this.cpresetEditor = new ColorPresetEditor(this.colorPresets);
        ColorExtractor colorExtractor = new ColorExtractor();
        colorExtractor.setDefaultColorSet(this.colorPresets.getDefaultColorSet());
        colorExtractor.bindConfig(this.root);
        colorExtractor.setMissing(-1.0E7, -2.0E7);
        this.hintpanel = new MessagePanel("Usage Hints");
        this.statuspanel = new MessagePanel("View Status");
        DoubleArrayDrawer dArrayDrawer = new DoubleArrayDrawer();
        dArrayDrawer.setColorExtractor(colorExtractor);
        this.arrayDrawer = dArrayDrawer;
        ((Observable)((Object)this.getDataModel())).addObserver(this.arrayDrawer);
        this.globalview = new GlobalView();
        this.globalXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.globalYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.zoomYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXmap = new MapContainer();
        this.zoomXmap.setDefaultScale(12.0);
        this.zoomXmap.setScrollbar(this.zoomXscrollbar);
        this.zoomYmap = new MapContainer();
        this.zoomYmap.setDefaultScale(12.0);
        this.zoomYmap.setScrollbar(this.zoomYscrollbar);
        this.globalXmap = new MapContainer();
        this.globalXmap.setDefaultScale(2.0);
        this.globalXmap.setScrollbar(this.globalXscrollbar);
        this.globalYmap = new MapContainer();
        this.globalYmap.setDefaultScale(2.0);
        this.globalYmap.setScrollbar(this.globalYscrollbar);
        this.globalview.setXMap(this.globalXmap);
        this.globalview.setYMap(this.globalYmap);
        this.globalview.setZoomYMap(this.getZoomYmap());
        this.globalview.setZoomXMap(this.getZoomXmap());
        this.globalview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview = new ArrayNameView(this.getDataModel().getArrayHeaderInfo());
        this.arraynameview.setDataModel(this.getDataModel());
        this.leftTreeDrawer = new LeftTreeDrawer();
        this.gtrview = new GTRView();
        this.gtrview.setMap(this.globalYmap);
        this.gtrview.setLeftTreeDrawer(this.leftTreeDrawer);
        this.gtrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.invertedTreeDrawer = new InvertedTreeDrawer();
        this.atrview = new ATRView();
        this.atrview.setMap(this.globalXmap);
        this.atrview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.atrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.atrzview = new ATRZoomView();
        this.atrzview.setZoomMap(this.getZoomXmap());
        this.atrzview.setHeaderSummary(this.atrview.getHeaderSummary());
        this.atrzview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.zoomview = new ZoomView();
        this.zoomview.setYMap(this.getZoomYmap());
        this.zoomview.setXMap(this.getZoomXmap());
        this.zoomview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview.setMapping(this.getZoomXmap());
        this.textview = new TextViewManager(this.getDataModel().getGeneHeaderInfo());
        this.textview.setMap(this.getZoomYmap());
        this.doDoubleLayout();
        this.settingsFrame = null;
        colorExtractor.bindConfig(this.getFirst("ColorExtractor"));
        dArrayDrawer.setDataMatrix(this.getDataModel().getDataMatrix());
        dArrayDrawer.bindConfig(this.getFirst("ArrayDrawer"));
        this.bindTrees();
        this.zoomview.setHeaders(this.getDataModel().getGeneHeaderInfo(), this.getDataModel().getArrayHeaderInfo());
        this.globalXmap.bindConfig(this.getFirst("GlobalXMap"));
        this.globalYmap.bindConfig(this.getFirst("GlobalYMap"));
        this.getZoomXmap().bindConfig(this.getFirst("ZoomXMap"));
        this.getZoomYmap().bindConfig(this.getFirst("ZoomYMap"));
        this.textview.bindConfig(this.getFirst("TextView"));
        this.arraynameview.bindConfig(this.getFirst("ArrayNameView"));
        HeaderSummary atrSummary = this.atrview.getHeaderSummary();
        this.atrzview.setHeaderSummary(atrSummary);
        atrSummary.bindConfig(this.getFirst("AtrSummary"));
        this.gtrview.getHeaderSummary().bindConfig(this.getFirst("GtrSummary"));
        this.globalXmap.setIndexRange(0, this.dataModel.getDataMatrix().getNumCol() - 1);
        this.globalYmap.setIndexRange(0, this.dataModel.getDataMatrix().getNumRow() - 1);
        this.getZoomXmap().setIndexRange(-1, -1);
        this.getZoomYmap().setIndexRange(-1, -1);
        this.globalXmap.notifyObservers();
        this.globalYmap.notifyObservers();
        this.getZoomXmap().notifyObservers();
        this.getZoomYmap().notifyObservers();
    }

    protected void bindTrees() {
        Box mismatch;
        DataModel tvmodel = this.getDataModel();
        if (tvmodel != null && tvmodel.aidFound()) {
            try {
                this.atrview.setEnabled(true);
                this.atrzview.setEnabled(true);
                this.invertedTreeDrawer.setData(tvmodel.getAtrHeaderInfo(), tvmodel.getArrayHeaderInfo());
                HeaderInfo trHeaderInfo = tvmodel.getAtrHeaderInfo();
                if (trHeaderInfo.getIndex("NODECOLOR") >= 0) {
                    TreeColorer.colorUsingHeader(this.invertedTreeDrawer.getRootNode(), trHeaderInfo, trHeaderInfo.getIndex("NODECOLOR"));
                }
            }
            catch (DendroException e) {
                mismatch = new Box(1);
                mismatch.add(new JLabel(e.getMessage()));
                mismatch.add(new JLabel("Perhaps there is a mismatch between your ATR and CDT files?"));
                mismatch.add(new JLabel("Ditching Array Tree, since it's lame."));
                JOptionPane.showMessageDialog(this.viewFrame, mismatch, "Tree Construction Error", 0);
                this.atrview.setEnabled(false);
                this.atrzview.setEnabled(false);
                try {
                    this.invertedTreeDrawer.setData(null, null);
                }
                catch (DendroException ex) {}
            }
        } else {
            this.atrview.setEnabled(false);
            this.atrzview.setEnabled(false);
            try {
                this.invertedTreeDrawer.setData(null, null);
            }
            catch (DendroException ex) {
                // empty catch block
            }
        }
        this.invertedTreeDrawer.notifyObservers();
        if (tvmodel != null && tvmodel.gidFound()) {
            try {
                this.leftTreeDrawer.setData(tvmodel.getGtrHeaderInfo(), tvmodel.getGeneHeaderInfo());
                HeaderInfo gtrHeaderInfo = tvmodel.getGtrHeaderInfo();
                if (gtrHeaderInfo.getIndex("NODECOLOR") >= 0) {
                    TreeColorer.colorUsingHeader(this.leftTreeDrawer.getRootNode(), tvmodel.getGtrHeaderInfo(), gtrHeaderInfo.getIndex("NODECOLOR"));
                } else {
                    TreeColorer.colorUsingLeaf(this.leftTreeDrawer.getRootNode(), tvmodel.getGeneHeaderInfo(), tvmodel.getGeneHeaderInfo().getIndex("FGCOLOR"));
                }
                this.gtrview.setEnabled(true);
            }
            catch (DendroException e) {
                mismatch = new Box(1);
                mismatch.add(new JLabel(e.getMessage()));
                mismatch.add(new JLabel("Perhaps there is a mismatch between your GTR and CDT files?"));
                mismatch.add(new JLabel("Ditching Gene Tree, since it's lame."));
                JOptionPane.showMessageDialog(this.viewFrame, mismatch, "Tree Construction Error", 0);
                this.gtrview.setEnabled(false);
                try {
                    this.leftTreeDrawer.setData(null, null);
                }
                catch (DendroException ex) {}
            }
        } else {
            this.gtrview.setEnabled(false);
            try {
                this.leftTreeDrawer.setData(null, null);
            }
            catch (DendroException dendroException) {
                // empty catch block
            }
        }
        this.leftTreeDrawer.notifyObservers();
    }

    protected void doDoubleLayout() {
        DragGridPanel left = new DragGridPanel(2, 2);
        left.setName("LeftDrag");
        DragGridPanel right = new DragGridPanel(2, 3);
        right.setName("RightDrag");
        left.setBorderWidth(2);
        left.setBorderHeight(2);
        left.setMinimumWidth(1);
        left.setMinimumHeight(1);
        left.setFocusWidth(1);
        left.setFocusHeight(1);
        right.setBorderWidth(2);
        right.setBorderHeight(2);
        right.setMinimumWidth(1);
        right.setMinimumHeight(1);
        right.setFocusWidth(1);
        right.setFocusHeight(1);
        float[] lheights = new float[]{0.15f, 0.85f};
        left.setHeights(lheights);
        float[] lwidths = new float[]{0.35f, 0.65f};
        left.setWidths(lwidths);
        float[] rheights = new float[]{0.15f, 0.05f, 0.8f};
        right.setHeights(rheights);
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        left.addComponent(this.statuspanel, rectangle);
        rectangle.translate(1, 0);
        left.addComponent(this.atrview.getComponent(), rectangle);
        this.registerView(this.atrview);
        rectangle.translate(-1, 0);
        right.addComponent(this.arraynameview.getComponent(), rectangle);
        this.registerView(this.arraynameview);
        rectangle.translate(0, 1);
        right.addComponent(this.atrzview.getComponent(), rectangle);
        this.registerView(this.atrzview);
        rectangle.setSize(1, 2);
        rectangle.translate(1, -1);
        right.addComponent(this.hintpanel, rectangle);
        rectangle = new Rectangle(0, 1, 1, 1);
        JPanel gtrPanel = new JPanel();
        gtrPanel.setLayout(new BorderLayout());
        gtrPanel.add((Component)this.gtrview, "Center");
        gtrPanel.add((Component)new JScrollBar(0, 0, 1, 0, 1), "South");
        left.addComponent(gtrPanel, rectangle);
        this.gtrview.setHintPanel(this.hintpanel);
        this.gtrview.setStatusPanel(this.statuspanel);
        this.gtrview.setViewFrame(this.viewFrame);
        rectangle.translate(1, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.globalview, "Center");
        panel.add((Component)this.globalYscrollbar, "East");
        panel.add((Component)this.globalXscrollbar, "South");
        left.addComponent(panel, rectangle);
        this.registerView(this.globalview);
        rectangle.translate(-1, 1);
        JPanel zoompanel = new JPanel();
        zoompanel.setLayout(new BorderLayout());
        zoompanel.add((Component)this.zoomview, "Center");
        zoompanel.add((Component)this.zoomXscrollbar, "South");
        zoompanel.add((Component)this.zoomYscrollbar, "East");
        right.addComponent(zoompanel, rectangle);
        this.registerView(this.zoomview);
        rectangle.translate(1, 0);
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BorderLayout());
        textpanel.add((Component)this.textview.getComponent(), "Center");
        right.addComponent(textpanel, rectangle);
        this.registerView(this.textview);
        JSplitPane innerPanel = new JSplitPane(1, left, right);
        innerPanel.setOneTouchExpandable(true);
        innerPanel.setDividerLocation(300);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)innerPanel, "Center");
        outerPanel.add((Component)this.getButtonBox(), "South");
        this.setLayout(new CardLayout());
        this.add((Component)outerPanel, "running");
    }

    private JPanel getButtonBox() {
        JPanel buttonBox = new JPanel();
        buttonBox.setBorder(BorderFactory.createEtchedBorder(1));
        JButton settingsButton = this.createButton("Settings...");
        settingsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorExtractor ce = null;
                try {
                    ce = ((DoubleArrayDrawer)DendroView.this.arrayDrawer).getColorExtractor();
                }
                catch (Exception e) {
                    // empty catch block
                }
                PixelSettingsSelector pssSelector = new PixelSettingsSelector(DendroView.this.globalXmap, DendroView.this.globalYmap, DendroView.this.getZoomXmap(), DendroView.this.getZoomYmap(), ce, DendroView.this.colorPresets);
                ModelessSettingsDialog popup = new ModelessSettingsDialog(DendroView.this.viewFrame, "Pixel Settings", pssSelector);
                popup.addWindowListener(PropertyConfig.getStoreOnWindowClose(DendroView.this.getDataModel().getDocumentConfig()));
                popup.pack();
                ((Dialog)popup).setVisible(true);
            }
        });
        buttonBox.add(settingsButton);
        JButton saveButton = this.createButton("Save Data...");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(DendroView.this.viewFrame);
                if (returnVal == 0) {
                    String filePath = chooser.getSelectedFile().getAbsolutePath();
                    if (filePath.length() == 0) {
                        return;
                    }
                    DataModelWriter writer = new DataModelWriter(DendroView.this.dataModel);
                    if (DendroView.this.dataModel.aidFound()) {
                        writer.writeAtr(filePath + ".atr");
                    }
                    if (DendroView.this.dataModel.gidFound()) {
                        writer.writeGtr(filePath + ".gtr");
                    }
                    writer.writeCdt(filePath + ".cdt");
                }
            }
        });
        buttonBox.add(saveButton);
        JButton exportButton = this.createButton("Export Graphics...");
        exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                GraphicsExportPanel graphicsExport = new GraphicsExportPanel(DendroView.this.myView);
                graphicsExport.setGeneFont(DendroView.this.textview.getFont());
                graphicsExport.setArrayFont(DendroView.this.arraynameview.getFont());
                CancelableSettingsDialog popup = new CancelableSettingsDialog(DendroView.this.viewFrame, "Export Graphics", graphicsExport);
                popup.addWindowListener(PropertyConfig.getStoreOnWindowClose(DendroView.this.getDataModel().getDocumentConfig()));
                popup.pack();
                popup.setVisible(true);
            }
        });
        buttonBox.add(exportButton);
        if (this.dataModel.aidFound()) {
            JButton flipButton = this.createButton("Flip Tree Nodes");
            flipButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DendroView.this.flipSelectedATRNode();
                }
            });
            buttonBox.add(flipButton);
        }
        if (this.dataModel instanceof TreeViewModel) {
            final ClusterManager clusterManager = ((TreeViewModel)this.dataModel).getClusterManager();
            JButton vizMapButton = this.createButton("Map Colors Onto Network...");
            vizMapButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ColorExtractor ce = null;
                    try {
                        ce = ((DoubleArrayDrawer)DendroView.this.arrayDrawer).getColorExtractor();
                    }
                    catch (Exception e) {
                        ce = new ColorExtractor();
                        ce.setDefaultColorSet(DendroView.this.colorPresets.getDefaultColorSet());
                    }
                    ArrayList<String> attributes = new ArrayList<String>();
                    if (!DendroView.this.dataModel.isSymmetrical()) {
                        int[] selections = DendroView.this.arraySelection.getSelectedIndexes();
                        HeaderInfo arrayInfo = DendroView.this.dataModel.getArrayHeaderInfo();
                        if (selections.length >= 1) {
                            for (int i = 0; i < selections.length; ++i) {
                                attributes.add(arrayInfo.getHeader(selections[i])[0]);
                            }
                        } else {
                            int count = arrayInfo.getNumHeaders();
                            for (int i = 0; i < count; ++i) {
                                attributes.add(arrayInfo.getHeader(i)[0]);
                            }
                        }
                    }
                    NetworkColorDialog ncd = new NetworkColorDialog(null, ce, attributes, DendroView.this.viewFrame, clusterManager, DendroView.this.dataModel.getDataMatrix().getMinValue(), DendroView.this.dataModel.getDataMatrix().getMaxValue(), DendroView.this.dataModel.isSymmetrical());
                }
            });
            buttonBox.add(vizMapButton);
        }
        JButton closeButton = this.createButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DendroView.this.viewFrame.closeWindow();
            }
        });
        buttonBox.add(closeButton);
        return buttonBox;
    }

    private void registerView(ModelView modelView) {
        modelView.setHintPanel(this.hintpanel);
        modelView.setStatusPanel(this.statuspanel);
        modelView.setViewFrame(this.viewFrame);
    }

    private JButton createButton(String label) {
        JButton button = new JButton("<html><b style=\"font-size: 80%;\">" + label + "</b></html>");
        return button;
    }

    public void showSubDataModel(int[] indexes) {
        this.getViewFrame().showSubDataModel(indexes, null, null);
    }

    public void syncConfig() {
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public void setViewFrame(ViewFrame viewFrame) {
        this.viewFrame = viewFrame;
    }

    public ViewFrame getViewFrame() {
        return this.viewFrame;
    }

    protected void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public ConfigNode getConfigNode() {
        return this.root;
    }

    public ImageIcon getIcon() {
        if (treeviewIcon == null) {
            try {
                treeviewIcon = new ImageIcon("images/treeview.gif", "TreeView Icon");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return treeviewIcon;
    }

    public ArrayNameView getArraynameview() {
        return this.arraynameview;
    }

    public ATRView getAtrview() {
        return this.atrview;
    }

    public GTRView getGtrview() {
        return this.gtrview;
    }

    public TextViewManager getTextview() {
        return this.textview;
    }
}

