/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import java.awt.Color;
import java.awt.Rectangle;

public class DoubleArrayDrawer
extends ArrayDrawer {
    protected ColorExtractor colorExtractor;
    protected DataMatrix dataMatrix;

    public void setColorExtractor(ColorExtractor colorExtractor) {
        if (this.colorExtractor != null) {
            this.colorExtractor.deleteObserver(this);
        }
        this.colorExtractor = colorExtractor;
        colorExtractor.addObserver(this);
        this.setChanged();
    }

    public ColorExtractor getColorExtractor() {
        return this.colorExtractor;
    }

    public void setDataMatrix(DataMatrix matrix) {
        if (this.dataMatrix != matrix) {
            this.dataMatrix = matrix;
            this.setChanged();
        }
    }

    public void recalculateContrast() {
        double mean = 0.0;
        int count = 0;
        int nRow = this.dataMatrix.getNumRow();
        int nCol = this.dataMatrix.getNumCol();
        for (int row = 0; row < nRow; ++row) {
            for (int col = 0; col < nCol; ++col) {
                double val = this.dataMatrix.getValue(row, col);
                if (val == -1.0E7 || val == -2.0E7) continue;
                mean += Math.abs(val);
                ++count;
            }
        }
        this.colorExtractor.setContrast((mean /= (double)count) * 4.0);
        this.colorExtractor.notifyObservers();
    }

    public void paint(int[] pixels, Rectangle source, Rectangle dest, int scanSize, int[] geneOrder) {
        if (this.dataMatrix == null) {
            System.out.println("data matrix wasn't set");
        }
        int ynext = dest.y;
        int geneFirst = 0;
        for (int gene = 0; gene < source.height; ++gene) {
            ynext = dest.y + (dest.height + gene * dest.height) / source.height;
            int ystart = ynext;
            if (ynext == ystart) continue;
            int xnext = dest.x;
            int arrayFirst = 0;
            for (int array = 0; array < source.width; ++array) {
                xnext = dest.x + (dest.width + array * dest.width) / source.width;
                int xstart = xnext;
                if (xnext == xstart) continue;
                try {
                    double val = 0.0;
                    int count = 0;
                    for (int i = geneFirst; i <= gene; ++i) {
                        for (int j = arrayFirst; j <= array; ++j) {
                            double thisVal;
                            int actualGene = source.y + i;
                            if (geneOrder != null) {
                                actualGene = geneOrder[actualGene];
                            }
                            if ((thisVal = this.dataMatrix.getValue(j + source.x, actualGene)) == -2.0E7) {
                                val = -2.0E7;
                                count = 1;
                                break;
                            }
                            if (thisVal == -1.0E7) continue;
                            ++count;
                            val += thisVal;
                        }
                        if (val == -2.0E7) break;
                    }
                    val = count == 0 ? -1.0E7 : (val /= (double)count);
                    int t_color = this.colorExtractor.getARGBColor(val);
                    for (int x = xstart; x < xnext; ++x) {
                        for (int y = ystart; y < ynext; ++y) {
                            pixels[x + y * scanSize] = t_color;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                arrayFirst = array + 1;
            }
            geneFirst = gene + 1;
        }
    }

    public double getValue(int x, int y) {
        if (this.dataMatrix == null) {
            System.out.println("dataMatrix was not set in DoubleArrayDrawer");
        }
        return this.dataMatrix.getValue(x, y);
    }

    public String getSummary(int x, int y) {
        return "" + this.getValue(x, y);
    }

    public boolean isMissing(int x, int y) {
        return this.getValue(x, y) == -1.0E7;
    }

    public boolean isEmpty(int x, int y) {
        return this.getValue(x, y) == -2.0E7;
    }

    public int getNumRow() {
        if (this.dataMatrix != null) {
            return this.dataMatrix.getNumRow();
        }
        return 0;
    }

    public int getNumCol() {
        if (this.dataMatrix != null) {
            return this.dataMatrix.getNumCol();
        }
        return 0;
    }

    public Color getColor(int x, int y) {
        return this.colorExtractor.getColor(this.getValue(x, y));
    }

    protected void setDefaults() {
        this.dataMatrix = null;
    }
}

