/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MessagePanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TextView;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TextViewManager
extends ModelView
implements PropertyChangeListener {
    boolean ignoreDividerChange = false;
    JSplitPane last;
    Component root;
    JSplitPane firstNotShown;
    TextView lastView;
    int numViews;
    int numShown;
    HeaderInfo hI;
    Vector textViews;
    ConfigNode configRoot;
    HeaderSummary headerSummary = new HeaderSummary();
    int[] dividerLocations;
    private final String d_face = "Lucida Sans Regular";
    private final int d_style = 0;
    private final int d_size = 12;

    public TextViewManager(HeaderInfo hI) {
        this.hI = hI;
        this.root = null;
        this.textViews = new Vector();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout());
        this.dividerLocations = new int[hI.getNumNames() - 1];
        this.firstNotShown = null;
        this.numShown = 0;
        int GIDIndex = hI.getIndex("GID");
        if (GIDIndex == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        this.headerSummary.addObserver(this);
        this.makeTextViews(hI.getNumNames());
        for (int i = 0; i < this.numViews - 1; ++i) {
            this.dividerLocations[i] = 50;
        }
        this.addTextViews(1);
        this.loadDividerLocations();
        this.setVisible(true);
    }

    private void loadSelection() {
        if (this.configRoot == null) {
            return;
        }
        ConfigNode[] nodes = this.configRoot.fetch("Selection");
        if (nodes.length > 0) {
            int[] included = new int[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                included[i] = nodes[i].getAttribute("index", -1);
            }
            this.headerSummary.setIncluded(included);
        }
    }

    private void saveSelection() {
        if (this.configRoot == null) {
            return;
        }
        this.configRoot.removeAll("Selection");
        for (int i = 0; i < this.headerSummary.getIncluded().length; ++i) {
            this.configRoot.create("Selection").setAttribute("index", this.headerSummary.getIncluded()[i], -1);
        }
    }

    public void update(Observable ob, Object obj) {
        if (ob == this.headerSummary) {
            this.saveSelection();
            this.saveDividerLocations();
            this.addTextViews(this.headerSummary.getIncluded().length);
            this.loadDividerLocations();
        }
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).update(ob, obj);
        }
    }

    public void updateBuffer(Graphics g) {
        this.paintAll(g);
    }

    public void updateBuffer(Image buf) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).updateBuffer(buf);
        }
    }

    public String viewName() {
        return "TextViewManager";
    }

    public void setViewFrame(ViewFrame m) {
        super.setViewFrame(m);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setViewFrame(m);
        }
    }

    public void setHintPanel(MessagePanel h) {
        super.setHintPanel(h);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setHintPanel(h);
        }
    }

    public void setStatusPanel(MessagePanel s) {
        super.setStatusPanel(s);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setStatusPanel(s);
        }
    }

    private void makeTextViews(int n) {
        this.numViews = n;
        for (int i = 0; i < n; ++i) {
            this.textViews.add(new TextView(this.hI, i));
            ((TextView)this.textViews.lastElement()).setHeaderSummary(this.headerSummary);
            this.headerSummary.addObserver((TextView)this.textViews.lastElement());
        }
    }

    private void addTextViews(int n) {
        this.numShown = n;
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            this.root = ((TextView)this.textViews.get(0)).getComponent();
        } else {
            this.root = new JSplitPane(1);
            ((JSplitPane)this.root).setDividerSize(2);
            ((JSplitPane)this.root).setBorder(null);
            ((JSplitPane)this.root).setRightComponent(((TextView)this.textViews.get(n - 1)).getComponent());
            ((JSplitPane)this.root).setLeftComponent(((TextView)this.textViews.get(n - 2)).getComponent());
            this.root.addPropertyChangeListener("dividerLocation", this);
            for (int i = n - 3; i >= 0; --i) {
                JSplitPane temp = new JSplitPane(1);
                temp.setLeftComponent(((TextView)this.textViews.get(i)).getComponent());
                temp.setRightComponent(this.root);
                temp.setDividerSize(2);
                temp.setBorder(null);
                temp.addPropertyChangeListener("dividerLocation", this);
                this.root = temp;
            }
        }
        this.panel.removeAll();
        this.panel.add(this.root);
        this.panel.updateUI();
    }

    public void setGeneSelection(TreeSelectionI selection) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setGeneSelection(selection);
        }
    }

    public void setMap(MapContainer zoomYMap) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setMap(zoomYMap);
        }
    }

    public void bindConfig(ConfigNode configNode) {
        int i;
        this.configRoot = configNode;
        this.loadSelection();
        ConfigNode[] viewNodes = this.configRoot.fetch("TextView");
        for (i = viewNodes.length; i < this.textViews.size(); ++i) {
            this.configRoot.create("TextView");
        }
        viewNodes = this.configRoot.fetch("TextView");
        for (i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).bindConfig(viewNodes[i]);
        }
        if (this.textViews.size() > 0) {
            this.setFont(((TextView)this.textViews.firstElement()).getFont());
        }
        this.loadDividerLocationsFromConfig();
        this.loadDividerLocations();
    }

    public String getFace() {
        return this.getFont().getName();
    }

    public int getPoints() {
        return this.getFont().getSize();
    }

    public int getStyle() {
        return this.getFont().getStyle();
    }

    public void setFace(String string) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setFace(string);
        }
        if (this.textViews.size() > 0) {
            this.setFont(((TextView)this.textViews.firstElement()).getFont());
        }
        this.repaint();
    }

    public void setPoints(int size) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setPoints(size);
        }
        if (this.textViews.size() > 0) {
            this.setFont(((TextView)this.textViews.firstElement()).getFont());
        }
        this.repaint();
    }

    public void setStyle(int style) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setStyle(style);
        }
        if (this.textViews.size() > 0) {
            this.setFont(((TextView)this.textViews.firstElement()).getFont());
        }
        this.repaint();
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setHeaderSummary(headerSummary);
        }
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void saveDividerLocationsToConfig() {
        ConfigNode node = null;
        if (this.configRoot != null) {
            node = this.configRoot.fetchFirst("Dividers");
            if (node == null) {
                node = this.configRoot.create("Dividers");
            }
        } else {
            return;
        }
        for (int i = 0; i < this.numViews - 1; ++i) {
            if (node == null) continue;
            node.setAttribute("Position" + i, this.dividerLocations[i], -1);
        }
    }

    public void saveDividerLocations() {
        Component temp = this.panel.getComponent(0);
        for (int i = 0; i < this.numShown - 1; ++i) {
            this.dividerLocations[i] = ((JSplitPane)temp).getDividerLocation();
            temp = ((JSplitPane)temp).getRightComponent();
        }
    }

    public void loadDividerLocationsFromConfig() {
        ConfigNode node = null;
        if (this.configRoot == null) {
            return;
        }
        node = this.configRoot.fetchFirst("Dividers");
        for (int i = 0; i < this.numViews - 1; ++i) {
            if (node == null) continue;
            this.dividerLocations[i] = node.getAttribute("Position" + i, 50);
        }
    }

    public void loadDividerLocations() {
        this.ignoreDividerChange = true;
        Component temp = this.panel.getComponent(0);
        for (int i = 0; i < this.numShown - 1; ++i) {
            ((JSplitPane)temp).setDividerLocation(this.dividerLocations[i]);
            temp = ((JSplitPane)temp).getRightComponent();
        }
        this.ignoreDividerChange = false;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (!this.ignoreDividerChange && pce.getPropertyName() == "dividerLocation") {
            this.saveDividerLocations();
            this.saveDividerLocationsToConfig();
        }
    }
}

