/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import java.awt.Color;

public class TreeColorer {
    private static int colorInd;
    private static String[][] headers;
    private static HeaderInfo headerInfo;
    private static String[] colornames;
    private static Color[] colors;

    public static void colorUsingHeader(TreeDrawerNode rootNode, HeaderInfo geneHeaderInfo) {
        int index = geneHeaderInfo.getIndex("FGCOLOR");
        if (index < 0) {
            return;
        }
        TreeColorer.colorUsingHeader(rootNode, geneHeaderInfo, index);
    }

    public static final synchronized void colorUsingHeader(TreeDrawerNode root, HeaderInfo h, int ci) {
        colorInd = ci;
        headerInfo = h;
        if (headerInfo == null) {
            return;
        }
        if (colorInd < 0) {
            return;
        }
        if (root == null) {
            return;
        }
        TreeColorer.recursiveColorUsingHeader(root);
    }

    private static final void recursiveColorUsingHeader(TreeDrawerNode node) {
        if (node.isLeaf()) {
            return;
        }
        int index = headerInfo.getHeaderIndex(node.getId());
        if (index < 0) {
            // empty if block
        }
        String[] headers = headerInfo.getHeader(index);
        String color = headers[colorInd];
        node.setColor(TreeColorer.parseColor(color));
        TreeColorer.recursiveColorUsingHeader(node.getLeft());
        TreeColorer.recursiveColorUsingHeader(node.getRight());
    }

    public static final synchronized void colorUsingLeaf(TreeDrawerNode root, HeaderInfo h, int ci) {
        colorInd = ci;
        headerInfo = h;
        if (headerInfo == null) {
            return;
        }
        if (colorInd < 0) {
            return;
        }
        TreeColorer.recursiveColorUsingLeaf(root);
    }

    public static final synchronized void colorize(TreeDrawerNode root, String[][] h, int ci) {
        colorInd = ci;
        headers = h;
        if (headers == null) {
            return;
        }
        if (colorInd < 0) {
            return;
        }
        TreeColorer.recursiveColor(root);
    }

    private static final void recursiveColorUsingLeaf(TreeDrawerNode node) {
        if (node.isLeaf()) {
            node.setColor(TreeColorer.parseColor(headerInfo.getHeader((int)node.getIndex(), colorInd)));
        } else {
            TreeColorer.recursiveColorUsingLeaf(node.getLeft());
            TreeColorer.recursiveColorUsingLeaf(node.getRight());
            TreeColorer.majorityColor(node);
        }
    }

    private static final void recursiveColor(TreeDrawerNode node) {
        if (node.isLeaf()) {
            node.setColor(TreeColorer.parseColor(headers[(int)node.getIndex()][colorInd]));
        } else {
            TreeColorer.recursiveColor(node.getLeft());
            TreeColorer.recursiveColor(node.getRight());
            TreeColorer.majorityColor(node);
        }
    }

    private static final void majorityColor(TreeDrawerNode node) {
        int[] count = new int[100];
        int min = (int)node.getMinIndex();
        int max = (int)node.getMaxIndex();
        for (int i = min; i < max; ++i) {
            int index;
            String color = headers == null ? headerInfo.getHeader(i, colorInd) : headers[i][colorInd];
            int n = index = TreeColorer.getIndex(color);
            count[n] = count[n] + 1;
        }
        int maxI = 0;
        int i = 0;
        while (colornames[i] != null) {
            if (count[i] > count[maxI]) {
                maxI = i;
            }
            ++i;
        }
        node.setColor(colors[maxI]);
    }

    public static Color getColor(String color) {
        return colors[TreeColorer.getIndex(color)];
    }

    private static int getIndex(String color) {
        int i;
        for (i = 0; i < colornames.length && colornames[i] != null; ++i) {
            if (!colornames[i].equals(color)) continue;
            return i;
        }
        TreeColorer.colornames[i] = color;
        TreeColorer.colors[i] = TreeColorer.parseColor(colornames[i]);
        return i;
    }

    private static final Color synthesizeColor(TreeDrawerNode left, TreeDrawerNode right) {
        if (left.getColor().equals(right.getColor())) {
            return left.getColor();
        }
        return Color.black;
    }

    private static final Color parseColor(String colorString) {
        try {
            return Color.decode(colorString);
        }
        catch (Exception e) {
            return Color.gray;
        }
    }

    static {
        colornames = new String[100];
        colors = new Color[100];
    }
}

