/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.KnnViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.KnnViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TreeViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.TreeView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiclusterView
extends TreeView {
    public static String SHORTNAME = "biclusterview";
    public static String NAME = "JTree BiclusterView (unclustered)";
    protected ViewFrame viewFrame = null;
    protected TreeSelectionI geneSelection = null;
    protected TreeSelectionI arraySelection = null;
    protected TreeViewModel dataModel = null;
    protected CyNetworkView myView = null;
    protected TaskMonitor monitor = null;
    protected ClusterManager manager = null;
    protected CyNetworkTableManager networkTableManager = null;
    protected CyTableManager tableManager = null;
    protected CyTableFactory tableFactory = null;
    protected String clusterAttribute = null;
    List<String> rowList;
    List<String> colList;
    @Tunable(description="Network to view bicluster heatmap for", context="nogui")
    public CyNetwork myNetwork = null;
    private static String appName = "clusterMaker BiclusterView";

    public BiclusterView(ClusterManager manager) {
        super(manager);
        this.manager = manager;
        this.networkTableManager = manager.getService(CyNetworkTableManager.class);
        this.tableManager = manager.getTableManager();
        this.tableFactory = manager.getTableFactory();
        if (this.myNetwork == null) {
            this.myNetwork = manager.getNetwork();
        }
        this.clusterAttribute = (String)this.myNetwork.getRow((CyIdentifiable)this.myNetwork, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
    }

    public BiclusterView(PropertyConfig propConfig) {
        super(propConfig);
    }

    @Override
    public void setVisible(boolean visibility) {
        if (this.viewFrame != null) {
            this.viewFrame.setVisible(visibility);
        }
    }

    @Override
    public String getAppName() {
        return appName;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public ClusterResults getResults() {
        return null;
    }

    @Override
    public void run(TaskMonitor monitor) {
        monitor.setTitle("Creating heat map");
        this.myView = this.manager.getNetworkView();
        this.monitor = monitor;
        if (this.isAvailable()) {
            this.startup();
        } else {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No compatible cluster results available");
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public boolean isAvailable(CyNetwork network) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    protected void startup() {
        CyProperty cyProperty = this.manager.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Map<Integer, List<String>> clusterNodes = this.getBiclusterNodes();
        Map<Integer, List<String>> clusterAttrs = this.getBiclusterAttributes();
        ArrayList<String> nodeArrayL = new ArrayList<String>();
        for (Integer key : clusterNodes.keySet()) {
            List<String> bicluster = clusterNodes.get(key);
            for (String node : bicluster) {
                nodeArrayL.add(node);
            }
        }
        ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__nodeOrder", nodeArrayL, List.class, String.class);
        ArrayList<String> attrArrayL = new ArrayList<String>();
        for (Integer key : clusterAttrs.keySet()) {
            List<String> bicluster = clusterAttrs.get(key);
            for (String attr : bicluster) {
                attrArrayL.add(attr);
            }
        }
        ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__arrayOrder", attrArrayL, List.class, String.class);
        this.dataModel = new KnnViewModel(this.monitor, this.myNetwork, this.myView, this.manager);
        this.setConfigDefaults(new PropertyConfig((CyProperty<Properties>)cyProperty, BiclusterView.globalConfigName(), "ProgramConfig"));
        PropertyConfig documentConfig = new PropertyConfig((CyProperty<Properties>)cyProperty, this.getShortName(), "DocumentConfig");
        this.dataModel.setDocumentConfig(documentConfig);
        KnnViewFrame frame = new KnnViewFrame(this, appName);
        frame.setDataModel(this.dataModel);
        frame.setLoaded(true);
        frame.addWindowListener(this);
        frame.setVisible(true);
        this.geneSelection = frame.getGeneSelection();
        this.geneSelection.addObserver(this);
        this.arraySelection = frame.getArraySelection();
        this.arraySelection.addObserver(this);
        this.manager.registerService(this, RowsSetListener.class, new Properties());
    }

    public void mergeBiclusters(Map<Integer, List<String>> clusterNodes, Map<Integer, List<String>> clusterAttrs) {
        HashMap<Integer, Integer> biclusterSizes = new HashMap<Integer, Integer>();
        for (Integer key : clusterNodes.keySet()) {
            biclusterSizes.put(key, clusterNodes.get(key).size());
        }
        LinkedList templist = new LinkedList(biclusterSizes.entrySet());
        Collections.sort(templist, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.rowList = new ArrayList<String>();
        this.colList = new ArrayList<String>();
        ArrayList rowPrev = new ArrayList();
        ArrayList colPrev = new ArrayList();
        boolean initial = true;
        for (Map.Entry entry : templist) {
            int clust = (Integer)entry.getKey();
            if (initial) {
                rowPrev.addAll(clusterNodes.get(clust));
                colPrev.addAll(clusterAttrs.get(clust));
                initial = false;
                continue;
            }
            ArrayList rowNew = new ArrayList();
            ArrayList colNew = new ArrayList();
            rowNew.addAll(clusterNodes.get(clust));
            colNew.addAll(clusterAttrs.get(clust));
            ArrayList rowOverlap = new ArrayList(rowPrev);
            rowOverlap.retainAll(rowNew);
            rowPrev.removeAll(rowOverlap);
            Collections.sort(rowPrev);
            this.rowList.addAll(rowPrev);
            Collections.sort(rowOverlap);
            this.rowList.addAll(rowOverlap);
            ArrayList colOverlap = new ArrayList(colPrev);
            colOverlap.retainAll(colNew);
            colPrev.removeAll(colOverlap);
            Collections.sort(colPrev);
            this.colList.addAll(colPrev);
            Collections.sort(colOverlap);
            this.colList.addAll(colOverlap);
            rowNew.removeAll(rowOverlap);
            colNew.removeAll(colOverlap);
            rowPrev = rowNew;
            colPrev = colNew;
        }
        Collections.sort(rowPrev);
        this.rowList.addAll(rowPrev);
        Collections.sort(colPrev);
        this.colList.addAll(colPrev);
    }

    public Map<Integer, List<String>> getBiclusterNodes() {
        long BiClusterTableSUID = (Long)this.myNetwork.getRow((CyIdentifiable)this.myNetwork).get(this.clusterAttribute + "_NodeTable.SUID", Long.class);
        CyTable BiClusterNodeTable = this.tableManager.getTable(BiClusterTableSUID);
        HashMap<Integer, List<String>> clusterNodes = new HashMap<Integer, List<String>>();
        int numNodes = BiClusterNodeTable.getRowCount();
        List nodeList = this.myNetwork.getNodeList();
        for (CyNode node : nodeList) {
            CyRow nodeRow = BiClusterNodeTable.getRow((Object)node.getSUID());
            List temp = (List)nodeRow.get("Bicluster List", List.class);
            if (temp == null) continue;
            for (Integer biclust : temp) {
                if (clusterNodes.containsKey(biclust)) {
                    ((List)clusterNodes.get(biclust)).add(ModelUtils.getName(this.myNetwork, (CyIdentifiable)node));
                    continue;
                }
                ArrayList<String> newlist = new ArrayList<String>();
                newlist.add(ModelUtils.getName(this.myNetwork, (CyIdentifiable)node));
                clusterNodes.put(biclust, newlist);
            }
        }
        return clusterNodes;
    }

    public Map<Integer, List<String>> getBiclusterAttributes() {
        long BiClusterTableSUID = (Long)this.myNetwork.getRow((CyIdentifiable)this.myNetwork).get(this.clusterAttribute + "_AttrTable.SUID", Long.class);
        CyTable BiClusterAttrTable = this.tableManager.getTable(BiClusterTableSUID);
        HashMap<Integer, List<String>> clusterAttrs = new HashMap<Integer, List<String>>();
        int numClust = BiClusterAttrTable.getRowCount();
        List tableRows = BiClusterAttrTable.getAllRows();
        for (CyRow row : tableRows) {
            clusterAttrs.put((Integer)row.get("BiCluster Number", Integer.class), (List<String>)row.get("Bicluster Attribute List", List.class));
        }
        return clusterAttrs;
    }
}

