/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.ThresholdHeuristic;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.HistoChangeListener;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.Histogram;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HistogramDialog
extends JDialog
implements ActionListener,
ComponentListener,
HistoChangeListener {
    double[] inputArray;
    int nBins;
    int currentBins;
    Histogram histo;
    JPanel mainPanel;
    JPanel buttonBox;
    JScrollPane scrollPanel;
    JButton zoomOutButton;
    boolean isZoomed = false;
    List<HistoChangeListener> changeListenerList = null;
    double cutOff = -1.0;
    ThresholdHeuristic thueristic = null;

    public HistogramDialog(Window parent, String title, double[] inputArray, int nBins, ThresholdHeuristic thueristic) {
        super(parent);
        this.inputArray = inputArray;
        this.nBins = nBins;
        this.currentBins = nBins;
        this.changeListenerList = new ArrayList<HistoChangeListener>();
        this.thueristic = thueristic;
        this.setTitle(title);
        this.initializeOnce();
    }

    public void updateData(double[] inputArray) {
        this.inputArray = inputArray;
        if (this.histo != null) {
            this.histo.updateData(inputArray);
        }
    }

    public void setLineValue(double cutOffValue) {
        this.cutOff = cutOffValue;
        if (this.histo != null) {
            this.histo.setLineValue(cutOffValue);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("set")) {
            this.histo.setBoolShowLine(true);
        }
        if (e.getActionCommand().equals("close")) {
            this.dispose();
        }
        if (e.getActionCommand().equals("C")) {
            // empty if block
        }
        if (e.getActionCommand().equals("zoom")) {
            this.currentBins *= 2;
            this.isZoomed = true;
            this.zoom(this.inputArray, false);
            this.zoomOutButton.setEnabled(true);
        }
        if (e.getActionCommand().equals("zoomOut")) {
            this.currentBins /= 2;
            if (this.currentBins == this.nBins) {
                this.isZoomed = false;
                this.zoomOutButton.setEnabled(false);
            }
            this.zoom(this.inputArray, true);
        }
        if (e.getActionCommand().equals("cuttoffHeuristic")) {
            this.cutOff = this.thueristic.run();
            if (this.cutOff > -1000.0) {
                this.histoValueChanged(this.cutOff);
                this.histo.setBoolShowLine(true);
                this.histo.setLineValue(this.cutOff);
            }
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Dimension dim = e.getComponent().getSize();
        if (!this.isZoomed) {
            this.histo.setPreferredSize(new Dimension(dim.width - 10, dim.height));
        } else {
            Dimension histoSize = this.histo.getSize();
            this.histo.setPreferredSize(new Dimension(histoSize.width, dim.height));
            this.histo.repaint();
            this.scrollPanel.setPreferredSize(new Dimension(dim.width, dim.height));
        }
    }

    private void initializeOnce() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.addComponentListener(this);
        this.histo = new Histogram(this.inputArray, this.nBins);
        this.histo.addHistoChangeListener(this);
        this.scrollPanel = new JScrollPane(this.histo, 21, 30);
        this.mainPanel.add(this.scrollPanel);
        this.buttonBox = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        closeButton.setActionCommand("close");
        JButton okButton = new JButton("Set Cutoff");
        okButton.addActionListener(this);
        okButton.setActionCommand("set");
        JButton convertButton = new JButton("Select Cutoff Heuristically");
        convertButton.addActionListener(this);
        convertButton.setActionCommand("cuttoffHeuristic");
        JButton zoomButton = new JButton("Zoom In");
        zoomButton.addActionListener(this);
        zoomButton.setActionCommand("zoom");
        this.zoomOutButton = new JButton("Zoom Out");
        this.zoomOutButton.addActionListener(this);
        this.zoomOutButton.setActionCommand("zoomOut");
        this.zoomOutButton.setEnabled(false);
        this.buttonBox.add(okButton);
        this.buttonBox.add(closeButton);
        this.buttonBox.add(zoomButton);
        this.buttonBox.add(this.zoomOutButton);
        this.buttonBox.add(convertButton);
        this.buttonBox.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension buttonDim = this.buttonBox.getPreferredSize();
        this.buttonBox.setMinimumSize(buttonDim);
        this.buttonBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, buttonDim.height));
        this.mainPanel.add(this.buttonBox);
        this.setContentPane(this.mainPanel);
        this.setDefaultCloseOperation(2);
    }

    public void addHistoChangeListener(HistoChangeListener h) {
        if (this.changeListenerList.contains(h)) {
            return;
        }
        this.changeListenerList.add(h);
    }

    public void removeHistoChangeListener(HistoChangeListener h) {
        this.changeListenerList.remove(h);
    }

    public void histoValueChanged(double bounds) {
        if (this.changeListenerList.size() == 0) {
            return;
        }
        this.cutOff = bounds;
        for (HistoChangeListener listener : this.changeListenerList) {
            listener.histoValueChanged(bounds);
        }
    }

    private void zoom(double[] inputArray, boolean zoomOut) {
        Dimension histoDim = this.histo.getSize();
        int histoWidth = zoomOut ? histoDim.width / 2 : histoDim.width * 2;
        Dimension dim = this.scrollPanel.getSize();
        if (this.isZoomed) {
            this.histo.setPreferredSize(new Dimension(histoWidth, histoDim.height));
        } else {
            this.histo.setPreferredSize(new Dimension(dim.width, dim.height));
        }
        this.histo.revalidate();
        if (this.cutOff != -1.0) {
            this.histo.setLineValue(this.cutOff);
        }
    }
}

