/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ViewUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkColorDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ChangeListener,
WindowListener {
    private ColorExtractor colorExtractor = null;
    private ViewFrame viewFrame = null;
    private String attribute = null;
    private List<String> attributeList = null;
    private double maxValue;
    private double minValue;
    protected String currentAttribute = null;
    protected VisualStyle[] styles = null;
    private JLabel titleLabel;
    private JPanel mainPanel;
    protected JList attributeSelector;
    protected JSlider animationSlider;
    private JButton animateButton;
    private JButton nodeChartButton = null;
    private ClusterManager clusterManager = null;
    private TaskManager taskManager = null;
    private boolean animating = false;
    private boolean listening = true;

    public NetworkColorDialog(JFrame parent, ColorExtractor ce, List<String> attributes, ViewFrame viewFrame, ClusterManager clusterManager, double minValue, double maxValue, boolean symmetric) {
        super(parent, "Map Colors to Network", false);
        this.colorExtractor = ce;
        this.attributeList = attributes;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.viewFrame = viewFrame;
        this.clusterManager = clusterManager;
        this.taskManager = clusterManager.getService(TaskManager.class);
        if (symmetric) {
            CyNetwork network = clusterManager.getNetwork();
            if (!ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__clusterEdgeWeight")) {
                return;
            }
            MapTask task = new MapTask(this.attribute.substring(5), "-heatMap", true);
            this.taskManager.execute(new TaskIterator(new Task[]{task}));
            return;
        }
        if (this.attributeList.size() == 1) {
            MapTask task = new MapTask(this.attributeList.get(0), "-heatMap", false);
            this.taskManager.execute(new TaskIterator(new Task[]{task}));
            return;
        }
        this.initializeOnce();
        this.pack();
        this.setVisible(true);
        this.addWindowListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("done")) {
            this.animating = false;
            this.setVisible(false);
        } else if (command.equals("up")) {
            this.shiftList(-1);
        } else if (command.equals("down")) {
            this.shiftList(1);
        } else if (command.equals("vizmap")) {
            String attribute = (String)this.attributeSelector.getSelectedValue();
            MapTask task = new MapTask(attribute, "-heatMap", false);
            this.taskManager.execute(new TaskIterator(new Task[]{task}));
        } else if (command.equals("animate")) {
            if (this.animating) {
                this.animating = false;
                this.animateButton.setText("Animate Vizmap");
                return;
            }
            Object[] attributeArray = this.attributeSelector.getSelectedValues();
            if (attributeArray.length < 2) {
                MapTask task = new MapTask((String)attributeArray[0], "-heatMap", false);
                this.taskManager.execute(new TaskIterator(new Task[]{task}));
                return;
            }
            if (this.currentAttribute == null) {
                this.styles = new VisualStyle[attributeArray.length];
                for (int i = 0; i < attributeArray.length; ++i) {
                    this.styles[i] = this.createNewStyle((String)attributeArray[i], "-" + (String)attributeArray[i], false, false);
                }
            }
            this.animateButton.setText("Stop animation");
            this.animating = true;
            Animate a = new Animate(this.styles, attributeArray);
            a.start();
        } else if (command.equals("heatstrip")) {
            VisualLexicon currentLexicon;
            VisualProperty customGraphicsVP;
            Object[] attributeArray = this.attributeSelector.getSelectedValues();
            String heatstrip = "heatstripchart: separation=\"1\" attributelist=\"";
            for (Object attr : attributeArray) {
                heatstrip = heatstrip + attr.toString() + ",";
            }
            heatstrip = heatstrip.substring(0, heatstrip.length() - 1);
            String colorSpec = this.getColorSpec();
            heatstrip = heatstrip + "\" colorlist=\"" + colorSpec + "\" position=south showlabels=false size=30x60\"";
            CyNetwork net = this.clusterManager.getNetwork();
            String columnName = "clusterMaker-heatStrip";
            CyTable nodeTable = net.getDefaultNodeTable();
            if (nodeTable.getColumn(columnName) == null) {
                nodeTable.createColumn(columnName, String.class, false);
            }
            for (CyNode node : net.getNodeList()) {
                nodeTable.getRow((Object)node.getSUID()).set(columnName, (Object)heatstrip);
            }
            VisualStyle style = ViewUtils.getCurrentVisualStyle(this.clusterManager);
            if (!style.getTitle().endsWith("-heatStrip")) {
                style = ViewUtils.copyStyle(this.clusterManager, style, "-heatStrip");
            }
            if ((customGraphicsVP = (currentLexicon = this.clusterManager.getService(RenderingEngineManager.class).getDefaultVisualLexicon()).lookup(CyNode.class, "NODE_CUSTOMGRAPHICS_1")) == null) {
                System.err.println("couldn't get NODE CUSTOM GRAPHICS");
            }
            VisualMappingFunctionFactory vmff = this.clusterManager.getService(VisualMappingFunctionFactory.class, "(mapping.type=passthrough)");
            PassthroughMapping map = (PassthroughMapping)vmff.createVisualMappingFunction(columnName, String.class, customGraphicsVP);
            style.addVisualMappingFunction((VisualMappingFunction)map);
            ViewUtils.setVisualStyle(this.clusterManager, this.clusterManager.getNetworkView(), style);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.animating = false;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private VisualStyle createNewStyle(String attribute, String suffix, boolean update, boolean edge) {
        VisualProperty property;
        CyColumn column;
        boolean newStyle = false;
        VisualMappingManager vmm = this.clusterManager.getService(VisualMappingManager.class);
        VisualStyle style = ViewUtils.getCurrentVisualStyle(this.clusterManager);
        Color missingColor = this.colorExtractor.getMissing();
        CyNetwork network = this.clusterManager.getNetwork();
        if (edge) {
            column = network.getDefaultEdgeTable().getColumn(attribute);
            property = BasicVisualLexicon.EDGE_PAINT;
        } else {
            column = network.getDefaultNodeTable().getColumn(attribute);
            property = BasicVisualLexicon.NODE_FILL_COLOR;
        }
        if (column == null) {
            return null;
        }
        Class type = column.getType();
        if (!style.getTitle().endsWith(suffix)) {
            style = ViewUtils.copyStyle(this.clusterManager, style, suffix);
            newStyle = true;
        }
        VisualMappingFunctionFactory vmff = this.clusterManager.getService(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
        ContinuousMapping colorMapping = (ContinuousMapping)vmff.createVisualMappingFunction(attribute, type, property);
        double minStep = this.minValue / 5.0;
        for (int i = 0; i < 5; ++i) {
            Color color = this.colorExtractor.getColor(this.minValue - minStep * (double)i);
            colorMapping.addPoint((Object)(this.minValue - minStep * (double)i), new BoundaryRangeValues((Object)color, (Object)color, (Object)color));
        }
        Color color = this.colorExtractor.getColor(0.0);
        colorMapping.addPoint((Object)Float.valueOf(0.0f), new BoundaryRangeValues((Object)color, (Object)color, (Object)color));
        double maxStep = this.maxValue / 5.0;
        for (int i = 1; i <= 5; ++i) {
            Color color2 = this.colorExtractor.getColor(maxStep * (double)i);
            colorMapping.addPoint((Object)(maxStep * (double)i), new BoundaryRangeValues((Object)color2, (Object)color2, (Object)color2));
        }
        style.addVisualMappingFunction((VisualMappingFunction)colorMapping);
        if (update) {
            ViewUtils.setVisualStyle(this.clusterManager, this.clusterManager.getNetworkView(), style);
        }
        return style;
    }

    private void initializeOnce() {
        boolean enableAnimation = false;
        this.setDefaultCloseOperation(1);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        if (this.attributeList.size() > 1) {
            enableAnimation = true;
        }
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 2));
        this.attributeSelector = new JList<Object>(this.attributeList.toArray());
        this.attributeSelector.setSelectionMode(2);
        this.attributeSelector.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.attributeSelector);
        listScroller.setPreferredSize(new Dimension(200, 100));
        listPanel.add(listScroller);
        Border listBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(listBorder, "Attribute List");
        titleBorder.setTitlePosition(1);
        titleBorder.setTitlePosition(2);
        listPanel.setBorder(titleBorder);
        JPanel sortPanel = new JPanel();
        sortPanel.setLayout(new BoxLayout(sortPanel, 3));
        JButton upButton = new JButton("^");
        upButton.setActionCommand("up");
        upButton.addActionListener(this);
        sortPanel.add(upButton);
        JButton downButton = new JButton("v");
        downButton.setActionCommand("down");
        downButton.addActionListener(this);
        sortPanel.add(downButton);
        listPanel.add(sortPanel);
        this.mainPanel.add(listPanel);
        JPanel sliderBox = new JPanel();
        Border sliderBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder tSliderBorder = BorderFactory.createTitledBorder(sliderBorder, "Animation Speed");
        tSliderBorder.setTitlePosition(1);
        tSliderBorder.setTitlePosition(2);
        sliderBox.setBorder(tSliderBorder);
        this.animationSlider = new JSlider(0, 100);
        this.animationSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(new Integer(1), new JLabel("Slower"));
        labels.put(new Integer(100), new JLabel("Faster"));
        this.animationSlider.setLabelTable(labels);
        this.animationSlider.setPaintLabels(true);
        this.animationSlider.setEnabled(false);
        sliderBox.add(this.animationSlider);
        JPanel buttonBox = new JPanel();
        JButton doneButton = new JButton("Done");
        doneButton.setActionCommand("done");
        doneButton.addActionListener(this);
        JButton vizmapButton = new JButton("Create Vizmap");
        vizmapButton.setActionCommand("vizmap");
        vizmapButton.addActionListener(this);
        this.animateButton = new JButton("Animate Vizmap");
        this.animateButton.setActionCommand("animate");
        this.animateButton.addActionListener(this);
        this.animateButton.setEnabled(false);
        this.nodeChartButton = new JButton("Create HeatStrips");
        this.nodeChartButton.setActionCommand("heatstrip");
        this.nodeChartButton.addActionListener(this);
        this.nodeChartButton.setEnabled(false);
        buttonBox.add(this.nodeChartButton);
        buttonBox.add(this.animateButton);
        buttonBox.add(vizmapButton);
        buttonBox.add(doneButton);
        buttonBox.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension buttonDim = buttonBox.getPreferredSize();
        buttonBox.setMinimumSize(buttonDim);
        buttonBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, buttonDim.height));
        this.animationSlider.setPreferredSize(buttonDim);
        sliderBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, buttonDim.height));
        this.mainPanel.add(sliderBox);
        this.mainPanel.add(buttonBox);
        this.setContentPane(this.mainPanel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selIndices = this.attributeSelector.getSelectedIndices();
        if (!this.listening) {
            return;
        }
        this.currentAttribute = null;
        if (selIndices.length > 1) {
            this.animateButton.setEnabled(true);
            this.animationSlider.setEnabled(true);
            if (this.nodeChartButton != null) {
                this.nodeChartButton.setEnabled(true);
            }
        } else {
            this.animateButton.setEnabled(false);
            this.animationSlider.setEnabled(false);
            if (this.nodeChartButton != null) {
                this.nodeChartButton.setEnabled(false);
            }
        }
    }

    public void shiftList(int amount) {
        int i;
        int[] selIndices = this.attributeSelector.getSelectedIndices();
        String[] removedValues = new String[selIndices.length];
        for (i = 0; i < selIndices.length; ++i) {
            removedValues[i] = this.attributeList.get(selIndices[i]);
        }
        for (i = 0; i < selIndices.length; ++i) {
            this.attributeList.remove(removedValues[i]);
            int n = i;
            selIndices[n] = selIndices[n] + amount;
            if (selIndices[i] < 0) {
                selIndices[i] = 0;
            }
            if (selIndices[i] <= this.attributeList.size()) continue;
            selIndices[i] = this.attributeList.size();
        }
        for (i = 0; i < selIndices.length; ++i) {
            this.attributeList.add(selIndices[i], removedValues[i]);
        }
        this.attributeSelector.setListData(this.attributeList.toArray());
        this.attributeSelector.setSelectedIndices(selIndices);
        this.currentAttribute = null;
    }

    private String getColorSpec() {
        Color downColor = this.colorExtractor.getColor(this.minValue);
        Color upColor = this.colorExtractor.getColor(this.maxValue);
        Color zeroColor = this.colorExtractor.getColor(0.0);
        return "up:#" + this.colorToHex(upColor) + ",zero:#" + this.colorToHex(zeroColor) + ",down:#" + this.colorToHex(downColor);
    }

    private String colorToHex(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }

    private class MapTask
    implements Task {
        TaskMonitor monitor;
        String attribute;
        String suffix;
        boolean edge;

        public MapTask(String attribute, String suffix, boolean edge) {
            this.attribute = attribute;
            this.suffix = suffix;
            this.edge = edge;
        }

        public void run(TaskMonitor monitor) {
            NetworkColorDialog.this.createNewStyle(this.attribute, this.suffix, true, this.edge);
        }

        public void cancel() {
        }
    }

    private class Animate
    extends Thread {
        VisualStyle[] styles;
        Object[] attributes;
        String current;

        public Animate(VisualStyle[] styles, Object[] attributes) {
            this.styles = styles;
            this.attributes = attributes;
        }

        public void run() {
            int firstIndex = 0;
            NetworkColorDialog.this.listening = false;
            TreeSelectionI arraySelection = NetworkColorDialog.this.viewFrame.getArraySelection();
            DataModel dataModel = NetworkColorDialog.this.viewFrame.getDataModel();
            HeaderInfo arrayInfo = dataModel.getArrayHeaderInfo();
            int[] selectedAttributes = arraySelection.getSelectedIndexes();
            arraySelection.deselectAllIndexes();
            arraySelection.notifyObservers(Boolean.TRUE);
            try {
                int i;
                NetworkColorDialog.this.attributeSelector.clearSelection();
                if (NetworkColorDialog.this.currentAttribute != null) {
                    for (i = 0; i < this.attributes.length; ++i) {
                        if (!NetworkColorDialog.this.currentAttribute.equals((String)this.attributes[i])) continue;
                        firstIndex = i;
                        break;
                    }
                }
                while (NetworkColorDialog.this.animating) {
                    for (i = firstIndex; i < this.styles.length && NetworkColorDialog.this.animating; ++i) {
                        ViewUtils.setVisualStyle(NetworkColorDialog.this.clusterManager, NetworkColorDialog.this.clusterManager.getNetworkView(), this.styles[i]);
                        NetworkColorDialog.this.attributeSelector.setSelectedValue(this.attributes[i], true);
                        NetworkColorDialog.this.currentAttribute = (String)this.attributes[i];
                        int arrayIndex = arrayInfo.getHeaderIndex(NetworkColorDialog.this.currentAttribute);
                        NetworkColorDialog.this.viewFrame.seekArray(arrayIndex);
                        int wait = NetworkColorDialog.this.animationSlider.getValue();
                        Animate.sleep((100 - wait) * 20);
                    }
                    firstIndex = 0;
                }
                int[] selectedIndices = new int[this.attributes.length];
                int selIndex = 0;
                for (int index = 0; index < this.attributes.length; ++index) {
                    selectedIndices[selIndex++] = NetworkColorDialog.this.attributeList.indexOf(this.attributes[index]);
                }
                NetworkColorDialog.this.attributeSelector.setSelectedIndices(selectedIndices);
            }
            catch (Exception e) {
                // empty catch block
            }
            NetworkColorDialog.this.listening = true;
            arraySelection.deselectAllIndexes();
            for (int index : selectedAttributes) {
                arraySelection.setIndex(index, true);
            }
            arraySelection.notifyObservers(Boolean.FALSE);
        }
    }
}

