/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterVizFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NetworkSelectionLinker;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.ResultsPanel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManagerImpl
implements ClusterManager {
    CyApplicationManager appMgr;
    CyServiceRegistrar serviceRegistrar;
    CyGroupFactory groupFactory;
    CyGroupManager groupMgr;
    Map<String, ClusterTaskFactory> algMap;
    Map<String, ClusterVizFactory> vizMap;
    CyTableFactory tableFactory;
    CyTableManager tableManager;
    Map<CyRootNetwork, NetworkSelectionLinker> linkedNetworks;
    double networkClusterIndex = 50.0;
    double attributeClusterIndex = 1.0;
    double filterIndex = 100.0;
    double vizClusterIndex = 1.0;
    ResultsPanel resultsPanel;

    public ClusterManagerImpl(CyApplicationManager appMgr, CyServiceRegistrar serviceRegistrar, CyGroupFactory groupFactory, CyGroupManager groupMgr, CyTableFactory tableFactory, CyTableManager tableManager) {
        this.appMgr = appMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.groupFactory = groupFactory;
        this.groupMgr = groupMgr;
        this.algMap = new HashMap<String, ClusterTaskFactory>();
        this.vizMap = new HashMap<String, ClusterVizFactory>();
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.linkedNetworks = new HashMap<CyRootNetwork, NetworkSelectionLinker>();
    }

    @Override
    public Collection<ClusterTaskFactory> getAllAlgorithms() {
        return this.algMap.values();
    }

    @Override
    public ClusterTaskFactory getAlgorithm(String name) {
        if (this.algMap.containsKey(name)) {
            return this.algMap.get(name);
        }
        return null;
    }

    public void addClusterAlgorithm(ClusterTaskFactory alg, Map props) {
        this.addAlgorithm(alg);
    }

    @Override
    public void addAlgorithm(ClusterTaskFactory alg) {
        this.algMap.put(alg.getShortName(), alg);
        List<ClusterTaskFactory.ClusterType> clusterTypes = alg.getTypeList();
        for (ClusterTaskFactory.ClusterType type : clusterTypes) {
            Properties props = new Properties();
            props.setProperty("command", alg.getShortName());
            props.setProperty("commandNamespace", "cluster");
            props.setProperty("inMenuBar", "true");
            props.setProperty("title", alg.getName());
            props.setProperty("preferredMenu", "Apps.clusterMaker");
            switch (type) {
                case NETWORK: {
                    this.networkClusterIndex += 1.0;
                    props.setProperty("menuGravity", "" + this.networkClusterIndex);
                    break;
                }
                case ATTRIBUTE: {
                    this.attributeClusterIndex += 1.0;
                    props.setProperty("menuGravity", "" + this.attributeClusterIndex);
                    break;
                }
                case FILTER: {
                    this.filterIndex += 1.0;
                    props.setProperty("menuGravity", "" + this.filterIndex);
                }
            }
            this.serviceRegistrar.registerService((Object)alg, TaskFactory.class, props);
        }
    }

    public void removeClusterAlgorithm(ClusterTaskFactory alg, Map props) {
        this.removeAlgorithm(alg);
    }

    @Override
    public void removeAlgorithm(ClusterTaskFactory alg) {
        if (this.algMap.containsKey(alg.getName())) {
            this.algMap.remove(alg.getName());
        }
        this.serviceRegistrar.unregisterService((Object)alg, TaskFactory.class);
    }

    @Override
    public Collection<ClusterVizFactory> getAllVisualizers() {
        return this.vizMap.values();
    }

    @Override
    public ClusterVizFactory getVisualizer(String name) {
        if (this.vizMap.containsKey(name)) {
            return this.vizMap.get(name);
        }
        return null;
    }

    @Override
    public void addVisualizer(ClusterVizFactory viz) {
        this.vizMap.put(viz.getName(), viz);
        Properties props = new Properties();
        props.setProperty("command", viz.getName());
        props.setProperty("commandNamespace", "clusterviz");
        props.setProperty("inMenuBar", "true");
        props.setProperty("preferredMenu", "Apps.clusterMaker Visualizations");
        props.setProperty("title", viz.getName());
        this.vizClusterIndex += 1.0;
        props.setProperty("menuGravity", "" + this.vizClusterIndex);
        this.serviceRegistrar.registerService((Object)viz, TaskFactory.class, props);
    }

    public void addClusterVisualizer(ClusterVizFactory viz, Map props) {
        this.addVisualizer(viz);
    }

    @Override
    public void removeVisualizer(ClusterVizFactory viz) {
        if (this.vizMap.containsKey(viz.getName())) {
            this.vizMap.remove(viz.getName());
        }
    }

    public void removeClusterVisualizer(ClusterVizFactory viz, Map props) {
        this.removeVisualizer(viz);
        this.serviceRegistrar.unregisterService((Object)viz, TaskFactory.class);
    }

    @Override
    public CyNetwork getNetwork() {
        return this.appMgr.getCurrentNetwork();
    }

    @Override
    public CyNetworkView getNetworkView() {
        return this.appMgr.getCurrentNetworkView();
    }

    @Override
    public CyTableFactory getTableFactory() {
        return this.tableFactory;
    }

    @Override
    public CyTableManager getTableManager() {
        return this.tableManager;
    }

    @Override
    public CyGroup createGroup(CyNetwork network, String name, List<CyNode> nodeList, List<CyEdge> edgeList, boolean registerGroup) {
        CyGroup group = this.groupFactory.createGroup(network, nodeList, edgeList, registerGroup);
        if (group != null) {
            CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
            rootNetwork.getRow((CyIdentifiable)group.getGroupNode()).set("name", (Object)name);
            rootNetwork.getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS").set("shared name", (Object)name);
        }
        return group;
    }

    @Override
    public void removeGroup(CyNetwork network, Long suid) {
        CyNode node = ((CySubNetwork)network).getRootNetwork().getNode(suid.longValue());
        if (node == null) {
            return;
        }
        CyGroup group = this.groupMgr.getGroup(node, network);
        if (group == null) {
            return;
        }
        if (group.getNetworkSet() != null && group.getNetworkSet().size() > 1) {
            group.removeGroupFromNetwork(network);
            return;
        }
        this.groupMgr.destroyGroup(group);
    }

    @Override
    public ResultsPanel getResultsPanel() {
        return this.resultsPanel;
    }

    @Override
    public void setResultsPanel(ResultsPanel resultsPanel) {
        this.resultsPanel = resultsPanel;
    }

    @Override
    public <T> T getService(Class<? extends T> clazz) {
        return (T)this.serviceRegistrar.getService(clazz);
    }

    @Override
    public <T> T getService(Class<? extends T> clazz, String filter) {
        return (T)this.serviceRegistrar.getService(clazz, filter);
    }

    public void registerService(Object service, Class serviceClass, Properties props) {
        this.serviceRegistrar.registerService(service, serviceClass, props);
    }

    public void unregisterService(Object service, Class serviceClass) {
        this.serviceRegistrar.unregisterService(service, serviceClass);
    }

    public boolean isLinked(CyNetwork network) {
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        return this.linkedNetworks.containsKey(rootNetwork);
    }

    public void linkNetworkSelection(CyNetwork network) {
        if (this.isLinked(network)) {
            return;
        }
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        CyEventHelper helper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        NetworkSelectionLinker linker = new NetworkSelectionLinker(rootNetwork, helper, this);
        this.registerService((Object)linker, (Class)RowsSetListener.class, new Properties());
        this.linkedNetworks.put(rootNetwork, linker);
    }

    public void unlinkNetworkSelection(CyNetwork network) {
        if (!this.isLinked(network)) {
            return;
        }
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        this.unregisterService((Object)this.linkedNetworks.get(rootNetwork), (Class)RowsSetListener.class);
        this.linkedNetworks.remove(rootNetwork);
    }
}

