/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClusterResults
implements ClusterResults {
    private List<List<CyNode>> clusters;
    private CyNetwork network;
    private int clusterCount;
    private double averageSize;
    private int maxSize;
    private int minSize;
    private double clusterCoefficient;
    private List<Double> modularityList;
    private double modularity;
    private String extraText = null;

    public AbstractClusterResults(CyNetwork network, List<List<CyNode>> cl, String extraInformation) {
        this.network = network;
        this.clusters = cl;
        this.extraText = extraInformation;
        this.modularityList = new ArrayList<Double>();
        this.calculate();
    }

    public AbstractClusterResults(CyNetwork network, List<List<CyNode>> cl) {
        this(network, cl, null);
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        String result = "  Clusters: " + this.clusterCount + "\n";
        result = result + "  Average size: " + nf.format(this.averageSize) + "\n";
        result = result + "  Maximum size: " + this.maxSize + "\n";
        result = result + "  Minimum size: " + this.minSize + "\n";
        result = result + "  Modularity: " + nf.format(this.modularity);
        if (this.extraText != null) {
            result = result + "  " + this.extraText;
        }
        return result;
    }

    public String toHTML() {
        NumberFormat nf = NumberFormat.getInstance();
        String result = "<ul style=\"margin-top:0px;margin-bottom:5px;";
        result = result + "padding-left:5px;margin-left:5px;list-style-type:none\">";
        result = result + "<li><b>Clusters:</b> " + this.clusterCount + "</li>";
        result = result + "<li><b>Average size:</b> " + nf.format(this.averageSize) + "</li>";
        result = result + "<li><b>Maximum size:</b> " + this.maxSize + "</li>";
        result = result + "<li><b>Minimum size:</b> " + this.minSize + "</li>";
        result = result + "<li><b>Modularity:</b> " + nf.format(this.modularity) + "</li>";
        if (this.extraText != null) {
            result = result + "<li>" + this.extraText + "</li>";
        }
        result = result + "</ul>";
        return result;
    }

    @Override
    public double getScore() {
        return this.modularity;
    }

    public List<List<CyNode>> getClusters() {
        return this.clusters;
    }

    public List<Double> getModularityList() {
        return this.modularityList;
    }

    @Override
    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.toString();
        }
        return this.clusters;
    }

    private void calculate() {
        this.clusterCount = this.clusters.size();
        this.averageSize = 0.0;
        this.maxSize = -1;
        this.minSize = Integer.MAX_VALUE;
        this.clusterCoefficient = 0.0;
        this.modularity = 0.0;
        double edgeCount = this.getReducedEdgeCount();
        int clusterNumber = 0;
        for (List<CyNode> cluster2 : this.clusters) {
            this.averageSize += (double)cluster2.size() / (double)this.clusterCount;
            this.maxSize = Math.max(this.maxSize, cluster2.size());
            this.minSize = Math.min(this.minSize, cluster2.size());
            double innerEdges = this.getInnerEdgeCount(cluster2);
            double outerEdges = this.getOuterEdgeCount(cluster2);
            this.clusterCoefficient += innerEdges / (innerEdges + outerEdges) / (double)this.clusterCount;
            double proportionEdgesInCluster = innerEdges / edgeCount;
            double proportionEdgesOutCluster = outerEdges / edgeCount;
            double clusterModularity = proportionEdgesInCluster - proportionEdgesOutCluster / 2.0 * (proportionEdgesOutCluster / 2.0);
            this.modularityList.add(clusterModularity);
            this.modularity += clusterModularity;
            ++clusterNumber;
        }
    }

    private int getInnerEdgeCount(List<CyNode> cluster2) {
        return ModelUtils.getConnectingEdges(this.network, cluster2).size();
    }

    private int getOuterEdgeCount(List<CyNode> cluster2) {
        HashSet<CyEdge> innerEdgeSet = new HashSet<CyEdge>(ModelUtils.getConnectingEdges(this.network, cluster2));
        ArrayList<CyEdge> outerEdges = new ArrayList<CyEdge>();
        for (CyNode node : cluster2) {
            for (CyEdge edge : this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY)) {
                if (innerEdgeSet.contains(edge)) continue;
                outerEdges.add(edge);
            }
        }
        return outerEdges.size();
    }

    private double getReducedEdgeCount() {
        int edges = 0;
        for (List<CyNode> cluster2 : this.clusters) {
            for (CyNode node : cluster2) {
                edges += this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY).size();
            }
        }
        return (double)edges / 2.0;
    }
}

