/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeWeightConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceMatrix {
    private String edgeAttributeName = null;
    private double minWeight = Double.MAX_VALUE;
    private double maxWeight = Double.MIN_VALUE;
    private double minAttribute = Double.MAX_VALUE;
    private double maxAttribute = Double.MIN_VALUE;
    private double edgeCutOff = 0.0;
    private boolean unDirectedEdges = false;
    private boolean distanceValues = false;
    private boolean logValues = false;
    private List<CyNode> nodes = null;
    private List<CyEdge> edges = null;
    private DoubleMatrix2D matrix = null;
    private EdgeWeightConverter converter = null;
    private double[] edgeWeights = null;

    public DistanceMatrix(CyNetwork network, String edgeAttributeName, boolean selectedOnly, EdgeWeightConverter converter) {
        double edgeWeight;
        this.edgeAttributeName = edgeAttributeName;
        this.converter = converter;
        if (!selectedOnly) {
            this.nodes = network.getNodeList();
            this.edges = network.getEdgeList();
        } else {
            this.nodes = new ArrayList<CyNode>();
            this.edges = new ArrayList<CyEdge>();
            this.nodes.addAll(CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true));
            this.edges.addAll(this.getConnectingEdges(network, this.nodes));
        }
        CyTable edgeAttributes = network.getDefaultEdgeTable();
        this.edgeWeights = new double[this.edges.size()];
        for (int edgeIndex = 0; edgeIndex < this.edges.size(); ++edgeIndex) {
            CyEdge edge = this.edges.get(edgeIndex);
            this.edgeWeights[edgeIndex] = Double.MIN_VALUE;
            if (edgeAttributes.getColumn(edgeAttributeName) == null) {
                if (!edgeAttributeName.equals("--None--")) continue;
                this.edgeWeights[edgeIndex] = 1.0;
                continue;
            }
            if (edgeAttributes.getRow((Object)edge.getSUID()).getRaw(edgeAttributeName) == null) continue;
            edgeWeight = 0.0;
            if (edgeAttributes.getColumn(edgeAttributeName).getType() == Double.class) {
                edgeWeight = (Double)network.getRow((CyIdentifiable)edge).get(edgeAttributeName, Double.class);
            } else {
                if (edgeAttributes.getColumn(edgeAttributeName).getType() != Integer.class) continue;
                edgeWeight = ((Integer)network.getRow((CyIdentifiable)edge).get(edgeAttributeName, Integer.class)).doubleValue();
            }
            this.minAttribute = Math.min(this.minAttribute, edgeWeight);
            this.maxAttribute = Math.max(this.maxAttribute, edgeWeight);
            this.edgeWeights[edgeIndex] = edgeWeight;
        }
        ArrayList<Integer> edgeCase = new ArrayList<Integer>();
        for (int edgeIndex = 0; edgeIndex < this.edges.size(); ++edgeIndex) {
            edgeWeight = this.edgeWeights[edgeIndex];
            if (edgeWeight == Double.MIN_VALUE) continue;
            if ((edgeWeight = converter.convert(edgeWeight, this.minAttribute, this.maxAttribute)) == Double.MIN_VALUE) {
                edgeCase.add(edgeIndex);
            }
            this.edgeWeights[edgeIndex] = edgeWeight;
            if (edgeWeight == Double.MIN_VALUE) continue;
            this.minWeight = Math.min(this.minWeight, edgeWeight);
            this.maxWeight = Math.max(this.maxWeight, edgeWeight);
        }
        for (Integer index : edgeCase) {
            this.edgeWeights[index.intValue()] = this.maxWeight + this.maxWeight / 10.0;
        }
    }

    public double[] getEdgeValues() {
        return this.edgeWeights;
    }

    public double getEdgeValueFromMatrix(int row, int column) {
        if (this.matrix == null) {
            this.getDistanceMatrix();
        }
        return this.matrix.get(row, column);
    }

    public double scaleValue(double value) {
        if (this.distanceValues) {
            value = value != 0.0 ? 1.0 / value : Double.MAX_VALUE;
        }
        if (this.logValues) {
            if (this.minAttribute < 0.0) {
                value += Math.abs(this.minAttribute);
            }
            value = value != 0.0 && value != Double.MAX_VALUE ? -Math.log10(value) : 500.0;
        }
        return value;
    }

    public boolean hasDistanceValues() {
        return this.distanceValues;
    }

    public boolean hasLogValues() {
        return this.logValues;
    }

    public double getNormalizedValue(double value) {
        double span = this.maxWeight - this.minWeight;
        return (value - this.minWeight) / span;
    }

    public void normalizeMatrix(double factor) {
        if (this.matrix == null) {
            this.getDistanceMatrix();
        }
        this.matrix.forEachNonZero((IntIntDoubleFunction)new Normalize(this.minWeight, this.maxWeight, factor));
    }

    public Map<Integer, List<CyNode>> findConnectedComponents() {
        if (this.matrix == null) {
            this.getDistanceMatrix();
        }
        HashMap<Integer, List<CyNode>> cmap = new HashMap<Integer, List<CyNode>>();
        this.matrix.forEachNonZero((IntIntDoubleFunction)new FindComponents(cmap));
        return cmap;
    }

    public DoubleMatrix2D getDistanceMatrix(Double edgeCutOff, boolean undirectedEdges) {
        this.setEdgeCutOff(edgeCutOff);
        this.setUndirectedEdges(undirectedEdges);
        this.matrix = null;
        return this.getDistanceMatrix();
    }

    public DoubleMatrix2D getDistanceMatrix() {
        if (this.matrix != null) {
            return this.matrix;
        }
        this.matrix = DoubleFactory2D.sparse.make(this.nodes.size(), this.nodes.size());
        for (int edgeIndex = 0; edgeIndex < this.edges.size(); ++edgeIndex) {
            CyEdge edge = this.edges.get(edgeIndex);
            if (this.edgeWeights[edgeIndex] < this.edgeCutOff) continue;
            int sourceIndex = this.nodes.indexOf(edge.getSource());
            int targetIndex = this.nodes.indexOf(edge.getTarget());
            this.matrix.set(targetIndex, sourceIndex, this.edgeWeights[edgeIndex]);
            if (!this.unDirectedEdges) continue;
            this.matrix.set(sourceIndex, targetIndex, this.edgeWeights[edgeIndex]);
        }
        return this.matrix;
    }

    public double getMaxAttribute() {
        return this.maxAttribute;
    }

    public double getMaxWeight() {
        return this.maxWeight;
    }

    public double getMinAttribute() {
        return this.minAttribute;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public List<CyNode> getNodes() {
        return this.nodes;
    }

    public List<CyEdge> getEdges() {
        return this.edges;
    }

    public void setEdgeCutOff(Double edgeCutOff) {
        this.matrix = null;
        this.edgeCutOff = edgeCutOff;
    }

    public void setUndirectedEdges(boolean undirectedEdges) {
        this.matrix = null;
        this.unDirectedEdges = undirectedEdges;
    }

    public void adjustLoops() {
        if (this.matrix == null) {
            this.getDistanceMatrix();
        }
        double[] max = new double[this.matrix.columns()];
        this.matrix.forEachNonZero((IntIntDoubleFunction)new MatrixFindMax(max));
        for (int col = 0; col < this.matrix.columns(); ++col) {
            if (max[col] != 0.0) {
                this.matrix.set(col, col, max[col]);
                continue;
            }
            this.matrix.set(col, col, 1.0);
        }
    }

    public String printMatrixInfo(DoubleMatrix2D m) {
        String s = "Matrix(" + m.rows() + ", " + m.columns() + ")\n";
        s = m.getClass().getName().indexOf("Sparse") >= 0 ? s + " matrix is sparse\n" : s + " matrix is dense\n";
        s = s + " cardinality is " + m.cardinality() + "\n";
        return s;
    }

    public String printMatrix(DoubleMatrix2D m) {
        String s = "";
        for (int row = 0; row < m.rows(); ++row) {
            s = s + this.nodes.get(row).getSUID() + ":\t";
            for (int col = 0; col < m.columns(); ++col) {
                s = s + "" + m.get(row, col) + "\t";
            }
            s = s + "\n";
        }
        return s;
    }

    List<CyEdge> getConnectingEdges(CyNetwork network, List<CyNode> nodes) {
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        for (int rowIndex = 0; rowIndex < nodes.size(); ++rowIndex) {
            for (int colIndex = rowIndex; colIndex < nodes.size(); ++colIndex) {
                List connectingEdges = network.getConnectingEdgeList(nodes.get(rowIndex), nodes.get(colIndex), CyEdge.Type.ANY);
                if (connectingEdges == null) continue;
                edgeList.addAll(connectingEdges);
            }
        }
        return edgeList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindComponents
    implements IntIntDoubleFunction {
        Map<CyNode, Integer> nodeToCluster;
        Map<Integer, List<CyNode>> clusterMap;
        int clusterNumber = 0;

        public FindComponents(Map<Integer, List<CyNode>> cMap) {
            this.clusterMap = cMap;
            this.nodeToCluster = new HashMap<CyNode, Integer>();
        }

        public double apply(int row, int column, double value) {
            if (row == column) {
                return value;
            }
            CyNode node1 = (CyNode)DistanceMatrix.this.nodes.get(row);
            CyNode node2 = (CyNode)DistanceMatrix.this.nodes.get(column);
            if (this.nodeToCluster.containsKey(node1)) {
                if (!this.nodeToCluster.containsKey(node2)) {
                    this.addNodeToCluster(this.nodeToCluster.get(node1), node2);
                } else {
                    this.combineClusters(this.nodeToCluster.get(node1), this.nodeToCluster.get(node2));
                }
            } else if (this.nodeToCluster.containsKey(node2)) {
                this.addNodeToCluster(this.nodeToCluster.get(node2), node1);
            } else {
                this.createCluster(node1, node2);
            }
            return value;
        }

        private void addNodeToCluster(Integer cluster2, CyNode node) {
            List<CyNode> nodeList = this.clusterMap.get(cluster2);
            nodeList.add(node);
            this.nodeToCluster.put(node, cluster2);
        }

        private void createCluster(CyNode node1, CyNode node2) {
            ArrayList nodeList = new ArrayList();
            this.clusterMap.put(this.clusterNumber, nodeList);
            this.addNodeToCluster(this.clusterNumber, node1);
            this.addNodeToCluster(this.clusterNumber, node2);
            ++this.clusterNumber;
        }

        private void combineClusters(Integer cluster1, Integer cluster2) {
            if (cluster1.intValue() == cluster2.intValue()) {
                return;
            }
            List<CyNode> list1 = this.clusterMap.get(cluster1);
            List<CyNode> list2 = this.clusterMap.get(cluster2);
            this.clusterMap.remove(cluster2);
            for (CyNode node : list2) {
                this.nodeToCluster.put(node, cluster1);
            }
            list1.addAll(list2);
        }
    }

    private class Normalize
    implements IntIntDoubleFunction {
        private double maxValue;
        private double minValue;
        private double span;
        private double factor;

        public Normalize(double minValue, double maxValue, double factor) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.factor = factor;
            this.span = maxValue - minValue;
        }

        public double apply(int row, int column, double value) {
            return (value - DistanceMatrix.this.minWeight) / this.span * this.factor;
        }
    }

    private class MatrixFindMax
    implements IntIntDoubleFunction {
        double[] colMax;

        public MatrixFindMax(double[] colMax) {
            this.colMax = colMax;
        }

        public double apply(int row, int column, double value) {
            if (value > this.colMax[column]) {
                this.colMax[column] = value;
            }
            return value;
        }
    }
}

