/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyNodeCluster
extends NodeCluster {
    private HashMap<CyNode, Double> membershipMap = null;
    public static int fuzzyClusterCount = 0;

    public FuzzyNodeCluster() {
        this.clusterNumber = ++fuzzyClusterCount;
    }

    public FuzzyNodeCluster(Collection<CyNode> collection, HashMap<CyNode, Double> clusterMemberships) {
        super(collection);
        this.membershipMap = new HashMap();
        this.clusterNumber = ++fuzzyClusterCount;
        for (CyNode element : clusterMemberships.keySet()) {
            if (!this.contains(element)) continue;
            this.membershipMap.put(element, clusterMemberships.get(element));
        }
    }

    public boolean add(List<CyNode> nodeList, int index, double membershipValue) {
        boolean retval = this.add(nodeList.get(index));
        if (retval) {
            this.membershipMap.put(nodeList.get(index), membershipValue);
        }
        return retval;
    }

    public static void init() {
        fuzzyClusterCount = 0;
        hasScore = false;
    }

    public Object getMembership(CyNode node) {
        return this.membershipMap.get(node);
    }

    public void setMembership(CyNode node, double membership) {
        this.membershipMap.put(node, membership);
    }

    @Override
    public boolean isFuzzy() {
        return true;
    }
}

