/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCluster
extends ArrayList<CyNode> {
    int clusterNumber = ++clusterCount;
    static int clusterCount = 0;
    static boolean hasScore = false;
    protected double score = 0.0;
    private CyNetworkView view;
    private boolean disposed;

    public NodeCluster() {
    }

    public NodeCluster(Collection<CyNode> collection) {
        super(collection);
    }

    public boolean add(List<CyNode> nodeList, int index) {
        return this.add(nodeList.get(index));
    }

    public static void init() {
        clusterCount = 0;
        hasScore = false;
    }

    public static boolean hasScore() {
        return hasScore;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public void setClusterNumber(int clusterNumber) {
        this.clusterNumber = clusterNumber;
    }

    public void setClusterScore(double score) {
        this.score = score;
        hasScore = true;
    }

    public double getClusterScore() {
        return this.score;
    }

    @Override
    public String toString() {
        String str = "(" + this.clusterNumber + ": ";
        for (Object i : this) {
            str = str + i.toString();
        }
        return str + ")";
    }

    public static List<NodeCluster> sortMap(Map<Integer, NodeCluster> map) {
        NodeCluster[] clusterArray = map.values().toArray(new NodeCluster[1]);
        Arrays.sort(clusterArray, new LengthComparator());
        return Arrays.asList(clusterArray);
    }

    public static List<NodeCluster> rankListByScore(List<NodeCluster> list) {
        NodeCluster[] clusterArray = list.toArray(new NodeCluster[1]);
        Arrays.sort(clusterArray, new ScoreComparator());
        for (int rank = 0; rank < clusterArray.length; ++rank) {
            clusterArray[rank].setClusterNumber(rank + 1);
        }
        return Arrays.asList(clusterArray);
    }

    public boolean isFuzzy() {
        return false;
    }

    public CySubNetwork getSubNetwork(CyNetwork net, CyRootNetwork root, SavePolicy policy) {
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        for (CyNode n : this) {
            HashSet adjacentEdges = new HashSet(net.getAdjacentEdgeList(n, CyEdge.Type.ANY));
            for (CyEdge e : adjacentEdges) {
                if (!this.contains(e.getSource()) || !this.contains(e.getTarget())) continue;
                edges.add(e);
            }
        }
        CySubNetwork subNet = root.addSubNetwork((Iterable)this, edges, policy);
        return subNet;
    }

    public synchronized CyNetworkView getView() {
        return this.view;
    }

    public synchronized void setView(CyNetworkView view) {
        this.throwExceptionIfDisposed();
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = view;
    }

    private void throwExceptionIfDisposed() {
        if (this.isDisposed()) {
            throw new RuntimeException("NodeCluster has been disposed and cannot be used anymore: ");
        }
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    static class ScoreComparator
    implements Comparator {
        ScoreComparator() {
        }

        public int compare(Object o1, Object o2) {
            NodeCluster c1 = (NodeCluster)o1;
            NodeCluster c2 = (NodeCluster)o2;
            if (c1.getClusterScore() > c2.getClusterScore()) {
                return -1;
            }
            if (c1.getClusterScore() < c2.getClusterScore()) {
                return 1;
            }
            return 0;
        }
    }

    static class LengthComparator
    implements Comparator {
        LengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            List c1 = (List)o1;
            List c2 = (List)o2;
            if (c1.size() > c2.size()) {
                return -1;
            }
            if (c1.size() < c2.size()) {
                return 1;
            }
            return 0;
        }
    }
}

