/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BiMine;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BiMine.BET;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BiMine.BETNode;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BiMine.BiMineContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunBiMine {
    protected CyNetwork network;
    protected String[] weightAttributes;
    protected BET<Integer> bet;
    protected Matrix matrix;
    protected Matrix matrix_preproc;
    protected Matrix biclusterMatrix;
    protected Double[][] arr;
    protected Double[][] geneRho;
    protected Double[][] conditionRho;
    protected int[] clusters;
    protected TaskMonitor monitor;
    protected boolean ignoreMissing = true;
    protected boolean selectedOnly = false;
    BiMineContext context;
    double delta;
    double alpha;
    protected Map<Integer, List<Long>> clusterNodes;
    protected Map<Integer, List<String>> clusterAttrs;

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Matrix getBiclusterMatrix() {
        return this.biclusterMatrix;
    }

    public int[] getClustersArray() {
        return this.clusters;
    }

    public RunBiMine(CyNetwork network, String[] weightAttributes, TaskMonitor monitor, BiMineContext context) {
        this.network = network;
        this.weightAttributes = weightAttributes;
        this.monitor = monitor;
        this.context = context;
        this.delta = (Double)context.delta.getValue();
        this.alpha = context.alpha;
    }

    public Integer[] cluster(boolean transpose) {
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.ignoreMissing, this.selectedOnly);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "cluster matrix has " + this.matrix.nRows() + " rows");
        this.matrix.setUniformWeights();
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        int nelements = this.matrix.nRows();
        int nattrs = this.matrix.nColumns();
        this.matrix_preproc = new Matrix(this.network, nelements, nattrs);
        this.bet = this.Init_BET();
        List<BETNode<Integer>> biclusters = this.BET_tree();
        int totalRows = 0;
        for (BETNode<Integer> bicluster : biclusters) {
            totalRows += bicluster.getGenes().size();
        }
        this.clusters = new int[totalRows];
        CyNode[] rowNodes = new CyNode[totalRows];
        this.biclusterMatrix = new Matrix(this.network, totalRows, nattrs);
        int i = 0;
        this.clusterNodes = new HashMap<Integer, List<Long>>();
        this.clusterAttrs = new HashMap<Integer, List<String>>();
        for (int k = 0; k < biclusters.size(); ++k) {
            List<Integer> geneList = biclusters.get(k).getGenes();
            List<Integer> conditionList = biclusters.get(k).getConditions();
            ArrayList<Long> nodes = new ArrayList<Long>();
            for (Integer node : geneList) {
                this.biclusterMatrix.setRowLabel(i, this.matrix.getRowLabel(node));
                rowNodes[i] = this.matrix.getRowNode(node);
                for (int j = 0; j < nattrs; ++j) {
                    this.biclusterMatrix.setValue(i, j, this.matrix.getValue(node, j));
                }
                this.clusters[i] = k;
                ++i;
                nodes.add(this.matrix.getRowNode(node).getSUID());
            }
            this.clusterNodes.put(k, nodes);
            ArrayList<String> attrs = new ArrayList<String>();
            for (Integer cond : conditionList) {
                attrs.add(this.matrix.getColLabel(cond));
            }
            this.clusterAttrs.put(k, attrs);
        }
        for (int j = 0; j < nattrs; ++j) {
            this.biclusterMatrix.setColLabel(j, this.matrix.getColLabel(j));
        }
        this.biclusterMatrix.setRowNodes(rowNodes);
        Integer[] rowOrder = this.biclusterMatrix.indexSort(this.clusters, this.clusters.length);
        return rowOrder;
    }

    private BET<Integer> Init_BET() {
        BETNode root = new BETNode();
        int nelements = this.matrix.nRows();
        int nattrs = this.matrix.nColumns();
        for (int i = 0; i < nelements; ++i) {
            ArrayList<Integer> condList = new ArrayList<Integer>();
            ArrayList<Integer> geneList = new ArrayList<Integer>();
            geneList.add(i);
            double avg_i = this.getRowAvg(i);
            for (int j = 0; j < nattrs; ++j) {
                Double value = this.matrix.getValue(i, j);
                if (value == null || avg_i == 0.0) continue;
                if (Math.abs(value - avg_i) / avg_i > this.delta) {
                    condList.add(j);
                    this.matrix_preproc.setValue(i, j, value);
                    continue;
                }
                this.matrix_preproc.setValue(i, j, null);
            }
            BETNode child = new BETNode(geneList, condList);
            root.addChild(child);
        }
        BET<Integer> newBet = new BET<Integer>(root);
        return newBet;
    }

    private List<BETNode<Integer>> BET_tree() {
        BETNode<Integer> node = this.bet.getRoot();
        List<BETNode<Integer>> level = node.getChildren();
        ArrayList<BETNode<Integer>> leaves = new ArrayList<BETNode<Integer>>();
        int levelnum = 1;
        while (level.size() > 0) {
            int levelSize = level.size();
            ArrayList<BETNode<Integer>> nextLevel = new ArrayList<BETNode<Integer>>();
            for (int i = 0; i < levelSize; ++i) {
                BETNode<Integer> node_i = level.get(i);
                List<BETNode<Integer>> uncles = node_i.getParent().getChildren();
                for (int j = uncles.indexOf(node_i) + 1; j < uncles.size(); ++j) {
                    BETNode<Integer> uncle_j = uncles.get(j);
                    List<Integer> childGenes = this.union(node_i.getGenes(), uncle_j.getGenes());
                    List<Integer> childConditions = this.intersection(node_i.getConditions(), uncle_j.getConditions());
                    Collections.sort(childGenes);
                    Collections.sort(childConditions);
                    BETNode<Integer> child_j = new BETNode<Integer>(childGenes, childConditions);
                    double asr = this.getASR(child_j);
                    if (!(asr >= this.alpha)) continue;
                    node_i.addChild(child_j);
                }
                if (node_i.getChildren().size() > 0) {
                    nextLevel.addAll(node_i.getChildren());
                    continue;
                }
                leaves.add(node_i);
            }
            level = nextLevel;
            ++levelnum;
        }
        return this.getBiClusters(leaves);
    }

    private List<BETNode<Integer>> getBiClusters(List<BETNode<Integer>> leaves) {
        Collections.reverse(leaves);
        ArrayList<BETNode<Integer>> biclusters = new ArrayList<BETNode<Integer>>();
        biclusters.add(leaves.get(0));
        for (int i = 1; i < leaves.size(); ++i) {
            BETNode<Integer> leaf = leaves.get(i);
            boolean isSubset = false;
            for (BETNode bETNode : biclusters) {
                if (!bETNode.getGenes().containsAll(leaf.getGenes()) || !bETNode.getConditions().containsAll(leaf.getConditions())) continue;
                isSubset = true;
                break;
            }
            if (isSubset) continue;
            biclusters.add(leaf);
        }
        return biclusters;
    }

    private double getASR(BETNode<Integer> node) {
        List<Integer> genes = node.getGenes();
        List<Integer> conditions = node.getConditions();
        Matrix data = new Matrix(this.network, genes.size(), conditions.size());
        for (int i = 0; i < genes.size(); ++i) {
            for (int j = 0; j < conditions.size(); ++j) {
                data.setValue(i, j, this.matrix.getValue(genes.get(i), conditions.get(j)));
            }
        }
        double asr = 0.0;
        double asr_g = 0.0;
        double asr_c = 0.0;
        for (int i = 0; i < genes.size(); ++i) {
            for (int j = i + 1; j < genes.size(); ++j) {
                asr_g += this.getSpearmansRho(data, i, j).doubleValue();
            }
        }
        asr = 2.0 * (asr_g /= (double)(genes.size() * (genes.size() - 1)));
        return asr;
    }

    private Double getSpearmansRho(Matrix data, int i, int j) {
        Double rho = 0.0;
        double[] rank1 = data.getRank(i);
        double[] rank2 = data.getRank(j);
        int n = rank1.length;
        double sum_d2 = 0.0;
        int k = 0;
        while (i < n) {
            sum_d2 += Math.pow(rank1[k] - rank2[k], 2.0);
            ++i;
        }
        rho = 1.0 - 6.0 * sum_d2 / (double)(n * (n * n - 1));
        return rho;
    }

    public List<Integer> union(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> unionList = new ArrayList<Integer>(a);
        unionList.removeAll(b);
        unionList.addAll(b);
        return unionList;
    }

    public List<Integer> intersection(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> intersectionList = new ArrayList<Integer>(a);
        intersectionList.retainAll(b);
        return intersectionList;
    }

    public Double[][] preProcess() {
        int nelements = this.matrix.nRows();
        int nattrs = this.matrix.nColumns();
        Double[][] matrix_proc = new Double[nelements][nattrs];
        for (int i = 0; i < nelements; ++i) {
            double avg_i = this.getRowAvg(i);
            for (int j = 0; j < nattrs; ++j) {
                Double value = this.matrix.getValue(i, j);
                matrix_proc[i][j] = value == null || avg_i == 0.0 ? null : (Math.abs(value - avg_i) / avg_i > this.delta ? value : null);
            }
        }
        return matrix_proc;
    }

    public double getRowAvg(int row) {
        int nattrs = this.matrix.nColumns();
        double avg = 0.0;
        int count = 0;
        for (int j = 0; j < nattrs; ++j) {
            Double value = this.matrix.getValue(row, j);
            if (value == null) continue;
            avg += value.doubleValue();
            ++count;
        }
        if (count == 0) {
            return avg;
        }
        return avg / (double)count;
    }

    public Map<Integer, List<Long>> getClusterNodes() {
        return this.clusterNodes;
    }

    public Map<Integer, List<String>> getClusterAttrs() {
        return this.clusterAttrs;
    }
}

