/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch.ChengChurchContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunChengChurch {
    protected CyNetwork network;
    protected String[] weightAttributes;
    protected Matrix matrix;
    protected Matrix biclusterMatrix;
    protected Double[][] arr;
    protected int[] clusters;
    protected TaskMonitor monitor;
    protected boolean ignoreMissing = true;
    protected boolean selectedOnly = false;
    ChengChurchContext context;
    protected int nClusters;
    double delta;
    double alpha;
    double MatrixMax;
    double MatrixMin;
    protected Map<Integer, List<Integer>> clusterRows;
    protected Map<Integer, List<Integer>> clusterCols;
    protected Map<Integer, List<Long>> clusterNodes;
    protected Map<Integer, List<String>> clusterAttrs;
    List<Integer> unvisited;
    double[][] distanceMatrix;

    public RunChengChurch(CyNetwork network, String[] weightAttributes, TaskMonitor monitor, ChengChurchContext context) {
        this.network = network;
        this.weightAttributes = weightAttributes;
        this.monitor = monitor;
        this.context = context;
        this.nClusters = context.nClusters;
        this.delta = context.delta;
        this.alpha = (Double)context.alpha.getValue();
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Matrix getBiclusterMatrix() {
        return this.biclusterMatrix;
    }

    public int getNClusters() {
        return this.nClusters;
    }

    public int[] getClustersArray() {
        return this.clusters;
    }

    public Integer[] cluster(boolean transpose) {
        int j;
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.ignoreMissing, this.selectedOnly);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "cluster matrix has " + this.matrix.nRows() + " rows");
        this.matrix.setUniformWeights();
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        int nelements = this.matrix.nRows();
        int nattrs = this.matrix.nColumns();
        this.arr = new Double[nelements][nattrs];
        Random generator = new Random();
        double range = this.MatrixMax - this.MatrixMin;
        for (int i = 0; i < nelements; ++i) {
            for (int j2 = 0; j2 < nattrs; ++j2) {
                this.arr[i][j2] = this.matrix.getValue(i, j2);
                if (this.arr[i][j2] != null) continue;
                this.arr[i][j2] = generator.nextDouble() * range + this.MatrixMin;
            }
        }
        boolean ifound = true;
        int currentC = -1;
        this.clusterRows = new HashMap<Integer, List<Integer>>();
        this.clusterCols = new HashMap<Integer, List<Integer>>();
        this.clusterNodes = new HashMap<Integer, List<Long>>();
        this.clusterAttrs = new HashMap<Integer, List<String>>();
        this.setMatrixMinMax();
        int totalRows = 0;
        for (int iter = 0; iter < this.nClusters; ++iter) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            ArrayList<Integer> cols = new ArrayList<Integer>();
            for (int i = 0; i < nelements; ++i) {
                rows.add(i);
            }
            for (int j3 = 0; j3 < nattrs; ++j3) {
                cols.add(j3);
            }
            boolean changed = this.multipleNodeDeletion(rows, cols);
            if (!changed) {
                this.singleNodeDeletion(rows, cols);
            }
            this.nodeAddition(rows, cols);
            ArrayList<Long> nodes = new ArrayList<Long>();
            for (int i = 0; i < rows.size(); ++i) {
                nodes.add(this.matrix.getRowNode((Integer)rows.get(i)).getSUID());
            }
            this.clusterNodes.put(iter, nodes);
            ArrayList<String> attrs = new ArrayList<String>();
            for (j = 0; j < cols.size(); ++j) {
                attrs.add(this.matrix.getColLabel((Integer)cols.get(j)));
            }
            this.clusterAttrs.put(iter, attrs);
            totalRows += rows.size();
            this.clusterRows.put(iter, rows);
            this.clusterCols.put(iter, cols);
            this.maskMatrix(rows, cols);
        }
        this.clusters = new int[totalRows];
        CyNode[] rowNodes = new CyNode[totalRows];
        this.biclusterMatrix = new Matrix(this.network, totalRows, nattrs);
        int i = 0;
        for (Integer biclust : this.clusterRows.keySet()) {
            for (Integer node : this.clusterRows.get(biclust)) {
                this.biclusterMatrix.setRowLabel(i, this.matrix.getRowLabel(node));
                rowNodes[i] = this.matrix.getRowNode(node);
                for (j = 0; j < nattrs; ++j) {
                    this.biclusterMatrix.setValue(i, j, this.matrix.getValue(node, j));
                }
                this.clusters[i] = biclust;
                ++i;
            }
        }
        for (int j4 = 0; j4 < nattrs; ++j4) {
            this.biclusterMatrix.setColLabel(j4, this.matrix.getColLabel(j4));
        }
        this.biclusterMatrix.setRowNodes(rowNodes);
        Integer[] rowOrder = this.biclusterMatrix.indexSort(this.clusters, this.clusters.length);
        return rowOrder;
    }

    public void setMatrixMinMax() {
        this.MatrixMax = Double.MIN_VALUE;
        this.MatrixMin = Double.MAX_VALUE;
        int nelements = this.matrix.nRows();
        int nattrs = this.matrix.nColumns();
        for (int i = 0; i < nelements; ++i) {
            for (int j = 0; j < nattrs; ++j) {
                double value = this.arr[i][j];
                if (value > this.MatrixMax) {
                    this.MatrixMax = value;
                }
                if (!(value < this.MatrixMin)) continue;
                this.MatrixMin = value;
            }
        }
    }

    public void maskMatrix(List<Integer> rows, List<Integer> cols) {
        int nRows = rows.size();
        int nCols = cols.size();
        Random generator = new Random();
        double range = this.MatrixMax - this.MatrixMin;
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                double maskVal = generator.nextDouble() * range + this.MatrixMin;
                this.arr[rows.get((int)i).intValue()][cols.get((int)j).intValue()] = maskVal;
            }
        }
    }

    public double calcMSR(List<Integer> rows, List<Integer> cols) {
        double msr = 0.0;
        int rowSize = rows.size();
        int colSize = cols.size();
        Map<Integer, Double> rowSums = this.getRowSums(rows, cols);
        Map<Integer, Double> colSums = this.getColSums(rows, cols);
        double aIJ = 0.0;
        for (Integer i : rowSums.keySet()) {
            aIJ += rowSums.get(i).doubleValue();
        }
        aIJ /= (double)(rowSize * colSize);
        for (Integer i : rows) {
            for (Integer j : cols) {
                double aiJ = rowSums.get(i) / (double)colSize;
                double aIj = colSums.get(j) / (double)rowSize;
                double residue = this.arr[i][j] - aiJ - aIj + aIJ;
                msr += Math.pow(residue, 2.0);
            }
        }
        return msr /= (double)(rowSize * colSize);
    }

    public Map<Integer, Double> getRowSums(List<Integer> rows, List<Integer> cols) {
        HashMap<Integer, Double> rowSums = new HashMap<Integer, Double>();
        for (Integer i : rows) {
            double rowSum = 0.0;
            for (Integer j : cols) {
                rowSum += this.arr[i][j].doubleValue();
            }
            rowSums.put(i, rowSum);
        }
        return rowSums;
    }

    public Map<Integer, Double> getColSums(List<Integer> rows, List<Integer> cols) {
        HashMap<Integer, Double> colSums = new HashMap<Integer, Double>();
        for (Integer j : cols) {
            double colSum = 0.0;
            for (Integer i : rows) {
                colSum += this.arr[i][j].doubleValue();
            }
            colSums.put(j, colSum);
        }
        return colSums;
    }

    public Map<Integer, Double> calcRowMSR(List<Integer> rows, List<Integer> cols) {
        int rowSize = rows.size();
        int colSize = cols.size();
        HashMap<Integer, Double> rowMSRs = new HashMap<Integer, Double>();
        Map<Integer, Double> rowSums = this.getRowSums(rows, cols);
        Map<Integer, Double> colSums = this.getColSums(rows, cols);
        double aIJ = 0.0;
        for (Integer i : rowSums.keySet()) {
            aIJ += rowSums.get(i).doubleValue();
        }
        aIJ /= (double)(rowSize * colSize);
        for (Integer i : rows) {
            double rowMsr = 0.0;
            for (Integer j : cols) {
                double aiJ = rowSums.get(i) / (double)colSize;
                double aIj = colSums.get(j) / (double)rowSize;
                double residue = this.arr[i][j] - aiJ - aIj + aIJ;
                rowMsr += Math.pow(residue, 2.0);
            }
            rowMSRs.put(i, rowMsr /= (double)colSize);
        }
        return rowMSRs;
    }

    public Map<Integer, Double> calcColMSR(List<Integer> rows, List<Integer> cols) {
        int rowSize = rows.size();
        int colSize = cols.size();
        HashMap<Integer, Double> colMSRs = new HashMap<Integer, Double>();
        Map<Integer, Double> rowSums = this.getRowSums(rows, cols);
        Map<Integer, Double> colSums = this.getColSums(rows, cols);
        double aIJ = 0.0;
        for (Integer i : rowSums.keySet()) {
            aIJ += rowSums.get(i).doubleValue();
        }
        aIJ /= (double)(rowSize * colSize);
        for (Integer j : cols) {
            double colMsr = 0.0;
            for (Integer i : rows) {
                double aiJ = rowSums.get(i) / (double)colSize;
                double aIj = colSums.get(j) / (double)rowSize;
                double residue = this.arr[i][j] - aiJ - aIj + aIJ;
                colMsr += Math.pow(residue, 2.0);
            }
            colMSRs.put(j, colMsr /= (double)rowSize);
        }
        return colMSRs;
    }

    public Map<Integer, Double> calcOtherRowMSR(List<Integer> rows, List<Integer> cols, boolean inverted) {
        ArrayList<Integer> otherRows = new ArrayList<Integer>();
        ArrayList<Integer> otherCols = new ArrayList<Integer>();
        int nRows = this.matrix.nRows();
        int nCols = this.matrix.nColumns();
        for (int i = 0; i < nRows; ++i) {
            if (rows.contains(i)) continue;
            otherRows.add(i);
        }
        for (int j = 0; j < nCols; ++j) {
            if (cols.contains(j)) continue;
            otherCols.add(j);
        }
        int rowSize = rows.size();
        int colSize = cols.size();
        int otherRowSize = otherRows.size();
        int otherColSize = otherCols.size();
        HashMap<Integer, Double> rowMSRs = new HashMap<Integer, Double>();
        Map<Integer, Double> rowSums = this.getRowSums(rows, cols);
        Map<Integer, Double> colSums = this.getColSums(rows, cols);
        double aIJ = 0.0;
        for (Integer i : rowSums.keySet()) {
            aIJ += rowSums.get(i).doubleValue();
        }
        aIJ /= (double)(rowSize * colSize);
        Map<Integer, Double> otherRowSums = this.getRowSums(otherRows, cols);
        for (Integer i : otherRows) {
            double rowMsr = 0.0;
            for (Integer j : cols) {
                double aiJ = otherRowSums.get(i) / (double)colSize;
                double aIj = colSums.get(j) / (double)rowSize;
                double residue = 0.0;
                residue = !inverted ? this.arr[i][j] - aiJ - aIj + aIJ : -this.arr[i][j].doubleValue() + aiJ - aIj + aIJ;
                rowMsr += Math.pow(residue, 2.0);
            }
            rowMSRs.put(i, rowMsr /= (double)colSize);
        }
        return rowMSRs;
    }

    public Map<Integer, Double> calcOtherColMSR(List<Integer> rows, List<Integer> cols) {
        ArrayList<Integer> otherRows = new ArrayList<Integer>();
        ArrayList<Integer> otherCols = new ArrayList<Integer>();
        int nRows = this.matrix.nRows();
        int nCols = this.matrix.nColumns();
        for (int i = 0; i < nRows; ++i) {
            if (rows.contains(i)) continue;
            otherRows.add(i);
        }
        for (int j = 0; j < nCols; ++j) {
            if (cols.contains(j)) continue;
            otherCols.add(j);
        }
        int rowSize = rows.size();
        int colSize = cols.size();
        int otherRowSize = otherRows.size();
        int otherColSize = otherCols.size();
        HashMap<Integer, Double> colMSRs = new HashMap<Integer, Double>();
        Map<Integer, Double> rowSums = this.getRowSums(rows, cols);
        Map<Integer, Double> colSums = this.getColSums(rows, cols);
        double aIJ = 0.0;
        for (Integer i : rowSums.keySet()) {
            aIJ += rowSums.get(i).doubleValue();
        }
        aIJ /= (double)(rowSize * colSize);
        Map<Integer, Double> otherColSums = this.getColSums(rows, otherCols);
        for (Integer j : otherCols) {
            double colMsr = 0.0;
            for (Integer i : rows) {
                double aiJ = rowSums.get(i) / (double)colSize;
                double aIj = otherColSums.get(j) / (double)rowSize;
                double residue = this.arr[i][j] - aiJ - aIj + aIJ;
                colMsr += Math.pow(residue, 2.0);
            }
            colMSRs.put(j, colMsr /= (double)rowSize);
        }
        return colMSRs;
    }

    public boolean multipleNodeDeletion(List<Integer> rows, List<Integer> cols) {
        double msr = this.calcMSR(rows, cols);
        boolean changed = false;
        while (msr > this.delta) {
            changed = false;
            Map<Integer, Double> rowMSRs = this.calcRowMSR(rows, cols);
            double cutoff = this.alpha * msr;
            ArrayList<Integer> remRows = new ArrayList<Integer>();
            for (Integer i : rows) {
                if (!(rowMSRs.get(i) > cutoff)) continue;
                remRows.add(i);
                changed = true;
            }
            for (Integer i : remRows) {
                rows.remove(rows.indexOf(i));
            }
            ArrayList<Integer> remCols = new ArrayList<Integer>();
            Map<Integer, Double> colMSRs = this.calcColMSR(rows, cols);
            for (Integer j : cols) {
                if (!(colMSRs.get(j) > cutoff)) continue;
                remCols.add(j);
                changed = true;
            }
            for (Integer j : remCols) {
                cols.remove(cols.indexOf(j));
            }
            if (!changed) break;
            msr = this.calcMSR(rows, cols);
        }
        return changed;
    }

    public void singleNodeDeletion(List<Integer> rows, List<Integer> cols) {
        double msr = this.calcMSR(rows, cols);
        while (msr > this.delta) {
            Map<Integer, Double> rowMSRs = this.calcRowMSR(rows, cols);
            Map<Integer, Double> colMSRs = this.calcColMSR(rows, cols);
            int maxRow = this.getMax(rowMSRs);
            int maxCol = this.getMax(colMSRs);
            if (rowMSRs.get(maxRow) > colMSRs.get(maxCol)) {
                rows.remove(rows.indexOf(maxRow));
            } else {
                cols.remove(cols.indexOf(maxCol));
            }
            msr = this.calcMSR(rows, cols);
        }
    }

    public void nodeAddition(List<Integer> rows, List<Integer> cols) {
        int colSize;
        int rowSize;
        do {
            rowSize = rows.size();
            colSize = cols.size();
            double msr = this.calcMSR(rows, cols);
            Map<Integer, Double> otherColMSRs = this.calcOtherColMSR(rows, cols);
            for (Integer j : otherColMSRs.keySet()) {
                if (!(otherColMSRs.get(j) <= msr)) continue;
                cols.add(j);
            }
            msr = this.calcMSR(rows, cols);
            Map<Integer, Double> otherRowMSRs = this.calcOtherRowMSR(rows, cols, false);
            Map<Integer, Double> otherRowMSRs_inverted = this.calcOtherRowMSR(rows, cols, true);
            for (Integer i : otherRowMSRs.keySet()) {
                if (!(otherRowMSRs.get(i) <= msr)) continue;
                rows.add(i);
            }
            for (Integer i : otherRowMSRs_inverted.keySet()) {
                if (rows.contains(i) || !(otherRowMSRs_inverted.get(i) <= msr)) continue;
                rows.add(i);
            }
        } while (rowSize != rows.size() || colSize != cols.size());
    }

    public int getMax(Map<Integer, Double> map) {
        Integer maxkey = null;
        Map.Entry<Integer, Double> maxEntry = null;
        for (Map.Entry<Integer, Double> entry : map.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        maxkey = (Integer)maxEntry.getKey();
        return maxkey;
    }

    public Map<Integer, List<Integer>> getClusterRows() {
        return this.clusterRows;
    }

    public Map<Integer, List<Integer>> getClusterCols() {
        return this.clusterCols;
    }

    public Map<Integer, List<Long>> getClusterNodes() {
        return this.clusterNodes;
    }

    public Map<Integer, List<String>> getClusterAttrs() {
        return this.clusterAttrs;
    }
}

