/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import java.util.Arrays;
import java.util.TreeMap;

public class Clusters {
    protected int[] index;
    protected int[] orderedLabels;
    protected int k;
    private double cost;
    private int[] sizes;
    private int[][] partitions;

    public Clusters(int[] assignments) {
        this.init(assignments, 0.0);
    }

    public Clusters(int[] assignments, double cost) {
        this.init(assignments, cost);
    }

    public Clusters(int k) {
        int[] t = new int[k];
        for (int i = 0; i < k; ++i) {
            t[i] = k;
        }
        this.index = t;
        this.orderedLabels = Arrays.copyOf(t, t.length);
        this.k = k;
        this.cost = 0.0;
    }

    public Clusters(int[] index, int nClusters, double cost) {
        this.index = Arrays.copyOf(index, index.length);
        this.k = nClusters;
        this.cost = cost;
        int[] orderedLabels = new int[nClusters];
        for (int c = 0; c < nClusters; ++c) {
            orderedLabels[c] = c;
        }
        this.orderedLabels = orderedLabels;
    }

    public Clusters(Clusters other) {
        this.index = Arrays.copyOf(other.index, other.index.length);
        this.k = other.k;
        this.cost = other.cost;
        this.orderedLabels = Arrays.copyOf(other.orderedLabels, other.orderedLabels.length);
    }

    protected void init(int[] assignments, double cost) {
        int m = assignments.length;
        Integer[] elements = new Integer[m];
        for (int ii = 0; ii < m; ++ii) {
            elements[ii] = new Integer(ii);
        }
        Integer k = new Integer(0);
        TreeMap<Integer, Integer> clusterLabels = new TreeMap<Integer, Integer>();
        for (int ii = 0; ii < m; ++ii) {
            if (clusterLabels.containsKey(elements[assignments[ii]])) continue;
            Integer n = k;
            Integer n2 = k = Integer.valueOf(k + 1);
            clusterLabels.put(elements[assignments[ii]], n);
        }
        int[] newClusterIndex = new int[m];
        for (int ii = 0; ii < m; ++ii) {
            newClusterIndex[ii] = (Integer)clusterLabels.get(elements[assignments[ii]]);
        }
        int[] labels = new int[k.intValue()];
        for (int i = 0; i < m; ++i) {
            labels[newClusterIndex[i]] = assignments[i];
        }
        this.orderedLabels = labels;
        this.index = newClusterIndex;
        this.k = clusterLabels.size();
        this.cost = cost;
    }

    public int getClusterIndex(int i) {
        return this.index[i];
    }

    public int getLabel(int i) {
        return this.orderedLabels[this.index[i]];
    }

    public int getClusterLabel(int c) {
        return this.orderedLabels[c];
    }

    public int[] getClusterLabels() {
        return this.orderedLabels;
    }

    public void order(int[] clusterOrderIndex) {
        int k = clusterOrderIndex.length;
        if (k != this.k) {
            throw new IllegalArgumentException("clusterOrderIndex must be a permutation of the cluster index (and its size must be equal to the number of clusters).");
        }
        TreeMap<Integer, Integer> oldToNew = new TreeMap<Integer, Integer>();
        for (int c = 0; c < k; ++c) {
            oldToNew.put(clusterOrderIndex[c], c);
        }
        int m = this.index.length;
        int[] newIndex = new int[m];
        for (int i = 0; i < m; ++i) {
            newIndex[i] = (Integer)oldToNew.get(this.index[i]);
        }
        int[] newOrderedLabels = new int[k];
        for (int d = 0; d < k; ++d) {
            newOrderedLabels[d] = this.orderedLabels[clusterOrderIndex[d]];
        }
        this.index = newIndex;
        this.orderedLabels = newOrderedLabels;
        this.clear();
    }

    public void merge(int c1, int c2) {
        int c;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] == c2) {
                this.index[i] = c1;
            }
            if (this.index[i] <= c2) continue;
            int n = i;
            this.index[n] = this.index[n] - 1;
        }
        int[] newOrderedLabels = new int[this.k - 1];
        for (c = 0; c < c2; ++c) {
            newOrderedLabels[c] = this.orderedLabels[c];
        }
        for (c = c2; c < this.k - 1; ++c) {
            newOrderedLabels[c] = this.orderedLabels[c + 1];
        }
        this.orderedLabels = newOrderedLabels;
        --this.k;
        this.clear();
    }

    public int[] getSizes() {
        if (this.sizes != null) {
            return this.sizes;
        }
        this.sizes = new int[this.k];
        for (int i = 0; i < this.index.length; ++i) {
            int n = this.index[i];
            this.sizes[n] = this.sizes[n] + 1;
        }
        return this.sizes;
    }

    public int[][] getPartitions() {
        int[] sizes = this.getSizes();
        this.partitions = new int[this.k][];
        for (int i = 0; i < this.k; ++i) {
            this.partitions[i] = new int[sizes[i]];
        }
        int[] counters = new int[this.k];
        int i = 0;
        while (i < this.index.length) {
            int cl = this.index[i];
            this.partitions[cl][counters[cl]] = i++;
            int n = cl;
            counters[n] = counters[n] + 1;
        }
        return this.partitions;
    }

    public int getNumberOfClusters() {
        return this.k;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void clear() {
        this.sizes = null;
        this.partitions = null;
    }

    public int size() {
        return this.index.length;
    }
}

