/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DBSCAN;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DBSCAN.DBSCANContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunDBSCAN {
    protected CyNetwork network;
    protected String[] weightAttributes;
    protected DistanceMetric metric;
    protected Matrix matrix;
    protected TaskMonitor monitor;
    protected boolean ignoreMissing = true;
    protected boolean selectedOnly = false;
    DBSCANContext context;
    protected int nClusters;
    double eps;
    int minPts;
    ArrayList<Integer> unvisited;
    double[][] distanceMatrix;

    public RunDBSCAN(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor, DBSCANContext context) {
        this.network = network;
        this.weightAttributes = weightAttributes;
        this.metric = metric;
        this.monitor = monitor;
        this.context = context;
        this.eps = context.eps;
        this.minPts = context.minPts;
        this.nClusters = 0;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getNClusters() {
        return this.nClusters;
    }

    public int[] cluster(boolean transpose) {
        int i;
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.ignoreMissing, this.selectedOnly);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "cluster matrix has " + this.matrix.nRows() + " rows");
        this.matrix.setUniformWeights();
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        int nelements = this.matrix.nRows();
        boolean ifound = true;
        int currentC = -1;
        int[] clusters = new int[nelements];
        this.distanceMatrix = new double[nelements][nelements];
        for (i = 0; i < nelements; ++i) {
            for (int j = i + 1; j < nelements; ++j) {
                double distance;
                this.distanceMatrix[i][j] = distance = ((DistanceMetric)((Object)this.context.metric.getSelectedValue())).getMetric(this.matrix, this.matrix, this.matrix.getWeights(), i, j);
            }
        }
        this.unvisited = new ArrayList();
        for (i = 0; i < nelements; ++i) {
            this.unvisited.add(i);
            clusters[i] = -1;
        }
        while (this.unvisited.size() > 0) {
            int p = this.unvisited.get(0);
            this.unvisited.remove(0);
            ArrayList<Integer> neighborPts = this.regionQuery(p);
            if (neighborPts.size() < this.minPts) {
                clusters[p] = -1;
                continue;
            }
            this.expandCluster(p, neighborPts, ++currentC, clusters);
        }
        this.nClusters = currentC + 1;
        return clusters;
    }

    private void expandCluster(int p, ArrayList<Integer> neighborPts, int currentC, int[] clusters) {
        clusters[p] = currentC;
        for (int i = 0; i < neighborPts.size(); ++i) {
            int np = neighborPts.get(i);
            if (this.unvisited.contains(np)) {
                this.unvisited.remove(this.unvisited.indexOf(np));
                ArrayList<Integer> newNeighborPts = this.regionQuery(np);
                if (newNeighborPts.size() >= this.minPts) {
                    for (Integer newNp : newNeighborPts) {
                        neighborPts.add(newNp);
                    }
                }
            }
            if (clusters[np] != -1) continue;
            clusters[np] = currentC;
        }
    }

    private ArrayList<Integer> regionQuery(int p) {
        ArrayList<Integer> neighborPts = new ArrayList<Integer>();
        int nelements = this.distanceMatrix[p].length;
        for (int i = 0; i < nelements; ++i) {
            if (i == p || !(this.distanceMatrix[p][i] <= this.eps)) continue;
            neighborPts.add(i);
        }
        return neighborPts;
    }
}

