/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;

public class DistanceMatrix {
    protected double[][] matrix;
    protected DistanceMetric metric;
    protected int[] idx;

    public DistanceMatrix(BaseMatrix data, DistanceMetric metric) {
        this(data, metric, null);
    }

    public DistanceMatrix(BaseMatrix data, DistanceMetric metric, int[] idx) {
        this.matrix = data.getDistanceMatrix(metric);
        this.metric = metric;
        if (idx == null) {
            idx = new int[this.matrix.length];
            for (int i = 0; i < this.matrix.length; ++i) {
                idx[i] = i;
            }
        }
        this.idx = idx;
    }

    private DistanceMatrix(double[][] matrix, DistanceMetric metric, int[] idx) {
        this.matrix = matrix;
        this.metric = metric;
        this.idx = idx;
    }

    public double getValue(int i, int j) {
        return this.matrix[this.idx[i]][this.idx[j]];
    }

    public DistanceMatrix subset(int[] idx) {
        return new DistanceMatrix(this.matrix, this.metric, idx);
    }

    public int size() {
        return this.idx.length;
    }

    public DistanceMetric getDistanceMetric() {
        return this.metric;
    }
}

