/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DistanceMetric {
    VALUE_IS_CORRELATION("None -- attributes are correlations"),
    UNCENTERED_CORRELATION("Uncentered correlation"),
    CORRELATION("Pearson correlation"),
    ABS_UNCENTERED_CORRELATION("Uncentered correlation, absolute value"),
    ABS_CORRELATION("Pearson correlation, absolute value"),
    SPEARMANS_RANK("Spearman's rank correlation"),
    KENDALLS_TAU("Kendall's tau"),
    EUCLIDEAN("Euclidean distance"),
    CITYBLOCK("City-block distance");

    private String name;

    private DistanceMetric(String name) {
        this.name = name;
    }

    public static List<DistanceMetric> getDistanceMetricList() {
        ArrayList<DistanceMetric> distanceMetricList = new ArrayList<DistanceMetric>();
        distanceMetricList.add(VALUE_IS_CORRELATION);
        distanceMetricList.add(UNCENTERED_CORRELATION);
        distanceMetricList.add(CORRELATION);
        distanceMetricList.add(ABS_UNCENTERED_CORRELATION);
        distanceMetricList.add(ABS_CORRELATION);
        distanceMetricList.add(SPEARMANS_RANK);
        distanceMetricList.add(KENDALLS_TAU);
        distanceMetricList.add(EUCLIDEAN);
        distanceMetricList.add(CITYBLOCK);
        return distanceMetricList;
    }

    public String toString() {
        return this.name;
    }

    public double getMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        switch (this) {
            case EUCLIDEAN: {
                return this.euclidMetric(data1, data2, weights, index1, index2);
            }
            case CITYBLOCK: {
                return this.cityblockMetric(data1, data2, weights, index1, index2);
            }
            case CORRELATION: {
                return this.correlationMetric(data1, data2, weights, index1, index2);
            }
            case ABS_CORRELATION: {
                return this.acorrelationMetric(data1, data2, weights, index1, index2);
            }
            case UNCENTERED_CORRELATION: {
                return this.ucorrelationMetric(data1, data2, weights, index1, index2);
            }
            case ABS_UNCENTERED_CORRELATION: {
                return this.uacorrelationMetric(data1, data2, weights, index1, index2);
            }
            case SPEARMANS_RANK: {
                return this.spearmanMetric(data1, data2, weights, index1, index2);
            }
            case KENDALLS_TAU: {
                return this.kendallMetric(data1, data2, weights, index1, index2);
            }
            case VALUE_IS_CORRELATION: {
                return 1.0 - data1.doubleValue(index1, index2);
            }
        }
        return this.euclidMetric(data1, data2, weights, index1, index2);
    }

    private double euclidMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double tweight = 0.0;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term = data1.doubleValue(index1, i) - data2.doubleValue(index2, i);
            result += weights[i] * term * term;
            tweight += weights[i];
        }
        if (tweight == 0.0) {
            return 0.0;
        }
        return result / tweight;
    }

    private double cityblockMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double tweight = 0.0;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term = data1.doubleValue(index1, i) - data2.doubleValue(index2, i);
            result += weights[i] * Math.abs(term);
            tweight += weights[i];
        }
        if (tweight == 0.0) {
            return 0.0;
        }
        return result / tweight;
    }

    private double correlationMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double denom1 = 0.0;
        double denom2 = 0.0;
        double tweight = 0.0;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term1 = data1.doubleValue(index1, i);
            double term2 = data2.doubleValue(index2, i);
            double w = weights[i];
            sum1 += w * term1;
            sum2 += w * term2;
            result += w * term1 * term2;
            denom1 += w * term1 * term1;
            denom2 += w * term2 * term2;
            tweight += w;
        }
        if (tweight == 0.0) {
            return 0.0;
        }
        result -= sum1 * sum2 / tweight;
        denom1 -= sum1 * sum1 / tweight;
        denom2 -= sum2 * sum2 / tweight;
        if (denom1 <= 0.0) {
            return 1.0;
        }
        if (denom2 <= 0.0) {
            return 1.0;
        }
        return 1.0 - (result /= Math.sqrt(denom1 * denom2));
    }

    private double acorrelationMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double denom1 = 0.0;
        double denom2 = 0.0;
        double tweight = 0.0;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term1 = data1.doubleValue(index1, i);
            double term2 = data2.doubleValue(index2, i);
            double w = weights[i];
            sum1 += w * term1;
            sum2 += w * term2;
            result += w * term1 * term2;
            denom1 += w * term1 * term1;
            denom2 += w * term2 * term2;
            tweight += w;
        }
        if (tweight == 0.0) {
            return 0.0;
        }
        result -= sum1 * sum2 / tweight;
        denom1 -= sum1 * sum1 / tweight;
        denom2 -= sum2 * sum2 / tweight;
        if (denom1 <= 0.0) {
            return 1.0;
        }
        if (denom2 <= 0.0) {
            return 1.0;
        }
        result = Math.abs(result) / Math.sqrt(denom1 * denom2);
        return 1.0 - result;
    }

    private double ucorrelationMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double denom1 = 0.0;
        double denom2 = 0.0;
        boolean flag = false;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term1 = data1.doubleValue(index1, i);
            double term2 = data2.doubleValue(index2, i);
            double w = weights[i];
            result += w * term1 * term2;
            denom1 += w * term1 * term1;
            denom2 += w * term2 * term2;
            flag = true;
        }
        if (!flag) {
            return 0.0;
        }
        if (denom1 == 0.0) {
            return 1.0;
        }
        if (denom2 == 0.0) {
            return 1.0;
        }
        return 1.0 - (result /= Math.sqrt(denom1 * denom2));
    }

    private double uacorrelationMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double denom1 = 0.0;
        double denom2 = 0.0;
        boolean flag = false;
        for (int i = 0; i < data1.nColumns(); ++i) {
            if (!data1.hasValue(index1, i) || !data2.hasValue(index2, i)) continue;
            double term1 = data1.doubleValue(index1, i);
            double term2 = data2.doubleValue(index2, i);
            double w = weights[i];
            result += w * term1 * term2;
            denom1 += w * term1 * term1;
            denom2 += w * term2 * term2;
            flag = true;
        }
        if (!flag) {
            return 0.0;
        }
        if (denom1 == 0.0) {
            return 1.0;
        }
        if (denom2 == 0.0) {
            return 1.0;
        }
        result = Math.abs(result) / Math.sqrt(denom1 * denom2);
        return 1.0 - result;
    }

    private double spearmanMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        double result = 0.0;
        double denom1 = 0.0;
        double denom2 = 0.0;
        double[] rank1 = data1.getRank(index1);
        double[] rank2 = data2.getRank(index2);
        if (rank1 == null || rank2 == null) {
            return 0.0;
        }
        double avgrank = 0.5 * (double)(rank1.length - 1);
        for (int i = 0; i < rank1.length; ++i) {
            double value1 = rank1[i];
            double value2 = rank2[i];
            result += value1 * value2;
            denom1 += value1 * value1;
            denom2 += value2 * value2;
        }
        result /= (double)rank1.length;
        denom1 /= (double)rank1.length;
        denom2 /= (double)rank1.length;
        result -= avgrank * avgrank;
        denom1 -= avgrank * avgrank;
        denom2 -= avgrank * avgrank;
        if (denom1 <= 0.0) {
            return 1.0;
        }
        if (denom2 <= 0.0) {
            return 1.0;
        }
        return 1.0 - (result /= Math.sqrt(denom1 * denom2));
    }

    private double kendallMetric(BaseMatrix data1, BaseMatrix data2, double[] weights, int index1, int index2) {
        int con = 0;
        int dis = 0;
        int exx = 0;
        int exy = 0;
        boolean flag = false;
        for (int i = 0; i < data1.nColumns(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!data1.hasValue(index1, j) || !data2.hasValue(index2, j)) continue;
                double x1 = data1.doubleValue(index1, i);
                double x2 = data1.doubleValue(index1, j);
                double y1 = data2.doubleValue(index2, i);
                double y2 = data2.doubleValue(index2, j);
                if (x1 < x2 && y1 < y2) {
                    ++con;
                }
                if (x1 > x2 && y1 > y2) {
                    ++con;
                }
                if (x1 < x2 && y1 > y2) {
                    ++dis;
                }
                if (x1 > x2 && y1 < y2) {
                    ++dis;
                }
                if (x1 == x2 && y1 != y2) {
                    ++exx;
                }
                if (x1 != x2 && y1 == y2) {
                    ++exy;
                }
                flag = true;
            }
        }
        if (!flag) {
            return 0.0;
        }
        double denomx = con + dis + exx;
        double denomy = con + dis + exy;
        if (denomx == 0.0) {
            return 1.0;
        }
        if (denomy == 0.0) {
            return 1.0;
        }
        double tau = (double)(con - dis) / Math.sqrt(denomx * denomy);
        return 1.0 - tau;
    }
}

