/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSOMEContext {
    CyNetwork network;
    @ContainsTunables
    public AttributeList attributeList = null;
    @Tunable(description="Only use selected nodes for cluster", groups={"Data Input"}, gravity=60.0)
    public boolean selectedOnly = false;
    @Tunable(description="Ignore nodes with no data", groups={"Data Input"}, gravity=61.0)
    public boolean ignoreMissing = true;
    @Tunable(description="Running Mode", groups={"AutoSOME Basic Tuning"}, gravity=65.0)
    public ListSingleSelection<String> mode = new ListSingleSelection((Object[])new String[]{"Normal", "Precision", "Speed"});
    @Tunable(description="Number of Ensemble Runs", groups={"AutoSOME Basic Tuning"}, gravity=66.0)
    public int ensembleRuns = 50;
    @Tunable(description="P-Value Threshold", groups={"AutoSOME Basic Tuning"}, gravity=67.0)
    public double pvalue = 0.05;
    @Tunable(description="Number of Threads (No. CPUs)", groups={"AutoSOME Basic Tuning"}, gravity=68.0)
    public int numThreads = 1;
    @Tunable(description="Normalization mode", groups={"Data Normalization"}, params="displayState=expanded", gravity=75.0)
    public ListSingleSelection<String> normalization = new ListSingleSelection((Object[])new String[]{"Custom", "No normalization", "Expression data 1", "Expression data 2"});
    @Tunable(description="Log2 Scaling", groups={"Data Normalization"}, gravity=76.0)
    public boolean logscaling = false;
    @Tunable(description="Unit Variance", groups={"Data Normalization"}, gravity=76.0)
    public boolean unitvar = false;
    @Tunable(description="Median Centering", groups={"Data Normalization"}, gravity=77.0)
    public ListSingleSelection<String> medianCentering = new ListSingleSelection((Object[])new String[]{"None", "Genes", "Arrays", "Both"});
    @Tunable(description="Sum of Squares=1", groups={"Data Normalization"}, gravity=78.0)
    public ListSingleSelection<String> sumSqr = new ListSingleSelection((Object[])new String[]{"None", "Genes", "Arrays", "Both"});
    @Tunable(description="Missing value handling", groups={"Data Normalization"}, gravity=79.0)
    public ListSingleSelection<String> fillMissing = new ListSingleSelection((Object[])new String[]{"Row Mean", "Row Median", "Column Mean", "Column Median"});
    @Tunable(description="Perform Fuzzy Clustering", groups={"Fuzzy Cluster Network Settings"}, params="displayState=expanded", gravity=100.0)
    public boolean performFuzzy = false;
    @Tunable(description="Source Data", groups={"Fuzzy Cluster Network Settings"}, gravity=101.0)
    public ListSingleSelection<String> fuzzyInput = new ListSingleSelection((Object[])new String[]{"Nodes (Genes)", "Attributes (Array)"});
    @Tunable(description="Distance Metric", groups={"Fuzzy Cluster Network Settings"}, gravity=102.0)
    public ListSingleSelection<String> distanceMetric = new ListSingleSelection((Object[])new String[]{"Uncentered Correlation", "Pearson's Correlation", "Euclidean"});
    @Tunable(description="Maximum number of edges to display in fuzzy network", groups={"Fuzzy Cluster Network Settings"}, gravity=103.0)
    public int maxEdges = 2000;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @Tunable(description="Choose Visualization", groups={"Data Output"}, gravity=125.0)
    public ListSingleSelection<String> dataVisualization = new ListSingleSelection((Object[])new String[]{"Network", "Heatmap"});
    @Tunable(description="Show Visualization when complete", groups={"Data Output"}, gravity=126.0)
    public boolean showViz = false;

    public AutoSOMEContext() {
        this.distanceMetric.setSelectedValue((Object)"Uncentered Correlation");
        this.dataVisualization.setSelectedValue((Object)"Network");
        this.mode.setSelectedValue((Object)"Normal");
        this.advancedAttributes = new AdvancedProperties("__autosomeCluster", false);
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network, true);
        } else {
            this.attributeList.setNetwork(network);
        }
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("showViz=" + this.showViz);
        params.add("dataVisualization=" + (String)this.dataVisualization.getSelectedValue());
        params.add("maxEdges=" + this.maxEdges);
        params.add("distanceMetric=" + (String)this.distanceMetric.getSelectedValue());
        params.add("fuzzyInput=" + (String)this.fuzzyInput.getSelectedValue());
        params.add("performFuzzy=" + this.performFuzzy);
        params.add("fillMissing=" + (String)this.fillMissing.getSelectedValue());
        params.add("sumSqr=" + (String)this.sumSqr.getSelectedValue());
        params.add("medianCentering=" + (String)this.medianCentering.getSelectedValue());
        params.add("unitvar=" + this.unitvar);
        params.add("logscaling=" + this.logscaling);
        params.add("normalization=" + (String)this.normalization.getSelectedValue());
        params.add("numThreads=" + this.numThreads);
        params.add("pvalue=" + this.pvalue);
        params.add("ensembleRuns" + this.ensembleRuns);
        params.add("mode=" + (String)this.mode.getSelectedValue());
        params.add("ignoreMissing=" + this.ignoreMissing);
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("addributeList=" + this.attributeList.getNodeAttributeList().toString());
        return params;
    }

    public Settings getSettings() {
        Settings settings = new Settings();
        settings.ensemble_runs = this.ensembleRuns;
        settings.mst_pval = this.pvalue;
        settings.threads = this.numThreads;
        settings.logNorm = this.logscaling;
        settings.unitVar = this.unitvar;
        settings.distMatrix = this.performFuzzy;
        if (((String)this.mode.getSelectedValue()).equals("Normal")) {
            settings.som_iters = 500;
            settings.de_resolution = 32;
        } else if (((String)this.mode.getSelectedValue()).equals("Speed")) {
            settings.som_iters = 250;
            settings.de_resolution = 16;
        } else {
            settings.som_iters = 1000;
            settings.de_resolution = 64;
        }
        if (((String)this.medianCentering.getSelectedValue()).equals("Both")) {
            settings.medCenter = true;
            settings.medCenterCol = true;
        } else if (((String)this.medianCentering.getSelectedValue()).equals("Genes")) {
            settings.medCenter = true;
            settings.medCenterCol = false;
        } else if (((String)this.medianCentering.getSelectedValue()).equals("Arrays")) {
            settings.medCenter = false;
            settings.medCenterCol = true;
        } else {
            settings.medCenter = false;
            settings.medCenterCol = false;
        }
        if (((String)this.sumSqr.getSelectedValue()).equals("Both")) {
            settings.sumSqrRows = true;
            settings.sumSqrCol = true;
        } else if (((String)this.sumSqr.getSelectedValue()).equals("Genes")) {
            settings.sumSqrRows = true;
            settings.sumSqrCol = false;
        } else if (((String)this.sumSqr.getSelectedValue()).equals("Arrays")) {
            settings.sumSqrRows = false;
            settings.sumSqrCol = true;
        } else {
            settings.sumSqrRows = false;
            settings.sumSqrCol = false;
        }
        settings.fillMissing = !this.ignoreMissing;
        settings.distMatrix = this.performFuzzy;
        if (this.performFuzzy) {
            if (((String)this.fuzzyInput.getSelectedValue()).equals("Nodes (Genes)")) {
                settings.FCNrows = true;
            } else if (((String)this.fuzzyInput.getSelectedValue()).equals("Attributes (Array)")) {
                settings.FCNrows = false;
            }
            if (((String)this.distanceMetric.getSelectedValue()).equals("Uncentered Correlation")) {
                settings.dmDist = 3;
            } else if (((String)this.distanceMetric.getSelectedValue()).equals("Pearson's Correlation")) {
                settings.dmDist = 2;
            } else if (((String)this.distanceMetric.getSelectedValue()).equals("Euclidean")) {
                settings.dmDist = 1;
            }
        }
        if (((String)this.fillMissing.getSelectedValue()).equals("Row Mean")) {
            settings.mvMedian = false;
            settings.mvCol = false;
        } else if (((String)this.fillMissing.getSelectedValue()).equals("Row Median")) {
            settings.mvMedian = true;
            settings.mvCol = false;
        } else if (((String)this.fillMissing.getSelectedValue()).equals("Column Mean")) {
            settings.mvMedian = false;
            settings.mvCol = true;
        } else if (((String)this.fillMissing.getSelectedValue()).equals("Column Median")) {
            settings.mvMedian = true;
            settings.mvCol = true;
        }
        return settings;
    }
}

