/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.clusterRun;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Run;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAutoSOME {
    private List<CyNode> nodes;
    private List<CyEdge> edges;
    private boolean canceled = false;
    public static final String GROUP_ATTRIBUTE = "__AutoSOMEGroups";
    protected int clusterCount = 0;
    private boolean createMetaNodes = false;
    private DoubleMatrix2D matrix = null;
    private boolean debug = false;
    private List<String> dataAttributes;
    private boolean ignoreMissing = false;
    private boolean selectedOnly = false;
    private Run autRun;
    private Settings settings;
    private Map<String, CyNode> storeNodes;
    private Map<String, String> storeClust;
    private clusterRun cr;
    public ArrayList<String> attrList = new ArrayList();
    public ArrayList<String> attrOrderList = new ArrayList();
    public ArrayList<String> nodeOrderList = new ArrayList();
    private TaskMonitor monitor;
    private ClusterManager clusterManager;
    private CyNetwork network;

    public RunAutoSOME(ClusterManager clusterManager, List<String> dataAttributes, CyNetwork network, Settings settings, TaskMonitor monitor) {
        this.dataAttributes = dataAttributes;
        this.settings = settings;
        this.monitor = monitor;
        this.clusterManager = clusterManager;
        this.network = network;
    }

    public void setIgnoreMissing(boolean val) {
        this.ignoreMissing = val;
    }

    public void setSelectedOnly(boolean val) {
        this.selectedOnly = val;
    }

    public void cancel() {
        this.canceled = true;
        this.autRun.kill();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<NodeCluster> run(TaskMonitor monitor) {
        Map<NodeCluster, NodeCluster> cMap;
        long startTime = System.currentTimeMillis();
        this.debugln("Initial matrix:");
        this.debugln("Normalized matrix:");
        if (this.dataAttributes == null || this.dataAttributes.size() == 0) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Error: no attribute list selected");
            return null;
        }
        if (this.selectedOnly && this.network.getDefaultNodeTable().countMatchingRows("selected", (Object)true) == 0) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Error: no nodes selected from network");
            return null;
        }
        Settings s = new Settings();
        s.ensemble_runs = this.settings.ensemble_runs;
        s.mst_pval = this.settings.mst_pval;
        s.threads = this.settings.threads;
        s.logNorm = this.settings.logNorm;
        s.unitVar = this.settings.unitVar;
        s.medCenter = this.settings.medCenter;
        s.medCenterCol = this.settings.medCenterCol;
        s.sumSqrRows = this.settings.sumSqrRows;
        s.sumSqrCol = this.settings.sumSqrCol;
        s.som_iters = this.settings.som_iters;
        s.de_resolution = this.settings.de_resolution;
        s.distMatrix = this.settings.distMatrix;
        s.dmDist = this.settings.dmDist;
        s.FCNrows = this.settings.FCNrows;
        s.som_maxGrid = 20;
        s.htmlOut = false;
        s.textOut = false;
        String[] attrArray = new String[this.dataAttributes.size()];
        int att = 0;
        for (String attribute : this.dataAttributes) {
            attrArray[att++] = "node." + attribute;
        }
        Matrix matrix = new Matrix(this.network, attrArray, false, this.ignoreMissing, this.selectedOnly);
        this.nodes = !this.selectedOnly ? this.network.getNodeList() : CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        s.input = new dataItem[matrix.nRows()];
        HashMap<String, Integer> key = new HashMap<String, Integer>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String id = ModelUtils.getNodeName(this.network, this.nodes.get(i));
            if (key.containsKey(id)) continue;
            key.put(id, i);
        }
        int itor = 0;
        for (int k = 0; k < matrix.nRows(); ++k) {
            float[] f = new float[matrix.nColumns()];
            if (k == 0) {
                s.columnHeaders = new String[f.length + 1];
                s.columnHeaders[0] = "NAME";
            }
            for (int l = 0; l < f.length; ++l) {
                if (k == 0) {
                    s.columnHeaders[l + 1] = matrix.getColLabel(l);
                    s.columnHeaders[l + 1] = s.columnHeaders[l + 1].replace("\"", "");
                    s.columnHeaders[l + 1] = s.columnHeaders[l + 1].replace(",", "");
                }
                if (matrix.getValue(k, l) != null) {
                    f[l] = matrix.getValue(k, l).floatValue();
                    continue;
                }
                f[l] = -1.0E8f;
                s.fillMissing = true;
            }
            s.input[itor++] = new dataItem(f, matrix.getRowLabel(k));
        }
        if (s.FCNrows && s.distMatrix) {
            s = this.transpose(s);
        }
        if (s.input == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Insufficient data for clustering (1 or less rows or columns)");
            return null;
        }
        if (s.input.length < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Insufficient data for clustering (1 or less rows or columns)");
            return null;
        }
        if (s.input[0].getValues() == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Insufficient data for clustering (1 or less rows or columns)");
            return null;
        }
        if (s.input[0].getValues().length < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Insufficient data for clustering (1 or less rows or columns)");
            return null;
        }
        this.autRun = new Run();
        this.cr = this.autRun.runAutoSOMEBasic(s, monitor);
        if (this.cr == null) {
            monitor.setStatusMessage("Clustering failed!");
            return null;
        }
        monitor.setStatusMessage("Assigning nodes to clusters");
        this.clusterCount = this.cr.c.length;
        Map<NodeCluster, NodeCluster> map = cMap = !s.distMatrix ? this.getNodeClusters(this.cr, key, matrix, s) : this.getNodeClustersFCN(this.cr, matrix, s);
        if (this.canceled) {
            monitor.setStatusMessage("canceled");
            return null;
        }
        monitor.setStatusMessage("Created " + this.clusterCount + " clusters");
        if (this.clusterCount == 0) {
            monitor.showMessage(TaskMonitor.Level.WARN, "Created 0 clusters!!!!");
            return null;
        }
        Set<NodeCluster> clusters = cMap.keySet();
        return new ArrayList<NodeCluster>(clusters);
    }

    private Map<NodeCluster, NodeCluster> getNodeClusters(clusterRun cr, Map<String, Integer> key, Matrix matrix, Settings s) {
        int i;
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        this.attrList = new ArrayList();
        this.attrOrderList = new ArrayList();
        this.nodeOrderList = new ArrayList();
        for (i = 0; i < matrix.nColumns(); ++i) {
            this.attrOrderList.add(matrix.getColLabel(i));
        }
        for (i = 0; i < this.clusterCount; ++i) {
            if (cr.c[i].ids.isEmpty()) continue;
            NodeCluster nc = new NodeCluster();
            nc.setClusterNumber(i);
            for (int j = 0; j < cr.c[i].ids.size(); ++j) {
                int dataID = cr.c[i].ids.get(j);
                int nodeDataID = key.get(matrix.getRowLabels()[dataID]);
                CyNode cn = this.nodes.get(nodeDataID);
                nc.add(cn);
                this.attrList.add(ModelUtils.getNodeName(this.network, cn) + "\t" + i);
                this.nodeOrderList.add(ModelUtils.getNodeName(this.network, cn));
            }
            cMap.put(nc, nc);
        }
        return cMap;
    }

    private Map<NodeCluster, NodeCluster> getNodeClustersFCN(clusterRun cr, Matrix matrix, Settings s) {
        int i;
        this.attrList = new ArrayList();
        this.attrOrderList = new ArrayList();
        this.nodeOrderList = new ArrayList();
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        this.storeNodes = new HashMap<String, CyNode>();
        this.storeClust = new HashMap<String, String>();
        int currClust = -1;
        NodeCluster nc = new NodeCluster();
        HashMap<String, CyNode> storeOrigNodes = new HashMap<String, CyNode>();
        for (i = 0; i < this.nodes.size(); ++i) {
            CyNode cn = this.nodes.get(i);
            storeOrigNodes.put(ModelUtils.getNodeName(this.network, cn), cn);
        }
        if (!s.FCNrows) {
            for (i = 1; i < s.columnHeaders.length; ++i) {
                this.attrOrderList.add(s.columnHeaders[i]);
            }
        } else {
            for (i = 0; i < matrix.nColumns(); ++i) {
                this.attrOrderList.add(matrix.getColLabel(i));
            }
        }
        for (i = 0; i < cr.fcn_nodes.length; ++i) {
            String[] fcn = cr.fcn_nodes[i];
            if (currClust != Integer.valueOf(fcn[1])) {
                if (nc.size() > 0) {
                    cMap.put(nc, nc);
                }
                nc = new NodeCluster();
                currClust = Integer.valueOf(fcn[1]);
                nc.setClusterNumber(currClust);
            }
            String temp = fcn[0];
            String[] tokens = temp.split("_");
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < tokens.length - 1; ++j) {
                sb.append(tokens[j] + "_");
            }
            temp = sb.substring(0, sb.length() - 1);
            CyNode cn = this.network.addNode();
            this.network.getRow((CyIdentifiable)cn).set("name", (Object)temp);
            this.network.getRow((CyIdentifiable)cn).set("shared name", (Object)temp);
            this.nodeOrderList.add(temp);
            this.attrList.add(temp + "\t" + currClust);
            if (s.FCNrows) {
                CyNode orig = (CyNode)storeOrigNodes.get(fcn[2]);
                CyTable nodeAttrs = this.network.getDefaultNodeTable();
                Set atts = CyTableUtil.getColumnNames((CyTable)nodeAttrs);
                for (String attribute : atts) {
                    Class type = nodeAttrs.getColumn(attribute).getType();
                    Object att = nodeAttrs.getRow((Object)orig).getRaw(attribute);
                    if (att == null) continue;
                    nodeAttrs.getRow((Object)cn).set(attribute, att);
                }
            }
            this.storeNodes.put(fcn[0], cn);
            this.storeClust.put(fcn[0], fcn[1]);
            nc.add(cn);
        }
        if (nc.size() > 0) {
            cMap.put(nc, nc);
        }
        return cMap;
    }

    public List<CyEdge> getEdges(int MAXEDGES) {
        int i;
        this.edges = new ArrayList<CyEdge>();
        Object[] se = new sortEdges[this.cr.fcn_edges.length];
        HashMap<String, Integer> hmEdges = new HashMap<String, Integer>();
        for (i = 0; i < this.cr.fcn_edges.length; ++i) {
            se[i] = new sortEdges(this.cr.fcn_edges[i][0], this.cr.fcn_edges[i][1], Double.valueOf(this.cr.fcn_edges[i][2]));
        }
        Arrays.sort(se);
        for (i = 0; i < se.length; ++i) {
            this.cr.fcn_edges[i] = new String[]{((sortEdges)se[i]).n1, ((sortEdges)se[i]).n2, String.valueOf(((sortEdges)se[i]).weight)};
            if (!this.storeClust.get(this.cr.fcn_edges[i][0]).toString().equals(this.storeClust.get(this.cr.fcn_edges[i][1]).toString())) continue;
            hmEdges.put(this.cr.fcn_edges[i][0], i);
        }
        HashMap<Integer, Integer> edgeIDs = new HashMap<Integer, Integer>();
        ArrayList<String[]> allEdges = new ArrayList<String[]>();
        for (String edge : hmEdges.keySet()) {
            int edgeID = (Integer)hmEdges.get(edge);
            allEdges.add(this.cr.fcn_edges[edgeID]);
            if (edgeIDs.containsKey(edgeID)) continue;
            edgeIDs.put(edgeID, edgeID);
        }
        int itor = 0;
        while (allEdges.size() < Math.min(this.cr.fcn_edges.length, MAXEDGES)) {
            if (edgeIDs.containsKey(itor)) {
                ++itor;
                continue;
            }
            allEdges.add(this.cr.fcn_edges[itor++]);
        }
        for (int j = 0; j < allEdges.size(); ++j) {
            String[] fce = (String[])allEdges.get(j);
            CyNode c1 = this.storeNodes.get(fce[0]);
            CyNode c2 = this.storeNodes.get(fce[1]);
            CyEdge edge = this.network.addEdge(c1, c2, false);
            this.network.getDefaultEdgeTable().getRow((Object)edge).set("name", (Object)fce[2]);
            this.edges.add(edge);
        }
        return this.edges;
    }

    private Settings transpose(Settings s) {
        float[][] t = new float[s.input[0].getValues().length][s.input.length];
        for (int i = 0; i < s.input.length; ++i) {
            for (int j = 0; j < s.input[i].getValues().length; ++j) {
                t[j][i] = s.input[i].getValues()[j];
            }
        }
        dataItem[] d = new dataItem[t.length];
        for (int i = 0; i < d.length; ++i) {
            String label = new String();
            if (s.columnHeaders != null && s.columnHeaders[i + s.startData] != null) {
                label = s.columnHeaders[i + s.startData].replace(" ", "_");
            }
            d[i] = new dataItem(t[i], label);
        }
        String[] cols = new String[s.input.length + 1];
        cols[0] = "NAME";
        for (int i = 0; i < s.input.length; ++i) {
            cols[i + 1] = s.input[i].getIdentity();
        }
        s.input = d;
        s.columnHeaders = cols;
        return s;
    }

    private void debugln(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private void debugln() {
        if (this.debug) {
            System.out.println();
        }
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.print(message);
        }
    }

    class sortEdges
    implements Comparable {
        String n1;
        String n2;
        double weight;

        public sortEdges(String n1, String n2, double weight) {
            this.n1 = n1;
            this.n2 = n2;
            this.weight = weight;
        }

        public int compareTo(Object o) {
            double dist2 = ((sortEdges)o).weight;
            return this.weight > dist2 ? -1 : (this.weight == dist2 ? 0 : 1);
        }
    }
}

