/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.cluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class clusterValidity {
    ArrayList[] orig;
    ArrayList[] clusters;
    List<Integer>[] clustData;
    Settings s;

    public clusterValidity(ArrayList[] orig, ArrayList[] clusters, List<Integer>[] clustData, Settings s) {
        this.orig = orig;
        this.clusters = clusters;
        this.clustData = clustData;
        this.s = s;
    }

    public clusterValidity(ArrayList[] orig, cluster[] c, Settings s) {
        this.orig = orig;
        this.clusters = new ArrayList[c.length];
        this.clustData = new ArrayList[c.length];
        this.s = s;
        for (int i = 0; i < c.length; ++i) {
            this.clusters[i] = new ArrayList();
            this.clustData[i] = new ArrayList<Integer>();
            this.clustData[i] = c[i].ids;
            for (int j = 0; j < c[i].ids.size(); ++j) {
                double[] d = new double[1];
                String[] tokens = s.input[Integer.valueOf(c[i].ids.get(j).toString())].getIdentity().split(",");
                d[0] = Integer.valueOf(tokens[0]).intValue();
                this.clusters[i].add(d);
            }
        }
    }

    public double[] Fmeasure() {
        double F = 0.0;
        int n = 0;
        int[][] hits = new int[this.clusters.length][this.orig.length];
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].size(); ++j) {
                ++n;
                double[] id = (double[])this.clusters[i].get(j);
                int[] nArray = hits[i];
                int n2 = (int)id[0] - 1;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        double avePrec = 0.0;
        double aveRec = 0.0;
        for (int i = 0; i < this.orig.length; ++i) {
            double Fj = 0.0;
            double Fp = 0.0;
            double Fr = 0.0;
            for (int j = 0; j < this.clusters.length; ++j) {
                double rec;
                double prec;
                double temp;
                if (this.clusters[j].size() == 0 || !((temp = 2.0 * (prec = (double)hits[j][i] / (double)this.clusters[j].size()) * (rec = (double)hits[j][i] / (double)this.orig[i].size()) / (prec + rec)) > Fj)) continue;
                Fj = temp;
                Fp = prec;
                Fr = rec;
            }
            F += (double)this.orig[i].size() / (double)n * Fj;
            avePrec += (double)this.orig[i].size() / (double)n * Fp;
            aveRec += (double)this.orig[i].size() / (double)n * Fr;
        }
        double[] all = new double[]{F, avePrec, aveRec};
        return all;
    }

    public double NMI() {
        int k;
        double NMI = 0.0;
        int n = 0;
        int[][] hits = new int[this.clusters.length][this.orig.length];
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].size(); ++j) {
                ++n;
                double[] id = (double[])this.clusters[i].get(j);
                int[] nArray = hits[i];
                int n2 = (int)id[0] - 1;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        double numerator = 0.0;
        double denominator1 = 0.0;
        double denominator2 = 0.0;
        for (k = 0; k < this.clusters.length; ++k) {
            if (this.clusters[k].size() == 0) continue;
            for (int g = 0; g < this.orig.length; ++g) {
                double nlstar;
                double nlh = hits[k][g];
                double nstarh = this.orig[g].size();
                double add = nlh * (Math.log(nlh * (double)n / (nstarh * (nlstar = (double)this.clusters[k].size()))) / Math.log(2.0));
                if (Double.isNaN(add)) {
                    add = 0.0;
                }
                numerator += add;
            }
        }
        for (int g = 0; g < this.orig.length; ++g) {
            double nstarh = this.orig[g].size();
            denominator1 += nstarh * (Math.log(nstarh / (double)n) / Math.log(2.0));
        }
        for (k = 0; k < this.clusters.length; ++k) {
            if (this.clusters[k].size() == 0) continue;
            double nlstar = this.clusters[k].size();
            denominator2 += nlstar * (Math.log(nlstar / (double)n) / Math.log(2.0));
        }
        NMI = numerator / Math.sqrt(denominator1 * denominator2);
        return NMI;
    }

    public double adjRand() {
        int i;
        double adjRand = 0.0;
        int n = 0;
        int[][] hits = new int[this.clusters.length][this.orig.length];
        for (int i2 = 0; i2 < this.clusters.length; ++i2) {
            for (int j = 0; j < this.clusters[i2].size(); ++j) {
                ++n;
                double[] id = (double[])this.clusters[i2].get(j);
                int[] nArray = hits[i2];
                int n2 = (int)id[0] - 1;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        int nijF = 0;
        int niF = 0;
        int njF = 0;
        double nF = Math.pow(this.factorial(n) / 2, -1.0);
        for (i = 0; i < this.clusters.length; ++i) {
            niF += this.factorial(this.clusters[i].size()) / 2;
        }
        for (int j = 0; j < this.orig.length; ++j) {
            njF += this.factorial(this.orig[j].size()) / 2;
        }
        for (i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.orig.length; ++j) {
                nijF += this.factorial(hits[i][j]) / 2;
            }
        }
        adjRand = ((double)nijF - (double)(niF * njF) * nF) / (0.5 * (double)(niF + njF) - (double)(niF * njF) * nF);
        return adjRand;
    }

    public int factorial(int n) {
        int f = n;
        f *= f - 1;
        return f;
    }

    public double DunnIndex() {
        int i;
        double Dunn = Double.MAX_VALUE;
        double[][] centroid = new double[this.clusters.length][3];
        for (i = 0; i < this.clusters.length; ++i) {
            double maxR = 0.0;
            for (int j = 0; j < this.clusters[i].size() - 1; ++j) {
                for (int k = j + 1; k < this.clusters[i].size(); ++k) {
                    double[] coor2;
                    double[] coor1 = (double[])this.clusters[i].get(j);
                    double dist = this.Euc(coor1, coor2 = (double[])this.clusters[i].get(k), true);
                    if (!(dist > maxR)) continue;
                    maxR = dist;
                }
            }
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (int w = 0; w < this.clusters[i].size(); ++w) {
                double[] coor = (double[])this.clusters[i].get(w);
                x += coor[1];
                y += coor[2];
                z += coor[3];
            }
            centroid[i][0] = x / (double)this.clusters[i].size();
            centroid[i][1] = y / (double)this.clusters[i].size();
            centroid[i][2] = z / (double)this.clusters[i].size();
        }
        for (i = 0; i < this.clusters.length - 1; ++i) {
            for (int j = i + 1; j < this.clusters.length; ++j) {
                double temp = this.Euc(centroid[i], centroid[j], false);
                if (!(temp < Dunn)) continue;
                Dunn = temp;
            }
        }
        return Dunn;
    }

    private double Euc(double[] coor1, double[] coor2, boolean One) {
        int i;
        double dist = 0.0;
        int n = i = One ? 1 : 0;
        while (i < coor1.length) {
            dist += Math.pow(coor1[i] - coor2[i], 2.0);
            ++i;
        }
        return Math.sqrt(dist);
    }

    public double ICV() {
        double icv = 0.0;
        for (int i = 0; i < this.clustData.length; ++i) {
            int j;
            if (this.clustData[i].size() == 0) continue;
            StringTokenizer st = new StringTokenizer(this.clustData[i].get(0).toString(), ",");
            double[] cen = new double[st.countTokens() - 1];
            st.nextToken();
            int itor = 0;
            while (st.hasMoreTokens()) {
                cen[itor++] = Double.valueOf(st.nextToken());
            }
            for (j = 1; j < this.clustData[i].size(); ++j) {
                st = new StringTokenizer(this.clustData[i].get(j).toString(), ",");
                st.nextToken();
                itor = 0;
                while (st.hasMoreTokens()) {
                    int n = itor++;
                    cen[n] = cen[n] + Double.valueOf(st.nextToken());
                }
            }
            int k = 0;
            while (k < cen.length) {
                int n = k++;
                cen[n] = cen[n] / (double)this.clustData[i].size();
            }
            for (j = 0; j < this.clustData[i].size(); ++j) {
                st = new StringTokenizer(this.clustData[i].get(j).toString(), ",");
                st.nextToken();
                itor = 0;
                while (st.hasMoreTokens()) {
                    icv += Math.pow(cen[itor++] - Double.valueOf(st.nextToken()), 2.0);
                }
            }
        }
        return Math.sqrt(icv);
    }
}

