/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.Point;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.cluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.clusterRun;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class getClusters {
    private List<Integer> currClust = new ArrayList<Integer>();
    private double[][] edges;
    private Point[] nodes;
    List<Integer>[] ids;
    private double edgesThresh;
    private double maxDist = 0.0;
    private cluster[] clusters;
    private List<Integer>[] origClusters;
    private boolean noThresh = false;
    private boolean[] validEdge;
    private boolean[] usedEdges;
    private clusterRun cr;
    private Settings s;

    public getClusters(clusterRun cr, Settings s) {
        this.cr = cr;
        this.edges = cr.edges;
        this.nodes = cr.nodes;
        this.ids = cr.ids;
        this.clusters = cr.c;
        this.edgesThresh = cr.thresh;
        this.usedEdges = cr.usedEdges;
        this.s = s;
    }

    public getClusters(clusterRun cr, boolean[] validEdge, Settings s) {
        this.validEdge = validEdge;
        this.noThresh = true;
        this.edges = cr.edges;
        this.nodes = cr.nodes;
        this.ids = cr.ids;
        this.edgesThresh = 0.0;
        this.usedEdges = cr.usedEdges;
        this.s = s;
    }

    public void findClusters(boolean general) {
        int i;
        boolean[] used = new boolean[this.nodes.length];
        for (int i2 = 0; i2 < used.length; ++i2) {
            used[i2] = false;
        }
        ArrayList clust = new ArrayList();
        ArrayList clustLabels = new ArrayList();
        ArrayList clustIDs = new ArrayList();
        ArrayList allNodes = new ArrayList();
        for (int j = 0; j < this.edges.length; ++j) {
            if (!(this.edges[j][2] > this.maxDist)) continue;
            this.maxDist = this.edges[j][2];
        }
        int max = 0;
        for (i = 0; i < this.nodes.length; ++i) {
            if (used[i]) continue;
            this.connected(i);
            ArrayList<double[]> allIndices = new ArrayList<double[]>();
            ArrayList allLabels = new ArrayList();
            ArrayList<Integer> allIDs = new ArrayList<Integer>();
            ArrayList indices = new ArrayList();
            for (int index : this.currClust) {
                if (!general) {
                    double[] info = new double[this.nodes[index].getPoint().length];
                    for (int k = 0; k < info.length; ++k) {
                        info[k] = this.nodes[index].getPoint()[k];
                    }
                    allIndices.add(info);
                } else {
                    for (int h = 0; h < this.ids[index].size(); ++h) {
                        int label;
                        double[] info = new double[this.nodes[index].getPoint().length + 1];
                        info[0] = index;
                        for (int k = 1; k < info.length; ++k) {
                            info[k] = this.nodes[index].getPoint()[k - 1];
                        }
                        int id = this.ids[index].get(h);
                        String[] tokens = this.s.input[id].getDesc().split(",");
                        if (this.s.benchmark && (label = Integer.valueOf(tokens[0]).intValue()) > max) {
                            max = label;
                        }
                        allIndices.add(info);
                        allIDs.add(this.ids[index].get(h));
                    }
                }
                used[index] = true;
            }
            allNodes.add(indices);
            clust.add(allIndices);
            clustLabels.add(allLabels);
            clustIDs.add(allIDs);
            this.currClust.clear();
        }
        this.clusters = new cluster[clust.size()];
        for (i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = new cluster((List)clust.get(i), (List)clustLabels.get(i), (List)clustIDs.get(i), (List)allNodes.get(i));
            if (!this.s.benchmark) continue;
            this.origClusters = (List[])Array.newInstance(List.class, max);
            if (!general) continue;
            for (int j = 0; j < this.clusters[i].labels.size(); ++j) {
                String[] tokens = this.clusters[i].labels.get(j).toString().split(",");
                int label = Integer.valueOf(tokens[0]);
                if (this.origClusters[label - 1] == null) {
                    this.origClusters[label - 1] = new ArrayList<Integer>();
                }
                this.origClusters[label - 1].add(label);
            }
        }
        this.currClust.clear();
    }

    private void connected(int i) {
        this.currClust.add(i);
        this.DFS(i, -1);
    }

    private boolean DFS(int node, int last) {
        boolean valid = false;
        for (int i = 0; i < this.edges.length; ++i) {
            if ((int)this.edges[i][0] == node && (int)this.edges[i][1] == last || (int)this.edges[i][1] == node && (int)this.edges[i][0] == last || (int)this.edges[i][0] != node && (int)this.edges[i][1] != node) continue;
            if ((int)this.edges[i][0] == node && (this.edges[i][2] <= this.edgesThresh * this.maxDist || this.noThresh && this.validEdge[i])) {
                this.currClust.add((int)this.edges[i][1]);
                this.usedEdges[i] = true;
                this.DFS((int)this.edges[i][1], node);
            }
            if ((int)this.edges[i][1] != node || !(this.edges[i][2] <= this.edgesThresh * this.maxDist) && (!this.noThresh || !this.validEdge[i])) continue;
            this.currClust.add((int)this.edges[i][0]);
            this.usedEdges[i] = true;
            this.DFS((int)this.edges[i][0], node);
        }
        return valid;
    }

    public cluster[] getClust() {
        return this.clusters;
    }
}

